/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.manager;

import android.content.Context;
import android.graphics.Bitmap;
import com.onyx.android.sdk.common.request.BaseCallback;
import com.onyx.android.sdk.data.CloudStore;
import com.onyx.android.sdk.data.model.WeChatUserInfo;
import com.onyx.android.sdk.data.request.cloud.AccountGetOAuthCodeRequest;
import com.onyx.android.sdk.data.request.cloud.WeChatOauthRequest;
import com.onyx.android.sdk.data.request.cloud.WeChatUserInfoRequest;
import com.onyx.android.sdk.utils.BitmapUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelmsg.SendAuth;
import com.tencent.mm.opensdk.modelmsg.SendMessageToWX;
import com.tencent.mm.opensdk.modelmsg.WXImageObject;
import com.tencent.mm.opensdk.modelmsg.WXMediaMessage;
import com.tencent.mm.opensdk.modelmsg.WXMusicObject;
import com.tencent.mm.opensdk.modelmsg.WXTextObject;
import com.tencent.mm.opensdk.modelmsg.WXVideoObject;
import com.tencent.mm.opensdk.modelmsg.WXWebpageObject;
import com.tencent.mm.opensdk.openapi.IWXAPI;
import com.tencent.mm.opensdk.openapi.WXAPIFactory;

public class WeChatManager {
    public static final String WE_CHAT_LOGIN_OAUTH_ACTION = "we_chat_login_oauth_action";
    private static String WX_APP_ID = "";
    private static String WX_APP_Secret = "";
    private static WeChatManager globalInstance;
    private IWXAPI weChatApi;
    private String respCode;

    private WeChatManager(Context context) {
        this.initWeChatApi(context);
    }

    private void initWeChatApi(Context context) {
        this.weChatApi = WXAPIFactory.createWXAPI((Context)context, (String)WX_APP_ID, (boolean)true);
        this.weChatApi.registerApp(WX_APP_ID);
    }

    public static WeChatManager sharedInstance(Context context) {
        if (globalInstance == null) {
            globalInstance = new WeChatManager(context);
        }
        return globalInstance;
    }

    public static WeChatManager sharedInstance(Context context, String appId, String AppSecret) {
        if (globalInstance == null) {
            WX_APP_ID = appId;
            WX_APP_Secret = AppSecret;
            globalInstance = WeChatManager.sharedInstance(context);
        }
        return globalInstance;
    }

    public IWXAPI getWeChatApi() {
        return this.weChatApi;
    }

    public void sendWeChatAuthRequest(Context context) {
        if (this.weChatApi == null) {
            this.initWeChatApi(context);
        }
        SendAuth.Req req = new SendAuth.Req();
        req.scope = "snsapi_userinfo";
        req.state = "wx_login_onyx";
        this.weChatApi.sendReq((BaseReq)req);
    }

    public boolean sendWeChatTokenRequest(CloudStore cloudStore, Context context, BaseCallback callback) {
        if (StringUtils.isNullOrEmpty((String)this.respCode)) {
            return false;
        }
        WeChatOauthRequest request = new WeChatOauthRequest(WX_APP_ID, WX_APP_Secret, this.respCode);
        cloudStore.submitRequest(context, request, callback);
        return true;
    }

    public boolean sendWeChatUserInfoRequest(CloudStore cloudStore, Context context, String token, String openId, BaseCallback callback) {
        if (StringUtils.isNullOrEmpty((String)token) || StringUtils.isNullOrEmpty((String)openId)) {
            return false;
        }
        WeChatUserInfoRequest request = new WeChatUserInfoRequest(token, openId);
        cloudStore.submitRequest(context, request, callback);
        return true;
    }

    public boolean sendOnyxOAuthCodeRequest(CloudStore cloudStore, Context context, WeChatUserInfo userInfo, BaseCallback callback) {
        AccountGetOAuthCodeRequest getOAuthCodeRequest = new AccountGetOAuthCodeRequest("wechat", userInfo.createOAuthAccountData());
        cloudStore.submitRequest(context, getOAuthCodeRequest, callback);
        return true;
    }

    public void shareText(MediaBuilder mediaBuilder) {
        WXTextObject textObj = new WXTextObject();
        textObj.text = mediaBuilder.getContent();
        WXMediaMessage msg = this.obtainWXMediaMessage(mediaBuilder, (WXMediaMessage.IMediaObject)textObj);
        this.sendMessageToWX(msg, mediaBuilder);
    }

    public void shareImage(MediaBuilder mediaBuilder) {
        WXImageObject imgObj = new WXImageObject(mediaBuilder.getImageBitmap());
        WXMediaMessage msg = this.obtainWXMediaMessage(mediaBuilder, (WXMediaMessage.IMediaObject)imgObj);
        this.sendMessageToWX(msg, mediaBuilder);
    }

    public void shareWebPage(MediaBuilder mediaBuilder) {
        WXWebpageObject webPageObject = new WXWebpageObject();
        webPageObject.webpageUrl = mediaBuilder.getUrl();
        WXMediaMessage msg = this.obtainWXMediaMessage(mediaBuilder, (WXMediaMessage.IMediaObject)webPageObject);
        this.sendMessageToWX(msg, mediaBuilder);
    }

    public void shareMusic(MediaBuilder mediaBuilder) {
        WXMusicObject musicObject = new WXMusicObject();
        musicObject.musicUrl = mediaBuilder.getUrl();
        WXMediaMessage msg = this.obtainWXMediaMessage(mediaBuilder, (WXMediaMessage.IMediaObject)musicObject);
        this.sendMessageToWX(msg, mediaBuilder);
    }

    public void shareVideo(MediaBuilder mediaBuilder) {
        WXVideoObject videoObject = new WXVideoObject();
        videoObject.videoUrl = mediaBuilder.getUrl();
        WXMediaMessage msg = this.obtainWXMediaMessage(mediaBuilder, (WXMediaMessage.IMediaObject)videoObject);
        this.sendMessageToWX(msg, mediaBuilder);
    }

    public boolean sendMessageToWX(WXMediaMessage msg, MediaBuilder mediaBuilder) {
        SendMessageToWX.Req req = new SendMessageToWX.Req();
        req.transaction = mediaBuilder.getTransaction() == null ? String.valueOf(System.currentTimeMillis()) : null;
        req.message = msg;
        req.scene = mediaBuilder.getScene();
        return this.getWeChatApi().sendReq((BaseReq)req);
    }

    private WXMediaMessage obtainWXMediaMessage(MediaBuilder builder, WXMediaMessage.IMediaObject mediaObject) {
        WXMediaMessage msg = new WXMediaMessage(mediaObject);
        msg.title = builder.getTitle();
        msg.description = builder.getDescription();
        Bitmap thumbBitmap = builder.buildThumbnailBitmap();
        if (thumbBitmap != null) {
            msg.thumbData = BitmapUtils.bitmapToBytes((Bitmap)thumbBitmap);
        }
        return msg;
    }

    public String getRespCode() {
        return this.respCode;
    }

    public String getRespCodeAndReset() {
        String returnCode = this.respCode;
        this.respCode = null;
        return returnCode;
    }

    public void setRespCode(String respCode) {
        this.respCode = respCode;
    }

    public String getWxAppId() {
        return WX_APP_ID;
    }

    public String getWxAppSecret() {
        return WX_APP_Secret;
    }

    public static class MediaBuilder {
        private static final int DEFAULT_THUMBNAIL_SIZE = 180;
        private String title;
        private String content;
        private String description;
        private String url;
        private Bitmap imageBitmap;
        private int thumbWidth = 180;
        private int thumbHeight = 180;
        private int scene = 1;
        private String transaction;

        public MediaBuilder setTitle(String text) {
            this.title = text;
            return this;
        }

        public MediaBuilder setContent(String text) {
            this.content = text;
            return this;
        }

        public MediaBuilder setDescription(String text) {
            this.description = text;
            return this;
        }

        public MediaBuilder setImageBitmap(Bitmap bitmap) {
            this.imageBitmap = bitmap;
            return this;
        }

        public MediaBuilder setThumbnailSize(int width, int height) {
            this.thumbWidth = width;
            this.thumbHeight = height;
            return this;
        }

        public MediaBuilder setScene(int scene) {
            this.scene = scene;
            return this;
        }

        public MediaBuilder setUrl(String url) {
            this.url = url;
            return this;
        }

        public String getTitle() {
            return this.title;
        }

        public String getContent() {
            return this.content;
        }

        public String getDescription() {
            return this.description;
        }

        public String getUrl() {
            return this.url;
        }

        public Bitmap getImageBitmap() {
            return this.imageBitmap;
        }

        public int getThumbWidth() {
            return this.thumbWidth;
        }

        public int getThumbHeight() {
            return this.thumbHeight;
        }

        public int getScene() {
            return this.scene;
        }

        public String getTransaction() {
            return this.transaction;
        }

        public Bitmap buildThumbnailBitmap() {
            if (this.imageBitmap == null) {
                return null;
            }
            return Bitmap.createScaledBitmap((Bitmap)this.imageBitmap, (int)this.thumbWidth, (int)this.thumbHeight, (boolean)true);
        }
    }
}

