/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.manager;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Log;
import com.alibaba.sdk.android.oss.ClientException;
import com.alibaba.sdk.android.oss.OSS;
import com.alibaba.sdk.android.oss.OSSClient;
import com.alibaba.sdk.android.oss.ServiceException;
import com.alibaba.sdk.android.oss.callback.OSSCompletedCallback;
import com.alibaba.sdk.android.oss.callback.OSSProgressCallback;
import com.alibaba.sdk.android.oss.common.auth.OSSCredentialProvider;
import com.alibaba.sdk.android.oss.common.auth.OSSPlainTextAKSKCredentialProvider;
import com.alibaba.sdk.android.oss.internal.OSSAsyncTask;
import com.alibaba.sdk.android.oss.model.OSSRequest;
import com.alibaba.sdk.android.oss.model.PutObjectRequest;
import com.alibaba.sdk.android.oss.model.PutObjectResult;
import com.onyx.android.sdk.common.request.BaseCallback;
import com.onyx.android.sdk.common.request.BaseRequest;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.utils.FileUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class OssManager {
    private OSS ossClient;
    private OssConfig ossConfig;
    private Handler handler = new Handler(Looper.getMainLooper());
    private static Map<OssWrapRequest, BaseCallback.ProgressInfo> progressMap = new HashMap<OssWrapRequest, BaseCallback.ProgressInfo>();

    public OssManager(Context context, @NonNull OssConfig config) {
        this.ossClient = OssManager.buildOssClient(context, config);
        this.setOssConfig(config);
    }

    private void setOssConfig(OssConfig config) {
        this.ossConfig = new OssConfig();
        this.ossConfig.setBucketName(config.getBucketName());
        this.ossConfig.setEndPoint(config.getEndPoint());
    }

    private static OSSClient buildOssClient(Context context, OssConfig ossConfig) {
        OSSPlainTextAKSKCredentialProvider credentialProvider = new OSSPlainTextAKSKCredentialProvider(ossConfig.getKeyId(), ossConfig.getKeySecret());
        return new OSSClient(context.getApplicationContext(), ossConfig.getEndPoint(), (OSSCredentialProvider)credentialProvider);
    }

    public OSS getOssClient() {
        return this.ossClient;
    }

    public OssConfig getOssConfig() {
        return this.ossConfig;
    }

    public String getOssBucketName() {
        return this.ossConfig.getBucketName();
    }

    public String getOssEndPoint() {
        return this.ossConfig.getEndPoint();
    }

    public String getOssFileObjectKey(String fileName) {
        String objectKey = UUID.randomUUID().toString().replaceAll("-", "") + "." + FileUtils.getFileExtension((String)fileName);
        Log.d((String)"oss-objectKey", (String)String.valueOf(objectKey));
        return objectKey;
    }

    private PutObjectRequest getPutObjectRequest(String bucketName, String uploadFilePath) {
        return new PutObjectRequest(bucketName, this.getOssFileObjectKey(uploadFilePath), uploadFilePath);
    }

    public void asyncUploadFile(Context context, String uploadFilePath, BaseCallback callback) {
        this.asyncUploadFile(context, this.getOssBucketName(), uploadFilePath, callback);
    }

    public void asyncUploadFile(Context context, String bucketName, String uploadFilePath, final BaseCallback callback) {
        OSS oss = this.getOssClient();
        PutObjectRequest putRequest = this.getPutObjectRequest(bucketName, uploadFilePath);
        final OssWrapRequest<PutObjectRequest> wrapRequest = new OssWrapRequest<PutObjectRequest>(putRequest);
        putRequest.setProgressCallback((OSSProgressCallback)new OSSProgressCallback<PutObjectRequest>(){

            public void onProgress(PutObjectRequest request, long currentSize, long totalSize) {
                OssManager.this.reportProgress(wrapRequest, callback, currentSize, totalSize);
            }
        });
        OSSAsyncTask task = oss.asyncPutObject(putRequest, (OSSCompletedCallback)new OSSCompletedCallback<PutObjectRequest, PutObjectResult>(){

            public void onSuccess(PutObjectRequest request, PutObjectResult result) {
                OssManager.this.reportTaskDone(wrapRequest, callback, null);
            }

            public void onFailure(PutObjectRequest request, ClientException clientException, ServiceException serviceException) {
                ClientException exception = clientException;
                if (clientException != null) {
                    clientException.printStackTrace();
                }
                if (serviceException != null) {
                    OssManager.this.dumpServiceException(serviceException);
                    exception = serviceException;
                }
                OssManager.this.reportTaskDone(wrapRequest, callback, (Exception)exception);
            }
        });
    }

    public String syncUploadFile(Context context, String uploadFilePath) throws Exception {
        return this.syncUploadFile(context, this.getOssBucketName(), uploadFilePath);
    }

    public String syncUploadFile(Context context, String bucketName, String uploadFilePath) throws Exception {
        PutObjectRequest putRequest = this.getPutObjectRequest(bucketName, uploadFilePath);
        PutObjectResult putResult = this.getOssClient().putObject(putRequest);
        if (putResult.getStatusCode() == 200) {
            return putRequest.getObjectKey();
        }
        return null;
    }

    private BaseCallback.ProgressInfo getProgressInfo(OssWrapRequest request) {
        if (!progressMap.containsKey((Object)request)) {
            BaseCallback.ProgressInfo progressInfo = new BaseCallback.ProgressInfo();
            progressMap.put(request, progressInfo);
        }
        return progressMap.get((Object)request);
    }

    private void removeProgressInfo(OssWrapRequest request) {
        progressMap.remove((Object)request);
    }

    private void reportProgress(final OssWrapRequest ossRequest, final BaseCallback callback, long currentSize, long totalSize) {
        this.dumpProgress(currentSize, totalSize);
        if (callback != null) {
            final BaseCallback.ProgressInfo progressInfo = this.getProgressInfo(ossRequest);
            progressInfo.soFarBytes = currentSize;
            progressInfo.totalBytes = totalSize;
            progressInfo.progress = (float)currentSize * 1.0f / (float)totalSize * 100.0f;
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    callback.progress((BaseRequest)ossRequest, progressInfo);
                }
            });
        }
    }

    private void reportTaskDone(final OssWrapRequest ossRequest, final BaseCallback callback, final Exception exception) {
        this.removeProgressInfo(ossRequest);
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                BaseCallback.invoke((BaseCallback)callback, (BaseRequest)ossRequest, (Throwable)exception);
            }
        });
    }

    private void dumpProgress(long currentSize, long totalSize) {
    }

    private void dumpServiceException(ServiceException serviceException) {
    }

    public static class OssConfig {
        private String keyId;
        private String keySecret;
        private String endPoint;
        private String bucketName;

        public String getKeyId() {
            return this.keyId;
        }

        public void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public String getKeySecret() {
            return this.keySecret;
        }

        public void setKeySecret(String keySecret) {
            this.keySecret = keySecret;
        }

        public String getEndPoint() {
            return this.endPoint;
        }

        public void setEndPoint(String endPoint) {
            this.endPoint = endPoint;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }
    }

    public static class OssWrapRequest<T extends OSSRequest>
    extends BaseCloudRequest {
        private T request;

        public OssWrapRequest(T request) {
            this.request = request;
        }

        public T getRequest() {
            return this.request;
        }

        @Override
        public void execute(CloudManager parent) throws Exception {
        }
    }
}

