/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.compatability;

import android.content.ContentValues;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.provider.BaseColumns;
import android.util.Log;
import com.onyx.android.sdk.data.compatability.CursorUtil;

public class OnyxThumbnail {
    private static final String TAG = "OnyxThumbnail";
    public static final String DB_TABLE_NAME = "library_thumbnail";
    public static final Uri CONTENT_URI = Uri.parse((String)"content://com.onyx.android.sdk.OnyxCmsProvider/library_thumbnail");
    private static final int INVALID_ID = -1;
    private long mId = -1L;
    private String mData = null;
    private String mSourceMD5 = null;
    private ThumbnailKind mThumbnailKind = ThumbnailKind.Original;

    public static Bitmap createLargeThumbnail(Bitmap bmp) {
        return OnyxThumbnail.createThumbnail(bmp, 512);
    }

    public static Bitmap createMiddleThumbnail(Bitmap bmp) {
        return OnyxThumbnail.createThumbnail(bmp, 256);
    }

    public static Bitmap createSmallThumbnail(Bitmap bmp) {
        return OnyxThumbnail.createThumbnail(bmp, 128);
    }

    private static Bitmap createThumbnail(Bitmap bmp, int limit) {
        if (bmp.getWidth() <= limit && bmp.getHeight() <= limit) {
            return bmp;
        }
        int w = limit;
        int h = limit;
        if (bmp.getWidth() >= bmp.getHeight()) {
            double z = (double)limit / (double)bmp.getWidth();
            h = (int)(z * (double)bmp.getHeight());
        } else {
            double z = (double)limit / (double)bmp.getHeight();
            w = (int)(z * (double)bmp.getWidth());
        }
        return Bitmap.createScaledBitmap((Bitmap)bmp, (int)w, (int)h, (boolean)true);
    }

    public long getId() {
        return this.mId;
    }

    public String getData() {
        return this.mData;
    }

    public String getSourceMD5() {
        return this.mSourceMD5;
    }

    public ThumbnailKind getThumbnailKind() {
        return this.mThumbnailKind;
    }

    public static class Columns
    implements BaseColumns {
        public static String _DATA = "_data";
        public static String SOURCE_MD5 = "Source_MD5";
        public static String THUMBNAIL_KIND = "Thumbnail_Kind";
        private static boolean sColumnIndexesInitialized = false;
        private static int sColumnID = -1;
        private static int sColumnDATA = -1;
        private static int sColumnSourceMD5 = -1;
        private static int sColumnThumbnailKind = -1;

        public static ContentValues createColumnData(String sourceMD5, ThumbnailKind thumbnailKind) {
            ContentValues values = new ContentValues();
            values.put(SOURCE_MD5, sourceMD5);
            values.put(THUMBNAIL_KIND, thumbnailKind.toString());
            return values;
        }

        public static OnyxThumbnail readColumnData(Cursor c) {
            if (!sColumnIndexesInitialized) {
                sColumnID = c.getColumnIndex("_id");
                sColumnDATA = c.getColumnIndex(_DATA);
                sColumnSourceMD5 = c.getColumnIndex(SOURCE_MD5);
                sColumnThumbnailKind = c.getColumnIndex(THUMBNAIL_KIND);
                sColumnIndexesInitialized = true;
            }
            long id = CursorUtil.getLong(c, sColumnID);
            String data = CursorUtil.getString(c, sColumnDATA);
            String md5 = CursorUtil.getString(c, sColumnSourceMD5);
            ThumbnailKind tk = ThumbnailKind.Original;
            try {
                tk = Enum.valueOf(ThumbnailKind.class, CursorUtil.getString(c, sColumnThumbnailKind));
            }
            catch (Throwable tr) {
                Log.w((String)OnyxThumbnail.TAG, (String)"exception", (Throwable)tr);
            }
            OnyxThumbnail thumbnail = new OnyxThumbnail();
            thumbnail.mId = id;
            thumbnail.mData = data;
            thumbnail.mSourceMD5 = md5;
            thumbnail.mThumbnailKind = tk;
            return thumbnail;
        }
    }

    public static enum ThumbnailKind {
        Original,
        Large,
        Middle,
        Small;

    }
}

