/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.compatability;

import android.util.Log;

public class OnyxBookProgress {
    private static final String TAG = "OnyxBookProgress";
    private static final int INVALID_ID = -1;
    private long mId = -1L;
    private String mMD5 = null;
    private int mCurrent = 0;
    private int mTotal = 1;

    private OnyxBookProgress() {
    }

    public OnyxBookProgress(int current, int total) {
        if (current < 1) {
            current = 1;
        }
        this.mCurrent = current;
        this.mTotal = total;
    }

    public static OnyxBookProgress fromString(String str) {
        if (str == null) {
            return null;
        }
        String[] array = str.split("/");
        if (array.length != 2) {
            assert (false);
            return new OnyxBookProgress();
        }
        try {
            int current = Integer.parseInt(array[0]);
            int total = Integer.parseInt(array[1]);
            return new OnyxBookProgress(current, total);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"exception", (Throwable)e);
            return new OnyxBookProgress();
        }
    }

    public long getId() {
        return this.mId;
    }

    public void setId(long id) {
        this.mId = id;
    }

    public String getMD5() {
        return this.mMD5;
    }

    public void setMD5(String md5) {
        this.mMD5 = md5;
    }

    public int getCurrent() {
        return this.mCurrent;
    }

    public int getTotal() {
        return this.mTotal;
    }

    public boolean isFinished() {
        return this.mCurrent >= this.mTotal;
    }

    public String toString() {
        return this.mCurrent + "/" + this.mTotal;
    }
}

