/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import android.content.Context;
import android.graphics.Bitmap;
import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.compatability.OnyxThumbnail;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.MetadataCollection;
import com.onyx.android.sdk.data.model.Metadata_Table;
import com.onyx.android.sdk.data.model.Thumbnail;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.provider.DataProviderManager;
import com.onyx.android.sdk.data.utils.ThumbnailUtils;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DataManagerHelper {
    private static DataProviderBase getDataProviderBase() {
        return DataProviderManager.getLocalDataProvider();
    }

    public static void addCollections(Context context, Library library, List<Metadata> addList) {
        DataProviderBase providerBase = DataManagerHelper.getDataProviderBase();
        for (Metadata metadata : addList) {
            providerBase.deleteMetadataCollection(context, library.getParentUniqueId(), metadata.getIdString());
            MetadataCollection collection = new MetadataCollection();
            collection.setLibraryUniqueId(library.getIdString());
            collection.setDocumentUniqueId(metadata.getIdString());
            providerBase.addMetadataCollection(context, collection);
        }
    }

    public static void updateCollections(Context context, String newLibraryUniqueId, String oldLibraryUniqueId) {
        if (newLibraryUniqueId == null) {
            DataManagerHelper.getDataProviderBase().deleteMetadataCollection(context, oldLibraryUniqueId, null);
        } else {
            List<MetadataCollection> collections = DataManagerHelper.getDataProviderBase().loadMetadataCollection(context, oldLibraryUniqueId);
            for (MetadataCollection collection : collections) {
                collection.setLibraryUniqueId(newLibraryUniqueId);
                DataManagerHelper.getDataProviderBase().updateMetadataCollection(collection);
            }
        }
    }

    public static void removeCollections(Context context, Library library, List<Metadata> removeList) {
        for (Metadata metadata : removeList) {
            DataManagerHelper.getDataProviderBase().deleteMetadataCollection(context, library.getIdString(), metadata.getIdString());
            if (library.getParentUniqueId() == null) continue;
            MetadataCollection collection = new MetadataCollection();
            collection.setLibraryUniqueId(library.getParentUniqueId());
            collection.setDocumentUniqueId(metadata.getIdString());
            DataManagerHelper.getDataProviderBase().addMetadataCollection(context, collection);
        }
    }

    public static List<Library> loadLibraryList(DataManager dataManager, List<Library> list, String parentId) {
        List<Library> tmpList = dataManager.getRemoteContentProvider().loadAllLibrary(parentId);
        if (tmpList.size() > 0) {
            list.addAll(tmpList);
        }
        return tmpList;
    }

    public static void loadLibraryRecursive(DataManager dataManager, List<Library> list, String targetId) {
        List<Library> tmpList = DataManagerHelper.loadLibraryList(dataManager, list, targetId);
        for (Library library : tmpList) {
            DataManagerHelper.loadLibraryRecursive(dataManager, list, library.getIdString());
        }
    }

    public static Thumbnail loadThumbnail(Context context, String path, String associationId, OnyxThumbnail.ThumbnailKind kind) {
        if (StringUtils.isNullOrEmpty((String)associationId)) {
            try {
                associationId = FileUtils.computeMD5((File)new File(path));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return DataManagerHelper.getDataProviderBase().getThumbnailEntry(context, associationId, kind);
    }

    public static Bitmap loadThumbnailBitmap(Context context, Thumbnail thumbnail) {
        return DataManagerHelper.getDataProviderBase().getThumbnailBitmap(context, thumbnail.getIdString(), OnyxThumbnail.ThumbnailKind.Original);
    }

    public static List<Bitmap> loadThumbnailBitmapList(Context context, List<File> fileList, int limit, OnyxThumbnail.ThumbnailKind kind) {
        ArrayList<Bitmap> thumbnailList = new ArrayList<Bitmap>();
        Bitmap bitmap = null;
        int thumbCount = 0;
        for (File file : fileList) {
            if (file.isDirectory()) continue;
            Thumbnail thumbnail = DataManagerHelper.loadThumbnail(context, file.getAbsolutePath(), null, kind);
            if (thumbCount++ < Math.min(limit, fileList.size())) {
                bitmap = DataManagerHelper.loadThumbnailBitmap(context, thumbnail);
            }
            thumbnailList.add(bitmap == null ? ThumbnailUtils.loadDefaultThumbnailFromExtension(context, FileUtils.getFileExtension((File)file)) : bitmap);
        }
        return thumbnailList;
    }

    public static Metadata getMetadataByCloudReference(Context context, String cloudReference) {
        return (Metadata)new Select(new IProperty[0]).from(Metadata.class).where(new SQLCondition[]{Metadata_Table.cloudId.eq((Object)cloudReference)}).querySingle();
    }

    public static Metadata getMetadataByHashTag(Context context, String hashTag) {
        return (Metadata)new Select(new IProperty[0]).from(Metadata.class).where(new SQLCondition[]{Metadata_Table.hashTag.eq((Object)hashTag)}).querySingle();
    }

    public static void deleteAllLibrary(Context context, DataManager dataManager, String parentUniqueId, List<Library> libraryList) {
        DataProviderBase providerBase = dataManager.getRemoteContentProvider();
        boolean isDeleteMetaCollection = StringUtils.isNullOrEmpty((String)parentUniqueId);
        for (Library tmp : libraryList) {
            if (isDeleteMetaCollection) {
                providerBase.deleteMetadataCollection(context, tmp.getIdString());
            } else {
                List<MetadataCollection> list = providerBase.loadMetadataCollection(context, tmp.getIdString());
                for (MetadataCollection metadataCollection : list) {
                    metadataCollection.setLibraryUniqueId(parentUniqueId);
                    providerBase.updateMetadataCollection(metadataCollection);
                }
            }
            providerBase.deleteLibrary(tmp);
        }
    }

    public static void deleteMetadataCollection(Context context, DataManager dataManager, String libraryIdString) {
        dataManager.getRemoteContentProvider().deleteMetadataCollection(context, libraryIdString);
    }

    public static MetadataCollection loadMetadataCollection(Context context, DataManager dataManager, String libraryIdString, String metaIdString) {
        return dataManager.getRemoteContentProvider().loadMetadataCollection(context, libraryIdString, metaIdString);
    }

    public static List<MetadataCollection> loadMetadataCollection(Context context, DataManager dataManager, String libraryIdString) {
        return dataManager.getRemoteContentProvider().loadMetadataCollection(context, libraryIdString);
    }
}

