/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.v1;

import com.onyx.android.sdk.data.v1.FastJsonConverterFactory;
import com.onyx.android.sdk.data.v1.OnyxAccountService;
import com.onyx.android.sdk.data.v1.OnyxBookStoreService;
import com.onyx.android.sdk.data.v1.OnyxConsumerService;
import com.onyx.android.sdk.data.v1.OnyxDictionaryService;
import com.onyx.android.sdk.data.v1.OnyxFileDownloadService;
import com.onyx.android.sdk.data.v1.OnyxGroupService;
import com.onyx.android.sdk.data.v1.OnyxHardwareService;
import com.onyx.android.sdk.data.v1.OnyxLogService;
import com.onyx.android.sdk.data.v1.OnyxOTAService;
import com.onyx.android.sdk.data.v1.OnyxPushService;
import com.onyx.android.sdk.data.v1.OnyxStatisticsService;
import java.util.concurrent.ConcurrentHashMap;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class ServiceFactory {
    private static ConcurrentHashMap<String, Retrofit> retrofitMap = new ConcurrentHashMap();

    private static Retrofit getRetrofit(String baseUrl) {
        if (!retrofitMap.containsKey(baseUrl)) {
            Retrofit retrofit = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)FastJsonConverterFactory.create()).build();
            retrofitMap.put(baseUrl, retrofit);
        }
        return retrofitMap.get(baseUrl);
    }

    public static final OnyxAccountService getAccountService(String baseUrl) {
        return ServiceFactory.getSpecifyService(OnyxAccountService.class, baseUrl);
    }

    public static final OnyxBookStoreService getBookStoreService(String baseUrl) {
        return ServiceFactory.getSpecifyService(OnyxBookStoreService.class, baseUrl);
    }

    public static final OnyxDictionaryService getDictionaryService(String baseUrl) {
        return ServiceFactory.getSpecifyService(OnyxDictionaryService.class, baseUrl);
    }

    public static final OnyxHardwareService getHardwareService(String baseUrl) {
        return ServiceFactory.getSpecifyService(OnyxHardwareService.class, baseUrl);
    }

    public static final OnyxOTAService getOTAService(String baseUrl) {
        return ServiceFactory.getSpecifyService(OnyxOTAService.class, baseUrl);
    }

    public static final OnyxFileDownloadService getFileDownloadService(String baseUrl) {
        return ServiceFactory.getSpecifyService(OnyxFileDownloadService.class, baseUrl);
    }

    public static final OnyxConsumerService getConsumerService(String baseUrl) {
        return ServiceFactory.getSpecifyService(OnyxConsumerService.class, baseUrl);
    }

    public static final OnyxGroupService getGroupService(String baseUrl) {
        return ServiceFactory.getSpecifyService(OnyxGroupService.class, baseUrl);
    }

    public static final OnyxPushService getPushService(String baseUrl) {
        return ServiceFactory.getSpecifyService(OnyxPushService.class, baseUrl);
    }

    public static final OnyxStatisticsService getStatisticsService(String baseUrl) {
        return ServiceFactory.getSpecifyService(OnyxStatisticsService.class, baseUrl);
    }

    public static final OnyxLogService getLogService(String baseUrl) {
        return ServiceFactory.getSpecifyService(OnyxLogService.class, baseUrl);
    }

    public static final <T> T getSpecifyService(Class<T> service, String baseUrl) {
        return (T)ServiceFactory.getRetrofit(baseUrl).create(service);
    }
}

