/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import com.onyx.android.sdk.data.compatability.OnyxThumbnail;
import com.onyx.android.sdk.data.model.Thumbnail;
import com.onyx.android.sdk.dataprovider.R;
import com.onyx.android.sdk.device.EnvironmentUtil;
import com.onyx.android.sdk.utils.BitmapUtils;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.StringUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class ThumbnailUtils {
    public static final String thumbnail_folder = ".thumbnails";
    public static final String preferred_extension = ".png";
    private static Map<String, Integer> defaultThumbnailMap = new HashMap<String, Integer>();

    public static Map<String, Integer> defaultThumbnailMapping() {
        if (defaultThumbnailMap == null) {
            defaultThumbnailMap = new HashMap<String, Integer>();
            defaultThumbnailMap.put("acsm", R.drawable.acsm);
            defaultThumbnailMap.put("bmp", R.drawable.bmp);
            defaultThumbnailMap.put("chm", R.drawable.chm);
            defaultThumbnailMap.put("djvu", R.drawable.djvu);
            defaultThumbnailMap.put("doc", R.drawable.doc);
            defaultThumbnailMap.put("docx", R.drawable.docx);
            defaultThumbnailMap.put("eba3", R.drawable.eba3);
            defaultThumbnailMap.put("ebaml", R.drawable.ebaml);
            defaultThumbnailMap.put("epub", R.drawable.epub);
            defaultThumbnailMap.put("fb2", R.drawable.fb2);
            defaultThumbnailMap.put("gif", R.drawable.gif);
            defaultThumbnailMap.put("htm", R.drawable.htm);
            defaultThumbnailMap.put("html", R.drawable.html);
            defaultThumbnailMap.put("jpg", R.drawable.jpg);
            defaultThumbnailMap.put("mobi", R.drawable.mobi);
            defaultThumbnailMap.put("mp3", R.drawable.mp3);
            defaultThumbnailMap.put("pdb", R.drawable.pdb);
            defaultThumbnailMap.put("pdf", R.drawable.pdf);
            defaultThumbnailMap.put("png", R.drawable.png);
            defaultThumbnailMap.put("ppt", R.drawable.ppt);
            defaultThumbnailMap.put("prc", R.drawable.prc);
            defaultThumbnailMap.put("rar", R.drawable.rar);
            defaultThumbnailMap.put("rtf", R.drawable.rtf);
            defaultThumbnailMap.put("tiff", R.drawable.tiff);
            defaultThumbnailMap.put("txt", R.drawable.txt);
            defaultThumbnailMap.put("wma", R.drawable.wma);
            defaultThumbnailMap.put("xls", R.drawable.xls);
            defaultThumbnailMap.put("zip", R.drawable.zip);
            defaultThumbnailMap.put("cbz", R.drawable.cbz);
        }
        return defaultThumbnailMap;
    }

    public static Integer thumbnailUnknown() {
        return R.drawable.unknown_document;
    }

    public static Integer thumbnailDefault() {
        return R.drawable.book_default_cover;
    }

    public static Integer libraryThumbnailDefault() {
        return R.drawable.library_default_cover;
    }

    public static Bitmap loadThumbnail(Context context, int resId) {
        BitmapDrawable drawable2 = (BitmapDrawable)context.getResources().getDrawable(resId);
        return drawable2 == null ? null : drawable2.getBitmap();
    }

    public static Bitmap loadDefaultThumbnailFromExtension(Context context, String ext) {
        if (StringUtils.isNullOrEmpty((String)ext)) {
            return ThumbnailUtils.loadThumbnail(context, ThumbnailUtils.thumbnailUnknown());
        }
        if (ThumbnailUtils.defaultThumbnailMapping().containsKey(ext)) {
            return ThumbnailUtils.loadThumbnail(context, ThumbnailUtils.defaultThumbnailMapping().get(ext));
        }
        return ThumbnailUtils.loadThumbnail(context, ThumbnailUtils.thumbnailDefault());
    }

    public static String getThumbnailFile(Context context, String sourceMD5, String thumbnailKind) {
        String thumbnail_file = EnvironmentUtil.getExternalStorageAppCacheDirectory((String)context.getPackageName()) + File.separator + thumbnail_folder + File.separator + sourceMD5 + "." + thumbnailKind + preferred_extension;
        return thumbnail_file;
    }

    public static Bitmap getThumbnailBitmap(Context context, String sourceMD5, String thumbnailKind) {
        return BitmapUtils.loadBitmapFromFile((String)ThumbnailUtils.getThumbnailFile(context, sourceMD5, thumbnailKind));
    }

    public static Bitmap getThumbnailBitmap(Context context, Thumbnail thumbnail) {
        Bitmap bitmap = ThumbnailUtils.getThumbnailBitmap(context, thumbnail.getSourceMD5(), thumbnail.getThumbnailKind().toString());
        if (bitmap == null) {
            bitmap = ThumbnailUtils.loadDefaultThumbnailFromExtension(context, FileUtils.getFileExtension((String)thumbnail.getPath()));
        }
        return bitmap;
    }

    public static boolean saveThumbnailBitmap(Context context, Thumbnail thumbnail, Bitmap saveBitmap) {
        String path = ThumbnailUtils.getThumbnailFile(context, thumbnail.getSourceMD5(), thumbnail.getThumbnailKind().toString());
        if (!FileUtils.ensureFileExists((String)path)) {
            return false;
        }
        boolean save = BitmapUtils.saveBitmap((Bitmap)ThumbnailUtils.generateBitmap(saveBitmap, thumbnail.getThumbnailKind()), (String)path);
        if (save) {
            thumbnail.setPath(path);
            thumbnail.save();
        }
        return save;
    }

    private static Bitmap generateBitmap(Bitmap bitmap, OnyxThumbnail.ThumbnailKind kind) {
        Bitmap scaleBitmap = bitmap;
        switch (kind) {
            case Original: {
                scaleBitmap = bitmap;
                break;
            }
            case Large: {
                scaleBitmap = OnyxThumbnail.createLargeThumbnail(bitmap);
                break;
            }
            case Middle: {
                scaleBitmap = OnyxThumbnail.createMiddleThumbnail(bitmap);
                break;
            }
            case Small: {
                scaleBitmap = OnyxThumbnail.createSmallThumbnail(bitmap);
            }
        }
        return scaleBitmap;
    }
}

