/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import android.content.Context;
import com.onyx.android.sdk.data.model.Book;
import com.onyx.android.sdk.data.model.OnyxStatisticsModel;
import com.onyx.android.sdk.data.model.OnyxStatisticsModel_Table;
import com.onyx.android.sdk.utils.MapUtils;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.Where;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class StatisticsUtils {
    public static void saveStatistics(Context context, OnyxStatisticsModel statisticsData) {
        if (statisticsData == null) {
            return;
        }
        statisticsData.save();
    }

    public static void saveStatisticsList(Context context, Collection<OnyxStatisticsModel> list) {
        DatabaseWrapper database = FlowManager.getDatabase((String)"OnyxStatisticsModel").getWritableDatabase();
        database.beginTransaction();
        for (OnyxStatisticsModel statisticsData : list) {
            statisticsData.save();
        }
        database.setTransactionSuccessful();
        database.endTransaction();
    }

    public static void deleteStatisticsList(Context context, Collection<OnyxStatisticsModel> list) {
        DatabaseWrapper database = FlowManager.getDatabase((String)"OnyxStatisticsModel").getWritableDatabase();
        database.beginTransaction();
        for (OnyxStatisticsModel statisticsData : list) {
            statisticsData.delete();
        }
        database.setTransactionSuccessful();
        database.endTransaction();
    }

    public static void deleteStatisticsListByStatus(Context context, int status) {
        List list = (List)StatisticsUtils.loadStatisticsListByStatus(context, status);
        DatabaseWrapper database = FlowManager.getDatabase((String)"OnyxStatisticsModel").getWritableDatabase();
        database.beginTransaction();
        for (OnyxStatisticsModel statisticsData : list) {
            statisticsData.delete();
        }
        database.setTransactionSuccessful();
        database.endTransaction();
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsListByStatus(Context context, int count, int status) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLCondition[]{OnyxStatisticsModel_Table.status.eq((Object)status)}).limit(count);
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsListByStatus(Context context, int status) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLCondition[]{OnyxStatisticsModel_Table.status.eq((Object)status)});
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsList(Context context, String md5short, int type) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLCondition[]{OnyxStatisticsModel_Table.type.eq((Object)type)}).and((SQLCondition)OnyxStatisticsModel_Table.md5short.eq((Object)md5short));
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsList(Context context, String md5short, int type, Date fromTime) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLCondition[]{OnyxStatisticsModel_Table.type.eq((Object)type)}).and((SQLCondition)OnyxStatisticsModel_Table.md5short.eq((Object)md5short)).and((SQLCondition)OnyxStatisticsModel_Table.eventTime.greaterThan((Object)fromTime));
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsList(Context context, int type) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLCondition[]{OnyxStatisticsModel_Table.type.eq((Object)type)});
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsList(Context context, int type, int status) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLCondition[]{OnyxStatisticsModel_Table.type.eq((Object)type)}).and((SQLCondition)OnyxStatisticsModel_Table.status.eq((Object)status));
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsList(Context context, Date fromTime) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLCondition[]{OnyxStatisticsModel_Table.eventTime.greaterThan((Object)fromTime)});
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsList(Context context, Date fromTime, int type) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLCondition[]{OnyxStatisticsModel_Table.eventTime.greaterThan((Object)fromTime)}).and((SQLCondition)OnyxStatisticsModel_Table.type.eq((Object)type));
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsListByMd5short(Context context, String md5short) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLCondition[]{OnyxStatisticsModel_Table.md5short.eq((Object)md5short)});
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsListOrderByTime(Context context, int type, boolean ascending) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLCondition[]{OnyxStatisticsModel_Table.type.eq((Object)type)}).orderBy(OnyxStatisticsModel_Table.eventTime, ascending);
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsListOrderByTime(Context context, int type, int status, boolean ascending) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLCondition[]{OnyxStatisticsModel_Table.type.eq((Object)type)}).and((SQLCondition)OnyxStatisticsModel_Table.status.eq((Object)status)).orderBy(OnyxStatisticsModel_Table.eventTime, ascending);
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsListOrderByTime(Context context, String md5short, boolean ascending) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLCondition[]{OnyxStatisticsModel_Table.md5short.eq((Object)md5short)}).orderBy(OnyxStatisticsModel_Table.eventTime, ascending);
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsListOrderByTime(Context context, String md5short, int type, boolean ascending) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLCondition[]{OnyxStatisticsModel_Table.type.eq((Object)type)}).and((SQLCondition)OnyxStatisticsModel_Table.md5short.eq((Object)md5short)).orderBy(OnyxStatisticsModel_Table.eventTime, ascending);
        List list = where.queryList();
        return list;
    }

    public static String getBookMd5(Context context, String md5short) {
        String md5 = "";
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLCondition[]{OnyxStatisticsModel_Table.md5short.eq((Object)md5short)}).limit(1);
        List list = where.queryList();
        if (list != null && list.size() > 0) {
            md5 = ((OnyxStatisticsModel)list.get(0)).getMd5();
        }
        return md5;
    }

    public static List<Integer> getEventHourlyAgg(List<OnyxStatisticsModel> statisticsList, int count) {
        ArrayList<Integer> result = new ArrayList<Integer>(count);
        for (int i = 0; i < count; ++i) {
            result.add(0);
        }
        for (OnyxStatisticsModel statisticsModel : statisticsList) {
            int hour = statisticsModel.getEventTime().getHours();
            if (hour >= result.size()) continue;
            int value = (Integer)result.get(hour);
            result.set(hour, ++value);
        }
        return result;
    }

    public static Book getLongestBook(List<OnyxStatisticsModel> statisticsModels) {
        HashMap<String, Long> timeMap = new HashMap<String, Long>();
        for (OnyxStatisticsModel statisticsModel : statisticsModels) {
            String md5short = statisticsModel.getMd5short();
            long times = statisticsModel.getDurationTime();
            if (timeMap.containsKey(md5short)) {
                times = (Long)timeMap.get(md5short);
                times += statisticsModel.getDurationTime().longValue();
            }
            timeMap.put(md5short, times);
        }
        if (timeMap.size() == 0) {
            return null;
        }
        LinkedHashMap sortedMap = (LinkedHashMap)MapUtils.sortByValue(timeMap);
        Book book = new Book();
        Map.Entry last = MapUtils.getLast((Map)sortedMap);
        book.setMd5short((String)last.getKey());
        book.setReadingTime((Long)last.getValue());
        return book;
    }

    public static Book getMostCarefullyBook(List<OnyxStatisticsModel> statisticsModels) {
        HashMap<String, Long> countMap = new HashMap<String, Long>();
        for (OnyxStatisticsModel statisticsModel : statisticsModels) {
            String md5short = statisticsModel.getMd5short();
            long count = 1L;
            if (countMap.containsKey(md5short)) {
                count = (Long)countMap.get(md5short);
                ++count;
            }
            countMap.put(md5short, count);
        }
        if (countMap.size() == 0) {
            return null;
        }
        LinkedHashMap sortedMap = (LinkedHashMap)MapUtils.sortByValue(countMap);
        Book book = new Book();
        Map.Entry last = MapUtils.getLast((Map)sortedMap);
        book.setMd5short((String)last.getKey());
        return book;
    }

    public static List<Book> getRecentBooks(List<OnyxStatisticsModel> statisticsModels, int count) {
        ArrayList<Book> recentBooks = new ArrayList<Book>();
        LinkedHashSet<String> bookMd5shorts = new LinkedHashSet<String>();
        for (OnyxStatisticsModel statisticsModel : statisticsModels) {
            if (bookMd5shorts.size() >= count) break;
            bookMd5shorts.add(statisticsModel.getMd5short());
        }
        for (String bookMd5short : bookMd5shorts) {
            Book book = new Book();
            book.setMd5short(bookMd5short);
            recentBooks.add(book);
        }
        return recentBooks;
    }
}

