/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import android.os.Handler;
import android.os.Looper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;

public class ProgressRequestBody
extends RequestBody {
    private File file;
    private String mediaType;
    private UploadCallbacks listener;
    private static final int DEFAULT_BUFFER_SIZE = 2048;

    public ProgressRequestBody(File file, String mediaType, UploadCallbacks listener) {
        this.file = file;
        this.listener = listener;
        this.mediaType = mediaType;
    }

    public MediaType contentType() {
        return MediaType.parse((String)this.mediaType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(BufferedSink sink) throws IOException {
        long fileLength = this.file.length();
        byte[] buffer = new byte[2048];
        FileInputStream in = new FileInputStream(this.file);
        Handler handler = new Handler(Looper.getMainLooper());
        long uploaded = 0L;
        try {
            int read;
            while ((read = in.read(buffer)) != -1) {
                if (this.listener != null) {
                    handler.post((Runnable)new ProgressUpdater(uploaded, fileLength));
                }
                uploaded += (long)read;
                sink.write(buffer, 0, read);
            }
        }
        finally {
            if (this.listener != null) {
                if (uploaded == 0L || uploaded < fileLength) {
                    handler.post((Runnable)new DoneUpdater(false));
                } else {
                    handler.post((Runnable)new DoneUpdater(true));
                }
            }
            in.close();
        }
    }

    private class ProgressUpdater
    implements Runnable {
        private long uploaded;
        private long total;

        public ProgressUpdater(long uploaded, long total) {
            this.uploaded = uploaded;
            this.total = total;
        }

        @Override
        public void run() {
            ProgressRequestBody.this.listener.onProgressUpdate((int)(100L * this.uploaded / this.total));
        }
    }

    private class DoneUpdater
    implements Runnable {
        private boolean isFinish;

        public DoneUpdater(boolean finish) {
            this.isFinish = finish;
        }

        @Override
        public void run() {
            if (this.isFinish) {
                ProgressRequestBody.this.listener.onFinish();
            } else {
                ProgressRequestBody.this.listener.onError();
            }
        }
    }

    public static interface UploadCallbacks {
        public void onProgressUpdate(int var1);

        public void onError();

        public void onFinish();
    }
}

