/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import android.app.PendingIntent;
import android.support.v4.app.NotificationCompat;
import com.liulishuo.filedownloader.notification.BaseNotificationItem;
import com.liulishuo.filedownloader.util.FileDownloadHelper;

public class NotificationItem
extends BaseNotificationItem {
    private PendingIntent pendingIntent;
    private PendingIntent errorIntent;
    private NotificationCompat.Builder builder = new NotificationCompat.Builder(FileDownloadHelper.getAppContext());

    public NotificationItem(NotificationBean bean) {
        super(bean.id, bean.title, bean.desc);
        this.builder.setPriority(-2).setContentTitle((CharSequence)this.getTitle()).setContentText((CharSequence)bean.desc).setSmallIcon(bean.icon).setAutoCancel(true);
        this.pendingIntent = bean.pendingIntent;
        this.errorIntent = bean.errorIntent;
    }

    public void show(boolean statusChanged, int status, boolean isShowProgress) {
        String desc = this.getDesc();
        int soFar = this.getSofar();
        switch (status) {
            case 1: {
                desc = desc + " pending";
                break;
            }
            case 6: {
                desc = desc + " started";
                break;
            }
            case 3: {
                desc = desc + " progress";
                break;
            }
            case 5: {
                desc = desc + " retry";
                break;
            }
            case -1: {
                desc = desc + " error";
                if (this.errorIntent == null) break;
                this.builder.setContentIntent(this.errorIntent);
                break;
            }
            case -2: {
                desc = desc + " paused";
                break;
            }
            case -3: {
                desc = desc + " completed";
                soFar = this.getTotal();
                if (this.pendingIntent == null) break;
                this.builder.setContentIntent(this.pendingIntent);
                break;
            }
            case -4: {
                desc = desc + " warn";
            }
        }
        this.builder.setContentTitle((CharSequence)this.getTitle()).setContentText((CharSequence)desc);
        if (statusChanged) {
            this.builder.setTicker((CharSequence)desc);
        }
        this.builder.setProgress(this.getTotal(), soFar, false);
        this.getManager().notify(this.getId(), this.builder.build());
    }

    public static class NotificationBean {
        public int id;
        public int icon;
        public String title;
        public String desc = "download";
        public PendingIntent pendingIntent;
        public PendingIntent errorIntent;
    }
}

