/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import com.onyx.android.sdk.data.BookFilter;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.SortBy;
import com.onyx.android.sdk.data.SortOrder;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MetadataUtils {
    public static int compareStringAsc(String a, String b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    public static int compareCreatedAtDateAsc(Metadata a, Metadata b) {
        if (a.getCreatedAt() == null && b.getCreatedAt() == null) {
            return MetadataUtils.compareStringAsc(a.getName(), b.getName());
        }
        if (a.getCreatedAt() == null) {
            return -1;
        }
        if (b.getCreatedAt() == null) {
            return 1;
        }
        int value = a.getCreatedAt().compareTo(b.getCreatedAt());
        if (value == 0) {
            return MetadataUtils.compareStringAsc(a.getName(), b.getName());
        }
        return value;
    }

    public static int compareCreatedAtDateDesc(Metadata a, Metadata b) {
        if (a.getCreatedAt() == null && b.getCreatedAt() == null) {
            return MetadataUtils.compareStringAsc(a.getName(), b.getName());
        }
        if (a.getCreatedAt() == null) {
            return 1;
        }
        if (b.getCreatedAt() == null) {
            return -1;
        }
        int value = a.getCreatedAt().compareTo(b.getCreatedAt());
        if (value == 0) {
            return MetadataUtils.compareStringAsc(a.getName(), b.getName());
        }
        return -value;
    }

    public static int compareLastModifiedDateAsc(Metadata a, Metadata b) {
        if (a.getLastModified() == null && b.getLastModified() == null) {
            return MetadataUtils.compareStringAsc(a.getName(), b.getName());
        }
        if (a.getLastModified() == null) {
            return -1;
        }
        if (b.getLastModified() == null) {
            return 1;
        }
        int value = a.getLastModified().compareTo(b.getLastModified());
        if (value == 0) {
            return MetadataUtils.compareStringAsc(a.getName(), b.getName());
        }
        return value;
    }

    public static int compareLastModifiedDateDesc(Metadata a, Metadata b) {
        if (a.getLastModified() == null && b.getLastModified() == null) {
            return MetadataUtils.compareStringAsc(a.getName(), b.getName());
        }
        if (a.getLastModified() == null) {
            return 1;
        }
        if (b.getLastModified() == null) {
            return -1;
        }
        int value = a.getLastModified().compareTo(b.getLastModified());
        if (value == 0) {
            return MetadataUtils.compareStringAsc(a.getName(), b.getName());
        }
        return -value;
    }

    public static int compareLastAccessedDateAsc(Metadata a, Metadata b) {
        if (a.getLastAccess() == null && b.getLastAccess() == null) {
            return MetadataUtils.compareStringAsc(a.getName(), b.getName());
        }
        if (a.getLastAccess() == null) {
            return -1;
        }
        if (b.getLastAccess() == null) {
            return 1;
        }
        int value = a.getLastAccess().compareTo(b.getLastAccess());
        if (value == 0) {
            return MetadataUtils.compareStringAsc(a.getName(), b.getName());
        }
        return value;
    }

    public static int compareLastAccessedDateDesc(Metadata a, Metadata b) {
        if (a.getLastAccess() == null && b.getLastAccess() == null) {
            return MetadataUtils.compareStringAsc(a.getName(), b.getName());
        }
        if (a.getLastAccess() == null) {
            return 1;
        }
        if (b.getLastAccess() == null) {
            return -1;
        }
        int value = a.getLastAccess().compareTo(b.getLastAccess());
        if (value == 0) {
            return MetadataUtils.compareStringAsc(a.getName(), b.getName());
        }
        return -value;
    }

    public static int compareSizeAsc(Metadata a, Metadata b) {
        if (a.getSize() == b.getSize()) {
            return MetadataUtils.compareStringAsc(a.getName(), b.getName());
        }
        return (int)a.getSize() - (int)b.getSize();
    }

    public static int compareSizeDesc(Metadata a, Metadata b) {
        if (a.getSize() == b.getSize()) {
            return MetadataUtils.compareStringAsc(a.getName(), b.getName());
        }
        return (int)b.getSize() - (int)a.getSize();
    }

    public static int compareAuthorStringAsc(Metadata a, Metadata b) {
        if (a.getAuthors() == null && b.getAuthors() == null) {
            return MetadataUtils.compareStringAsc(a.getName(), b.getName());
        }
        if (a.getAuthors() == null) {
            return -1;
        }
        if (b.getAuthors() == null) {
            return 1;
        }
        int value = a.getAuthors().compareTo(b.getAuthors());
        if (value == 0) {
            return MetadataUtils.compareStringAsc(a.getName(), b.getName());
        }
        return value;
    }

    public static int compareAuthorStringDesc(Metadata a, Metadata b) {
        if (a.getAuthors() == null && b.getAuthors() == null) {
            return MetadataUtils.compareStringAsc(a.getName(), b.getName());
        }
        if (a.getAuthors() == null) {
            return 1;
        }
        if (b.getAuthors() == null) {
            return -1;
        }
        int value = a.getAuthors().compareTo(b.getAuthors());
        if (value == 0) {
            return MetadataUtils.compareStringAsc(a.getName(), b.getName());
        }
        return -value;
    }

    public static int compareTitleStringAsc(Metadata a, Metadata b) {
        if (a.getTitle() == null && b.getTitle() == null) {
            return MetadataUtils.compareStringAsc(a.getName(), b.getName());
        }
        if (a.getTitle() == null) {
            return -1;
        }
        if (b.getTitle() == null) {
            return 1;
        }
        int value = a.getTitle().compareTo(b.getTitle());
        if (value == 0) {
            return MetadataUtils.compareStringAsc(a.getName(), b.getName());
        }
        return value;
    }

    public static int compareTitleStringDesc(Metadata a, Metadata b) {
        if (a.getTitle() == null && b.getTitle() == null) {
            return MetadataUtils.compareStringAsc(a.getName(), b.getName());
        }
        if (a.getTitle() == null) {
            return 1;
        }
        if (b.getTitle() == null) {
            return -1;
        }
        int value = a.getTitle().compareTo(b.getTitle());
        if (value == 0) {
            return MetadataUtils.compareStringAsc(a.getName(), b.getName());
        }
        return -value;
    }

    public static int compareTypeAsc(Metadata a, Metadata b) {
        if (a.getType() == null && b.getType() == null) {
            return MetadataUtils.compareStringAsc(a.getName(), b.getName());
        }
        if (a.getType() == null) {
            return -1;
        }
        if (b.getType() == null) {
            return 1;
        }
        int value = a.getType().compareTo(b.getType());
        if (value == 0) {
            return MetadataUtils.compareStringAsc(a.getName(), b.getName());
        }
        return value;
    }

    public static int compareTypeDesc(Metadata a, Metadata b) {
        if (a.getType() == null && b.getType() == null) {
            return MetadataUtils.compareStringAsc(a.getName(), b.getName());
        }
        if (a.getType() == null) {
            return 1;
        }
        if (b.getType() == null) {
            return -1;
        }
        int value = a.getType().compareTo(b.getType());
        if (value == 0) {
            return MetadataUtils.compareStringAsc(a.getName(), b.getName());
        }
        return -value;
    }

    public static void sortByCreatedAtDateAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            @Override
            public int compare(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareCreatedAtDateAsc(metadata, metadata2);
            }
        });
    }

    public static void sortByCreatedAtDateDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            @Override
            public int compare(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareCreatedAtDateDesc(metadata, metadata2);
            }
        });
    }

    public static void sortByLastModifiedAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            @Override
            public int compare(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareLastModifiedDateAsc(metadata, metadata2);
            }
        });
    }

    public static void sortByLastModifiedDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            @Override
            public int compare(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareLastModifiedDateDesc(metadata, metadata2);
            }
        });
    }

    public static void sortByNameAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            @Override
            public int compare(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
            }
        });
    }

    public static void sortByNameDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            @Override
            public int compare(Metadata metadata, Metadata metadata2) {
                return -MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
            }
        });
    }

    public static void sortBySizeAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            @Override
            public int compare(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareSizeAsc(metadata, metadata2);
            }
        });
    }

    public static void sortBySizeDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            @Override
            public int compare(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareSizeDesc(metadata, metadata2);
            }
        });
    }

    public static void sortByTitleAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            @Override
            public int compare(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareTitleStringAsc(metadata, metadata2);
            }
        });
    }

    public static void sortByTitleDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            @Override
            public int compare(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareTitleStringDesc(metadata, metadata2);
            }
        });
    }

    public static void sortByFileTypeAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            @Override
            public int compare(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareTypeAsc(metadata, metadata2);
            }
        });
    }

    public static void sortByFileTypeDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            @Override
            public int compare(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareTypeDesc(metadata, metadata2);
            }
        });
    }

    public static void sortByAuthorAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            @Override
            public int compare(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareAuthorStringAsc(metadata, metadata2);
            }
        });
    }

    public static void sortByAuthorDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            @Override
            public int compare(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareAuthorStringDesc(metadata, metadata2);
            }
        });
    }

    public static void sortByPublisherAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            @Override
            public int compare(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareStringAsc(metadata.getPublisher(), metadata2.getPublisher());
            }
        });
    }

    public static void sortByPublisherDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            @Override
            public int compare(Metadata metadata, Metadata metadata2) {
                return -MetadataUtils.compareStringAsc(metadata.getPublisher(), metadata2.getPublisher());
            }
        });
    }

    public static void sortByRecentlyReadAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            @Override
            public int compare(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareLastAccessedDateAsc(metadata, metadata2);
            }
        });
    }

    public static void sortByRecentlyReadDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            @Override
            public int compare(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareLastAccessedDateDesc(metadata, metadata2);
            }
        });
    }

    public static void sortByLastOpenTimeAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            @Override
            public int compare(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareLastAccessedDateAsc(metadata, metadata2);
            }
        });
    }

    public static void sortByLastOpenTimeDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            @Override
            public int compare(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareLastAccessedDateDesc(metadata, metadata2);
            }
        });
    }

    public static void sort(List<Metadata> list, SortBy sortBy, SortOrder order) {
        switch (sortBy) {
            case None: {
                if (order == SortOrder.Asc) {
                    MetadataUtils.sortByNameAsc(list);
                    break;
                }
                MetadataUtils.sortByNameDesc(list);
                break;
            }
            case Name: {
                if (order == SortOrder.Asc) {
                    MetadataUtils.sortByNameAsc(list);
                    break;
                }
                MetadataUtils.sortByNameDesc(list);
                break;
            }
            case FileType: {
                if (order == SortOrder.Asc) {
                    MetadataUtils.sortByFileTypeAsc(list);
                    break;
                }
                MetadataUtils.sortByFileTypeDesc(list);
                break;
            }
            case Size: {
                if (order == SortOrder.Asc) {
                    MetadataUtils.sortBySizeAsc(list);
                    break;
                }
                MetadataUtils.sortBySizeDesc(list);
                break;
            }
            case CreationTime: {
                if (order == SortOrder.Asc) {
                    MetadataUtils.sortByCreatedAtDateAsc(list);
                    break;
                }
                MetadataUtils.sortByCreatedAtDateDesc(list);
                break;
            }
            case BookTitle: {
                if (order == SortOrder.Asc) {
                    MetadataUtils.sortByTitleAsc(list);
                    break;
                }
                MetadataUtils.sortByTitleDesc(list);
                break;
            }
            case Author: {
                if (order == SortOrder.Asc) {
                    MetadataUtils.sortByAuthorAsc(list);
                    break;
                }
                MetadataUtils.sortByAuthorDesc(list);
                break;
            }
            case Publisher: {
                if (order == SortOrder.Asc) {
                    MetadataUtils.sortByPublisherAsc(list);
                    break;
                }
                MetadataUtils.sortByPublisherDesc(list);
                break;
            }
            case RecentlyRead: {
                if (order == SortOrder.Asc) {
                    MetadataUtils.sortByRecentlyReadAsc(list);
                    break;
                }
                MetadataUtils.sortByRecentlyReadDesc(list);
                break;
            }
            case Total: {
                if (order == SortOrder.Asc) {
                    MetadataUtils.sortByLastOpenTimeAsc(list);
                    break;
                }
                MetadataUtils.sortByLastOpenTimeDesc(list);
                break;
            }
            case StartTime: {
                if (order == SortOrder.Asc) {
                    MetadataUtils.sortByLastOpenTimeAsc(list);
                    break;
                }
                MetadataUtils.sortByLastOpenTimeDesc(list);
                break;
            }
            case LastOpenTime: {
                if (order == SortOrder.Asc) {
                    MetadataUtils.sortByLastOpenTimeAsc(list);
                    break;
                }
                MetadataUtils.sortByLastOpenTimeDesc(list);
                break;
            }
            case InstallTime: {
                if (order == SortOrder.Asc) {
                    MetadataUtils.sortByLastOpenTimeAsc(list);
                    break;
                }
                MetadataUtils.sortByLastOpenTimeDesc(list);
                break;
            }
        }
    }

    public static boolean safelyContains(Set<String> set, String string) {
        return set == null || set.size() <= 0 || set.contains(string);
    }

    public static boolean safelyContains(Set<String> set, List<String> list) {
        if (set != null && list != null) {
            for (String string : list) {
                if (!set.contains(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean safelyContains(String parent, String query) {
        return !StringUtils.isNullOrEmpty((String)parent) && !StringUtils.isNullOrEmpty((String)query) && parent.contains(query);
    }

    public static boolean safelyContains(Metadata metadata, String query) {
        if (MetadataUtils.safelyContains(metadata.getName(), query)) {
            return true;
        }
        if (MetadataUtils.safelyContains(metadata.getAuthors(), query)) {
            return true;
        }
        return MetadataUtils.safelyContains(metadata.getTitle(), query);
    }

    public static boolean containsIfNotNull(Set<String> source, Collection<String> target) {
        if (source == null || source.size() == 0) {
            return true;
        }
        if (target == null) {
            return false;
        }
        for (String string : target) {
            if (!source.contains(string)) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getStringSplitSet(String originString, String delimiter) {
        String[] authors;
        HashSet<String> set = new HashSet<String>();
        if (originString == null) {
            return set;
        }
        for (String author : authors = originString.split(delimiter)) {
            set.add(author);
        }
        return set;
    }

    public static boolean criteriaContains(Metadata metadata, QueryArgs criteria) {
        if (!CollectionUtils.contains(criteria.fileType, (String)metadata.getType().toLowerCase())) {
            return false;
        }
        if (!MetadataUtils.containsIfNotNull(criteria.author, MetadataUtils.getStringSplitSet(metadata.getAuthors(), ","))) {
            return false;
        }
        if (!MetadataUtils.containsIfNotNull(criteria.tags, MetadataUtils.getStringSplitSet(metadata.getTags(), ","))) {
            return false;
        }
        if (!CollectionUtils.contains(criteria.title, (String)metadata.getTitle())) {
            return false;
        }
        return MetadataUtils.containsIfNotNull(criteria.series, MetadataUtils.getStringSplitSet(metadata.getSeries(), ","));
    }

    public static List<Metadata> verifyReadedStatus(List<Metadata> list, BookFilter filter) {
        if (filter != BookFilter.FINISHED) {
            return list;
        }
        ArrayList<Metadata> readList = new ArrayList<Metadata>();
        for (Metadata metadata : list) {
            if (!metadata.isFinished()) continue;
            readList.add(metadata);
        }
        return readList;
    }

    public static Metadata ensureObject(Metadata metadata) {
        return metadata != null ? metadata : new Metadata();
    }
}

