/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import com.onyx.android.sdk.utils.StringUtils;

public class FirmwareUtils {
    private static String getBuildEntryFromFingerprint(String fingerprint) {
        String[] entries = fingerprint.split("/");
        if (entries.length < 2) {
            return null;
        }
        String key = entries[entries.length - 2];
        if (StringUtils.isNullOrEmpty((String)key)) {
            return null;
        }
        return key;
    }

    public static int getBuildIdFromFingerprint(String fingerprint) {
        String key = FirmwareUtils.getBuildEntryFromFingerprint(fingerprint);
        if (StringUtils.isNullOrEmpty((String)key)) {
            return -1;
        }
        String[] items = key.split(":");
        if (items.length < 2) {
            return -1;
        }
        int value = Integer.valueOf(items[0]);
        return value;
    }

    public static String getBuildTypeFromFingerprint(String fingerprint) {
        String key = FirmwareUtils.getBuildEntryFromFingerprint(fingerprint);
        if (StringUtils.isNullOrEmpty((String)key)) {
            return null;
        }
        String[] items = key.split(":");
        if (items.length < 2) {
            return null;
        }
        return items[1];
    }

    public static String getBuildDateFromBuildDisplayId(String buildDisplayId) {
        String[] entries = buildDisplayId.split(" ");
        if (entries.length < 3) {
            return null;
        }
        String key = entries[entries.length - 2];
        if (StringUtils.isNullOrEmpty((String)key)) {
            return null;
        }
        return key;
    }
}

