/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.data.db;

import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.MetadataCollection;
import com.onyx.android.sdk.data.request.data.db.BaseDBRequest;
import com.onyx.android.sdk.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class MoveToLibraryRequest
extends BaseDBRequest {
    private Library fromLibrary;
    private Library toLibrary;
    private List<Metadata> addList = new ArrayList<Metadata>();

    public MoveToLibraryRequest(Library fromLibrary, Library toLibrary, List<Metadata> addList) {
        this.fromLibrary = fromLibrary;
        this.toLibrary = toLibrary;
        this.addList.addAll(addList);
    }

    @Override
    public void execute(DataManager dataManager) throws Exception {
        String fromIdString = null;
        String toIdString = null;
        if (this.fromLibrary != null) {
            fromIdString = this.fromLibrary.getIdString();
        }
        if (this.toLibrary != null) {
            toIdString = this.toLibrary.getIdString();
        }
        for (Metadata metadata : this.addList) {
            MetadataCollection collection = dataManager.getRemoteContentProvider().loadMetadataCollection(this.getContext(), fromIdString, metadata.getIdString());
            if (StringUtils.isNullOrEmpty((String)toIdString)) {
                if (collection == null) continue;
                collection.delete();
                continue;
            }
            if (collection == null) {
                collection = MetadataCollection.create(metadata.getIdString(), toIdString);
            }
            collection.setLibraryUniqueId(toIdString);
            collection.save();
        }
    }
}

