/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.data.db;

import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.DataManagerHelper;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.request.data.db.BaseDBRequest;
import com.onyx.android.sdk.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;

public class LibraryLoadRequest
extends BaseDBRequest {
    private boolean loadMetadata = true;
    private QueryArgs queryArgs;
    private List<Metadata> bookList = new ArrayList<Metadata>();
    private List<Library> libraryList = new ArrayList<Library>();
    private long totalCount;

    public LibraryLoadRequest(QueryArgs queryArgs) {
        this.queryArgs = queryArgs;
    }

    public LibraryLoadRequest(QueryArgs queryArgs, boolean loadMetadata) {
        this.queryArgs = queryArgs;
        this.loadMetadata = loadMetadata;
    }

    @Override
    public void execute(DataManager dataManager) throws Exception {
        DataManagerHelper.loadLibraryList(dataManager, this.libraryList, this.queryArgs.libraryUniqueId);
        if (this.loadMetadata) {
            this.totalCount = dataManager.getRemoteContentProvider().count(this.getContext(), this.queryArgs);
            List<Metadata> metadataList = dataManager.getRemoteContentProvider().findMetadataByQueryArgs(this.getContext(), this.queryArgs);
            if (!CollectionUtils.isNullOrEmpty(metadataList)) {
                this.bookList.addAll(metadataList);
            }
        }
    }

    public List<Metadata> getBookList() {
        return this.bookList;
    }

    public List<Library> getLibraryList() {
        return this.libraryList;
    }

    public long getTotalCount() {
        return this.totalCount;
    }
}

