/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import com.alibaba.fastjson.JSON;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.GAdapter;
import com.onyx.android.sdk.data.model.Product;
import com.onyx.android.sdk.data.model.ProductResult;
import com.onyx.android.sdk.data.model.ProductSearch;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.utils.CloudUtils;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import retrofit2.Call;
import retrofit2.Response;

public class ProductSearchRequest
extends BaseCloudRequest {
    private ProductSearch searchCriteria;
    private ProductResult<Product> searchResult;
    private GAdapter adapter;

    public ProductSearchRequest(ProductSearch criteria) {
        this.searchCriteria = criteria;
    }

    public final ProductResult<Product> getSearchResult() {
        return this.searchResult;
    }

    public final GAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    public void execute(CloudManager parent) throws Exception {
        if (CloudManager.isWifiConnected(this.getContext())) {
            this.fetchFromCloud(parent);
        }
        this.adapter = CloudUtils.adapterFromProductResult(this.getContext(), this.searchResult, this.searchCriteria.limit, parent.getCloudConf());
    }

    public void fetchFromCloud(CloudManager parent) throws Exception {
        String param = JSON.toJSONString((Object)this.searchCriteria);
        Call<ProductResult<Product>> call = ServiceFactory.getBookStoreService(parent.getCloudConf().getApiBase()).bookSearch(param);
        Response<ProductResult<Product>> response = this.executeCall(call);
        if (response.isSuccessful()) {
            this.searchResult = (ProductResult)response.body();
        }
    }
}

