/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.model.Link;
import com.onyx.android.sdk.data.model.Product;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.onyx.android.sdk.utils.StringUtils;
import retrofit2.Response;

public class ProductRequest
extends BaseCloudRequest {
    private String guid;
    private Product product;
    private Link link;

    public ProductRequest(String guid) {
        this.guid = guid;
    }

    public Product getProduct() {
        return this.product;
    }

    public Link getDownloadLink() {
        return this.link;
    }

    private void parseLink(Product product, String cloudStorage) {
        if (product != null) {
            this.link = product.getFirstDownloadLink();
        }
    }

    @Override
    public void execute(CloudManager parent) throws Exception {
        if (StringUtils.isNullOrEmpty((String)this.guid)) {
            return;
        }
        Response<Product> response = this.executeCall(ServiceFactory.getBookStoreService(parent.getCloudConf().getApiBase()).book(this.guid));
        if (response.isSuccessful()) {
            this.product = (Product)((Object)response.body());
            this.parseLink(this.product, parent.getCloudConf().getCloudStorage());
        }
    }
}

