/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import com.alibaba.fastjson.JSON;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.model.Product;
import com.onyx.android.sdk.data.model.ProductQuery;
import com.onyx.android.sdk.data.model.ProductResult;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.utils.StoreUtils;
import com.onyx.android.sdk.data.v1.OnyxBookStoreService;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import retrofit2.Response;

public class ProductRecommendedListRequest
extends BaseCloudRequest {
    private ProductResult<Product> productResult;
    private ProductQuery productQuery;

    public ProductRecommendedListRequest(ProductQuery productQuery) {
        this.productQuery = productQuery;
    }

    public final ProductResult<Product> getProductResult() {
        return this.productResult;
    }

    @Override
    public void execute(CloudManager parent) throws Exception {
        if (CloudManager.isWifiConnected(this.getContext())) {
            this.fetchFromCloud(parent);
        } else {
            this.fetchFromLocal(parent);
        }
    }

    public void fetchFromCloud(CloudManager parent) throws Exception {
        OnyxBookStoreService service = ServiceFactory.getBookStoreService(parent.getCloudConf().getApiBase());
        Response<ProductResult<Product>> response = this.executeCall(service.bookRecommendedList(JSON.toJSONString((Object)this.productQuery)));
        if (response.isSuccessful()) {
            this.productResult = (ProductResult)response.body();
        }
    }

    public void fetchFromLocal(CloudManager parent) throws Exception {
        this.productResult = new ProductResult();
        this.productResult.list = StoreUtils.queryDataList(Product.class);
        this.productResult.count = this.productResult.list.size();
    }

    private void saveToLocal(ProductResult<Product> result) {
        StoreUtils.saveToLocal(result, Product.class, true);
    }
}

