/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import com.alibaba.fastjson.JSON;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.model.Product;
import com.onyx.android.sdk.data.model.ProductQuery;
import com.onyx.android.sdk.data.model.ProductResult;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.utils.StoreUtils;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import retrofit2.Response;

public class ProductListRequest
extends BaseCloudRequest {
    private static final String TAG = ProductListRequest.class.getSimpleName();
    private ProductQuery productQuery;
    private ProductResult<Product> productResult;
    private volatile boolean clearCache;
    private volatile boolean cloudOnly;

    public ProductListRequest(ProductQuery query, boolean clear, boolean cloud) {
        this.productQuery = query;
        this.clearCache = clear;
        this.cloudOnly = cloud;
    }

    public final ProductResult<Product> getProductResult() {
        return this.productResult;
    }

    @Override
    public void execute(CloudManager parent) throws Exception {
        if (CloudManager.isWifiConnected(this.getContext())) {
            this.fetchFromCloud(parent);
        } else if (!this.cloudOnly) {
            this.fetchFromLocalCache(parent);
        }
    }

    public void fetchFromLocalCache(CloudManager parent) throws Exception {
        this.productResult = new ProductResult();
        this.productResult.list = StoreUtils.queryDataList(Product.class);
        this.productResult.count = this.productResult.list.size();
    }

    public void fetchFromCloud(CloudManager parent) throws Exception {
        String param = JSON.toJSONString((Object)this.productQuery);
        Response<ProductResult<Product>> response = this.executeCall(ServiceFactory.getBookStoreService(parent.getCloudConf().getApiBase()).bookList(param));
        if (response.isSuccessful()) {
            this.productResult = (ProductResult)response.body();
            if (this.isSaveToLocal()) {
                this.saveToLocal(this.productResult);
            }
        }
    }

    private void saveToLocal(ProductResult<Product> result) {
        StoreUtils.saveToLocal(result, Product.class, this.clearCache);
    }
}

