/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import android.content.Context;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.model.Book;
import com.onyx.android.sdk.data.model.EventTypeAggBean;
import com.onyx.android.sdk.data.model.OnyxStatisticsModel;
import com.onyx.android.sdk.data.model.StatisticsResult;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.utils.StatisticsUtils;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.onyx.android.sdk.utils.DeviceUtils;
import com.onyx.android.sdk.utils.StringUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import retrofit2.Response;

public class GetStatisticsRequest
extends BaseCloudRequest {
    public static final int RECENT_BOOK_MAX_COUNT = 5;
    private Context context;
    private StatisticsResult statisticsResult;
    private String url;

    public GetStatisticsRequest(Context context, String url) {
        this.context = context;
        this.url = url;
    }

    @Override
    public void execute(CloudManager parent) throws Exception {
        this.statisticsResult = new StatisticsResult();
        if (DeviceUtils.isWifiConnected((Context)this.context)) {
            this.readCloudData(parent);
        } else {
            this.readLocalData();
        }
    }

    private void readCloudData(CloudManager parent) throws Exception {
        if (StringUtils.isNullOrEmpty((String)this.url)) {
            return;
        }
        String mac = DeviceUtils.getMacAddress((Context)this.context);
        if (StringUtils.isNullOrEmpty((String)mac)) {
            return;
        }
        try {
            Response<StatisticsResult> response = this.executeCall(ServiceFactory.getStatisticsService(this.url).getStatistics(mac));
            if (response != null && response.isSuccessful()) {
                this.statisticsResult = (StatisticsResult)response.body();
                this.statisticsResult.setMyEventHourlyAgg(this.getSelfReadTimeDis());
            } else {
                this.readLocalData();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.readLocalData();
        }
    }

    private void readLocalData() {
        EventTypeAggBean eventTypeAggBean = this.statisticsResult.getEventTypeAgg();
        this.statisticsResult.setTotalReadTime(this.getTotalReadTime());
        eventTypeAggBean.setRead(this.getReadCount());
        eventTypeAggBean.setFinish(this.getFinishCount());
        eventTypeAggBean.setAnnotation(this.getAnnotationCount());
        eventTypeAggBean.setTextSelect(this.getSelectTextCount());
        this.statisticsResult.setMyEventHourlyAgg(this.getSelfReadTimeDis());
        this.statisticsResult.setDailyAvgReadTime(this.getReadTimeEveryDay());
        this.statisticsResult.setLongestReadTimeBook(this.getLongestBook());
        this.statisticsResult.setMostCarefulBook(this.getMostCarefullyBook());
        this.statisticsResult.setRecentReadingBooks(this.getRecentBooks());
    }

    private long getTotalReadTime() {
        List statisticsModels = (List)StatisticsUtils.loadStatisticsList(this.context, 1);
        long readTimes = 0L;
        for (OnyxStatisticsModel statisticsModel : statisticsModels) {
            readTimes += statisticsModel.getDurationTime().longValue();
        }
        return readTimes;
    }

    private int getReadCount() {
        HashSet<String> readCount = new HashSet<String>();
        List statisticsModels = (List)StatisticsUtils.loadStatisticsList(this.context, 0);
        for (OnyxStatisticsModel statisticsModel : statisticsModels) {
            readCount.add(statisticsModel.getMd5short());
        }
        return readCount.size();
    }

    private int getFinishCount() {
        HashSet<String> finishCount = new HashSet<String>();
        List statisticsModels = (List)StatisticsUtils.loadStatisticsList(this.context, 6);
        for (OnyxStatisticsModel statisticsModel : statisticsModels) {
            finishCount.add(statisticsModel.getMd5short());
        }
        return finishCount.size();
    }

    private int getLookupDicCount() {
        List statisticsModels = (List)StatisticsUtils.loadStatisticsList(this.context, 3);
        return statisticsModels.size();
    }

    private int getAnnotationCount() {
        List annotationStatistics = (List)StatisticsUtils.loadStatisticsList(this.context, 2);
        return annotationStatistics.size();
    }

    private int getSelectTextCount() {
        List highLightStatistics = (List)StatisticsUtils.loadStatisticsList(this.context, 4);
        return highLightStatistics.size();
    }

    private List<Integer> getSelfReadTimeDis() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        Date date = calendar.getTime();
        List statisticsModels = (List)StatisticsUtils.loadStatisticsList(this.context, date);
        return StatisticsUtils.getEventHourlyAgg(statisticsModels, 24);
    }

    private long getReadTimeEveryDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        Date date = calendar.getTime();
        HashSet<Integer> days = new HashSet<Integer>();
        long readTimes = 0L;
        List statisticsModels = (List)StatisticsUtils.loadStatisticsList(this.context, date, 1);
        for (OnyxStatisticsModel statisticsModel : statisticsModels) {
            days.add(statisticsModel.getEventTime().getDay());
            readTimes += statisticsModel.getDurationTime().longValue();
        }
        if (days.size() == 0) {
            return 0L;
        }
        return readTimes / (long)days.size();
    }

    private Book getLongestBook() {
        List statisticsModels = (List)StatisticsUtils.loadStatisticsList(this.context, 1);
        Book book = StatisticsUtils.getLongestBook(statisticsModels);
        if (book == null) {
            return null;
        }
        String md5short = book.getMd5short();
        statisticsModels = (List)StatisticsUtils.loadStatisticsListOrderByTime(this.context, md5short, 0, true);
        if (statisticsModels != null && statisticsModels.size() > 0) {
            book.setBegin(((OnyxStatisticsModel)statisticsModels.get(0)).getEventTime());
        }
        if ((statisticsModels = (List)StatisticsUtils.loadStatisticsListOrderByTime(this.context, md5short, true)) != null && statisticsModels.size() > 0) {
            book.setEnd(((OnyxStatisticsModel)statisticsModels.get(statisticsModels.size() - 1)).getEventTime());
        }
        if ((statisticsModels = (List)StatisticsUtils.loadStatisticsListByMd5short(this.context, md5short)).size() > 0) {
            book.setName(((OnyxStatisticsModel)statisticsModels.get(0)).getName());
        }
        return book;
    }

    private Book getMostCarefullyBook() {
        List statisticsModels = (List)StatisticsUtils.loadStatisticsList(this.context, 3);
        statisticsModels.addAll(StatisticsUtils.loadStatisticsList(this.context, 2));
        statisticsModels.addAll(StatisticsUtils.loadStatisticsList(this.context, 4));
        Book book = StatisticsUtils.getMostCarefullyBook(statisticsModels);
        if (book == null) {
            return null;
        }
        String md5short = book.getMd5short();
        statisticsModels = (List)StatisticsUtils.loadStatisticsList(this.context, md5short, 3);
        book.setLookupDic(statisticsModels.size());
        statisticsModels = (List)StatisticsUtils.loadStatisticsList(this.context, md5short, 2);
        book.setAnnotation(statisticsModels.size());
        statisticsModels = (List)StatisticsUtils.loadStatisticsList(this.context, md5short, 4);
        book.setTextSelect(statisticsModels.size());
        statisticsModels = (List)StatisticsUtils.loadStatisticsListByMd5short(this.context, md5short);
        if (statisticsModels.size() > 0) {
            book.setName(((OnyxStatisticsModel)statisticsModels.get(0)).getName());
        }
        return book;
    }

    public List<Book> getRecentBooks() {
        List statisticsModels = (List)StatisticsUtils.loadStatisticsListOrderByTime(this.context, 0, false);
        List<Book> recentBooks = StatisticsUtils.getRecentBooks(statisticsModels, 5);
        for (Book book : recentBooks) {
            String md5short = book.getMd5short();
            statisticsModels = (List)StatisticsUtils.loadStatisticsListByMd5short(this.context, md5short);
            if (statisticsModels.size() > 0) {
                book.setName(((OnyxStatisticsModel)statisticsModels.get(0)).getName());
            }
            Date beginTime = null;
            Date endTime = null;
            statisticsModels = (List)StatisticsUtils.loadStatisticsListOrderByTime(this.context, md5short, 0, false);
            if (statisticsModels != null && statisticsModels.size() > 0) {
                beginTime = ((OnyxStatisticsModel)statisticsModels.get(0)).getEventTime();
                book.setBegin(beginTime);
            }
            if ((statisticsModels = (List)StatisticsUtils.loadStatisticsListOrderByTime(this.context, md5short, false)) != null && statisticsModels.size() > 0) {
                endTime = ((OnyxStatisticsModel)statisticsModels.get(0)).getEventTime();
                book.setEnd(endTime);
            }
            long useTime = 0L;
            if (beginTime != null) {
                statisticsModels = (List)StatisticsUtils.loadStatisticsList(this.context, md5short, 1, beginTime);
                for (OnyxStatisticsModel statisticsModel : statisticsModels) {
                    useTime += statisticsModel.getDurationTime().longValue();
                }
            }
            if (useTime <= 0L && beginTime != null & endTime != null) {
                useTime = endTime.getTime() - beginTime.getTime();
            }
            book.setReadingTime(Math.max(useTime, 0L));
        }
        return recentBooks;
    }

    public StatisticsResult getStatisticsResult() {
        return this.statisticsResult;
    }
}

