/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.onyx.android.sdk.common.request.BaseCallback;
import com.onyx.android.sdk.common.request.BaseRequest;
import com.onyx.android.sdk.data.StatisticsCloudManager;
import com.onyx.android.sdk.data.utils.ResultCode;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Response;

public abstract class BaseStatisticsRequest
extends BaseRequest {
    private static final String TAG = "BaseStatisticsRequest";
    protected ResultCode resultCode;

    public void beforeExecute(StatisticsCloudManager parent) {
        parent.acquireWakeLock(this.getContext(), ((Object)((Object)this)).getClass().getSimpleName());
        this.benchmarkStart();
        if (this.isAbort()) {
            // empty if block
        }
        if (this.getCallback() == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BaseStatisticsRequest.this.getCallback().start((BaseRequest)BaseStatisticsRequest.this);
            }
        };
        if (this.isRunInBackground()) {
            parent.getLooperHandler().post(runnable);
        } else {
            runnable.run();
        }
    }

    public abstract void execute(StatisticsCloudManager var1) throws Exception;

    public void afterExecute(StatisticsCloudManager parent) {
        try {
            this.afterExecuteImpl(parent);
        }
        catch (Throwable tr) {
            Log.w((String)TAG, (Throwable)tr);
        }
        finally {
            this.invokeCallback(parent);
        }
    }

    private void afterExecuteImpl(StatisticsCloudManager parent) throws Throwable {
        this.dumpException();
        this.benchmarkEnd();
    }

    private void invokeCallback(final StatisticsCloudManager parent) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BaseCallback.invoke((BaseCallback)BaseStatisticsRequest.this.getCallback(), (BaseRequest)BaseStatisticsRequest.this, (Throwable)BaseStatisticsRequest.this.getException());
                parent.releaseWakeLock();
            }
        };
        if (this.isRunInBackground()) {
            parent.getLooperHandler().post(runnable);
        } else {
            runnable.run();
        }
    }

    private void invokeCallBackProgress(StatisticsCloudManager parent, final BaseCallback.ProgressInfo progressInfo) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BaseStatisticsRequest.this.getCallback().progress((BaseRequest)BaseStatisticsRequest.this, progressInfo);
            }
        };
        if (this.isRunInBackground()) {
            parent.getLooperHandler().post(runnable);
        } else {
            runnable.run();
        }
    }

    private void dumpException() {
        if (this.hasException()) {
            Log.w((String)TAG, (Throwable)this.getException());
        }
    }

    public void dumpMessage(String tag, String message) {
    }

    public void dumpMessage(String tag, Throwable throwable, JSONObject errorResponse) {
        if (throwable != null && throwable.getMessage() != null) {
            this.dumpMessage(tag, throwable.getMessage());
        }
        if (errorResponse != null) {
            this.dumpMessage(tag, errorResponse.toString());
        }
    }

    protected <T> Response<T> executeCall(Call<T> call) throws Exception {
        Response response = call.execute();
        if (!response.isSuccessful()) {
            String errorBody = response.errorBody().string();
            this.resultCode = (ResultCode)JSON.parseObject((String)errorBody, ResultCode.class);
            throw new Exception(errorBody);
        }
        return response;
    }

    public ResultCode getResultCode() {
        return this.resultCode;
    }
}

