/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.model.OnyxAccount;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import java.io.File;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.Response;

public class AccountAvatarUploadRequest
extends BaseCloudRequest {
    private String avatarUrl;
    private File avatarFile;

    public AccountAvatarUploadRequest(File file) {
        this.avatarFile = file;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    @Override
    public void execute(CloudManager parent) throws Exception {
        MediaType mediaType = MediaType.parse((String)"image/*");
        RequestBody requestFile = RequestBody.create((MediaType)mediaType, (File)this.avatarFile);
        MultipartBody.Part partBody = MultipartBody.Part.createFormData((String)"avatar", (String)this.avatarFile.getName(), (RequestBody)requestFile);
        Call<OnyxAccount> call = ServiceFactory.getAccountService(parent.getCloudConf().getApiBase()).uploadAvatar(partBody, this.getAccountSessionToken());
        Response<OnyxAccount> response = this.executeCall(call);
        if (response.isSuccessful()) {
            this.avatarUrl = ((OnyxAccount)((Object)response.body())).avatarUrl;
        }
    }
}

