/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.provider;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.util.Log;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.compatability.OnyxThumbnail;
import com.onyx.android.sdk.data.db.table.OnyxAnnotationProvider;
import com.onyx.android.sdk.data.db.table.OnyxBookmarkProvider;
import com.onyx.android.sdk.data.db.table.OnyxLibraryProvider;
import com.onyx.android.sdk.data.db.table.OnyxMetadataCollectionProvider;
import com.onyx.android.sdk.data.db.table.OnyxMetadataProvider;
import com.onyx.android.sdk.data.model.Annotation;
import com.onyx.android.sdk.data.model.Annotation_Table;
import com.onyx.android.sdk.data.model.Bookmark;
import com.onyx.android.sdk.data.model.Bookmark_Table;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Library_Table;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.MetadataCollection;
import com.onyx.android.sdk.data.model.MetadataCollection_Table;
import com.onyx.android.sdk.data.model.Metadata_Table;
import com.onyx.android.sdk.data.model.Thumbnail;
import com.onyx.android.sdk.data.model.Thumbnail_Table;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.utils.MetadataUtils;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.language.Condition;
import com.raizlabs.android.dbflow.sql.language.ConditionGroup;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.language.property.Property;
import com.raizlabs.android.dbflow.structure.Model;
import com.raizlabs.android.dbflow.structure.provider.ContentUtils;
import java.io.File;
import java.util.List;

public class RemoteDataProvider
implements DataProviderBase {
    private static final String TAG = RemoteDataProvider.class.getSimpleName();

    @Override
    public void clearMetadata() {
        FlowManager.getContext().getContentResolver().delete(OnyxMetadataProvider.CONTENT_URI, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Metadata findMetadataByPath(Context context, String path) {
        Metadata metadata = null;
        try {
            metadata = (Metadata)ContentUtils.querySingle((Uri)OnyxMetadataProvider.CONTENT_URI, Metadata.class, (ConditionGroup)ConditionGroup.clause().and((SQLCondition)Metadata_Table.nativeAbsolutePath.eq((Object)path)), null, (String[])new String[0]);
        }
        catch (Exception exception) {
            return MetadataUtils.ensureObject(metadata);
            catch (Throwable throwable) {
                return MetadataUtils.ensureObject(metadata);
            }
        }
        return MetadataUtils.ensureObject(metadata);
    }

    @Override
    public void saveMetadata(Context context, Metadata metadata) {
        metadata.beforeSave();
        Metadata findMeta = this.findMetadataByHashTag(context, metadata.getNativeAbsolutePath(), metadata.getHashTag());
        if (!findMeta.hasValidId()) {
            ContentUtils.insert((Uri)OnyxMetadataProvider.CONTENT_URI, (Model)metadata);
        } else {
            ContentUtils.update((Uri)OnyxMetadataProvider.CONTENT_URI, (Model)metadata);
        }
    }

    @Override
    public List<Metadata> findMetadataByQueryArgs(Context context, QueryArgs queryArgs) {
        return ContentUtils.queryList((Uri)OnyxMetadataProvider.CONTENT_URI, Metadata.class, (ConditionGroup)queryArgs.conditionGroup, (String)queryArgs.getOrderByQueryWithLimitOffset(), (String[])queryArgs.getProjectionSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Metadata findMetadataByHashTag(Context context, String path, String hashTag) {
        Metadata metadata = null;
        try {
            if (StringUtils.isNullOrEmpty((String)hashTag)) {
                hashTag = FileUtils.computeMD5((File)new File(path));
            }
            metadata = (Metadata)ContentUtils.querySingle((Uri)OnyxMetadataProvider.CONTENT_URI, Metadata.class, (ConditionGroup)ConditionGroup.clause().and((SQLCondition)Metadata_Table.hashTag.eq((Object)hashTag)), null, (String[])new String[0]);
        }
        catch (Exception exception) {
            return MetadataUtils.ensureObject(metadata);
            catch (Throwable throwable) {
                return MetadataUtils.ensureObject(metadata);
            }
        }
        return MetadataUtils.ensureObject(metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(Context context, QueryArgs queryArgs) {
        Cursor cursor;
        block3: {
            long l;
            cursor = null;
            try {
                cursor = FlowManager.getContext().getContentResolver().query(OnyxMetadataProvider.CONTENT_URI, queryArgs.getProjectionSet(), queryArgs.conditionGroup.getQuery(), null, null);
                if (cursor != null) break block3;
                Log.w((String)TAG, (String)"queryArgs count cursor null");
                l = 0L;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(cursor);
                throw throwable;
            }
            FileUtils.closeQuietly((Cursor)cursor);
            return l;
        }
        long l = cursor.getCount();
        FileUtils.closeQuietly((Cursor)cursor);
        return l;
    }

    @Override
    public void removeMetadata(Context context, Metadata metadata) {
        ContentUtils.delete((Uri)OnyxMetadataProvider.CONTENT_URI, (Model)metadata);
    }

    @Override
    public boolean saveDocumentOptions(Context context, String path, String md5, String json) {
        try {
            Metadata document = this.findMetadataByHashTag(context, path, md5);
            document.setExtraAttributes(json);
            document.beforeSave();
            if (!document.hasValidId()) {
                document.setHashTag(md5);
                ContentUtils.insert((Uri)OnyxMetadataProvider.CONTENT_URI, (Model)document);
            } else {
                ContentUtils.update((Uri)OnyxMetadataProvider.CONTENT_URI, (Model)document);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public List<Annotation> loadAnnotations(String application, String md5, int pageNumber, OrderBy orderBy) {
        ConditionGroup conditionGroup = ConditionGroup.clause().and((SQLCondition)Annotation_Table.idString.eq((Object)md5)).and((SQLCondition)Annotation_Table.application.eq((Object)application)).and((SQLCondition)Annotation_Table.pageNumber.eq(pageNumber));
        return ContentUtils.queryList((Uri)OnyxAnnotationProvider.CONTENT_URI, Annotation.class, (ConditionGroup)conditionGroup, (String)orderBy.getQuery(), (String[])new String[0]);
    }

    @Override
    public List<Annotation> loadAnnotations(String application, String md5, OrderBy orderBy) {
        ConditionGroup conditionGroup = ConditionGroup.clause().and((SQLCondition)Annotation_Table.idString.eq((Object)md5)).and((SQLCondition)Annotation_Table.application.eq((Object)application));
        return ContentUtils.queryList((Uri)OnyxAnnotationProvider.CONTENT_URI, Annotation.class, (ConditionGroup)conditionGroup, (String)orderBy.getQuery(), (String[])new String[0]);
    }

    @Override
    public void addAnnotation(Annotation annotation) {
        annotation.beforeSave();
        ContentUtils.insert((Uri)OnyxAnnotationProvider.CONTENT_URI, (Model)annotation);
    }

    @Override
    public void updateAnnotation(Annotation annotation) {
        annotation.beforeSave();
        ContentUtils.update((Uri)OnyxAnnotationProvider.CONTENT_URI, (Model)annotation);
    }

    @Override
    public void deleteAnnotation(Annotation annotation) {
        ContentUtils.delete((Uri)OnyxAnnotationProvider.CONTENT_URI, (Model)annotation);
    }

    @Override
    public Bookmark loadBookmark(String application, String md5, int pageNumber) {
        ConditionGroup conditionGroup = ConditionGroup.clause().and((SQLCondition)Bookmark_Table.idString.eq((Object)md5)).and((SQLCondition)Bookmark_Table.application.eq((Object)application)).and((SQLCondition)Bookmark_Table.pageNumber.eq(pageNumber));
        return (Bookmark)ContentUtils.querySingle((Uri)OnyxBookmarkProvider.CONTENT_URI, Bookmark.class, (ConditionGroup)conditionGroup, null, (String[])new String[0]);
    }

    @Override
    public List<Bookmark> loadBookmarks(String application, String md5, OrderBy orderBy) {
        ConditionGroup conditionGroup = ConditionGroup.clause().and((SQLCondition)Bookmark_Table.idString.eq((Object)md5)).and((SQLCondition)Bookmark_Table.application.eq((Object)application));
        return ContentUtils.queryList((Uri)OnyxBookmarkProvider.CONTENT_URI, Bookmark.class, (ConditionGroup)conditionGroup, (String)orderBy.getQuery(), (String[])new String[0]);
    }

    @Override
    public void addBookmark(Bookmark bookmark) {
        bookmark.beforeSave();
        ContentUtils.insert((Uri)OnyxBookmarkProvider.CONTENT_URI, (Model)bookmark);
    }

    @Override
    public void deleteBookmark(Bookmark bookmark) {
        ContentUtils.delete((Uri)OnyxBookmarkProvider.CONTENT_URI, (Model)bookmark);
    }

    private Condition getNullOrEqualCondition(Property<String> property, String compare) {
        return compare == null ? property.isNull() : property.eq((Object)compare);
    }

    private Condition getNotNullOrEqualCondition(Property<String> property, String compare) {
        return compare == null ? property.isNotNull() : property.eq((Object)compare);
    }

    @Override
    public Library loadLibrary(String uniqueId) {
        return (Library)ContentUtils.querySingle((Uri)OnyxLibraryProvider.CONTENT_URI, Library.class, (ConditionGroup)ConditionGroup.clause().and((SQLCondition)Library_Table.idString.eq((Object)uniqueId)), null, (String[])new String[0]);
    }

    @Override
    public List<Library> loadAllLibrary(String parentId) {
        Condition condition = this.getNullOrEqualCondition(Library_Table.parentUniqueId, parentId);
        return ContentUtils.queryList((Uri)OnyxLibraryProvider.CONTENT_URI, Library.class, (ConditionGroup)ConditionGroup.clause().and((SQLCondition)condition), null, (String[])new String[0]);
    }

    @Override
    public void addLibrary(Library library) {
        library.beforeSave();
        ContentUtils.insert((Uri)OnyxLibraryProvider.CONTENT_URI, (Model)library);
    }

    @Override
    public void updateLibrary(Library library) {
        library.beforeSave();
        ContentUtils.update((Uri)OnyxLibraryProvider.CONTENT_URI, (Model)library);
    }

    @Override
    public void deleteLibrary(Library library) {
        ContentUtils.delete((Uri)OnyxLibraryProvider.CONTENT_URI, (Model)library);
    }

    @Override
    public void clearLibrary() {
        FlowManager.getContext().getContentResolver().delete(OnyxLibraryProvider.CONTENT_URI, null, null);
    }

    @Override
    public void clearThumbnail() {
    }

    @Override
    public boolean setThumbnail(Context context, String sourceMD5, Bitmap saveBitmap, OnyxThumbnail.ThumbnailKind kind) {
        return false;
    }

    @Override
    public boolean removeThumbnail(Context context, String sourceMD5, OnyxThumbnail.ThumbnailKind kind) {
        return false;
    }

    @Override
    public Thumbnail getThumbnail(Context context, String sourceMd5, OnyxThumbnail.ThumbnailKind kind) {
        return null;
    }

    @Override
    public Bitmap getThumbnailBitmap(Context context, String sourceMd5, OnyxThumbnail.ThumbnailKind kind) {
        return null;
    }

    public void deleteThumbnail(Thumbnail thumbnail) {
        thumbnail.delete();
    }

    public List<Thumbnail> loadThumbnail(Context context, String sourceMd5) {
        return new Select(new IProperty[0]).from(Thumbnail.class).where(new SQLCondition[]{Thumbnail_Table.sourceMD5.eq((Object)sourceMd5)}).queryList();
    }

    @Override
    public void clearMetadataCollection() {
        FlowManager.getContext().getContentResolver().delete(OnyxMetadataCollectionProvider.CONTENT_URI, null, null);
    }

    @Override
    public void addMetadataCollection(Context context, MetadataCollection collection) {
        collection.beforeSave();
        ContentUtils.insert((Uri)OnyxMetadataCollectionProvider.CONTENT_URI, (Model)collection);
    }

    @Override
    public void deleteMetadataCollection(Context context, String libraryUniqueId, String metadataMD5) {
        ConditionGroup group = ConditionGroup.clause().and((SQLCondition)MetadataCollection_Table.libraryUniqueId.eq((Object)libraryUniqueId));
        if (StringUtils.isNotBlank((String)metadataMD5)) {
            group.and((SQLCondition)MetadataCollection_Table.documentUniqueId.eq((Object)metadataMD5));
        }
        FlowManager.getContext().getContentResolver().delete(OnyxMetadataCollectionProvider.CONTENT_URI, group.getQuery(), null);
    }

    @Override
    public void deleteMetadataCollection(Context context, String libraryUniqueId) {
        FlowManager.getContext().getContentResolver().delete(OnyxMetadataCollectionProvider.CONTENT_URI, ConditionGroup.clause().and((SQLCondition)MetadataCollection_Table.libraryUniqueId.eq((Object)libraryUniqueId)).getQuery(), null);
    }

    @Override
    public void deleteMetadataCollectionByDocId(Context context, String docId) {
        FlowManager.getContext().getContentResolver().delete(OnyxMetadataCollectionProvider.CONTENT_URI, ConditionGroup.clause().and((SQLCondition)MetadataCollection_Table.documentUniqueId.eq((Object)docId)).getQuery(), null);
    }

    @Override
    public void updateMetadataCollection(MetadataCollection collection) {
        collection.beforeSave();
        ContentUtils.update((Uri)OnyxMetadataCollectionProvider.CONTENT_URI, (Model)collection);
    }

    @Override
    public MetadataCollection loadMetadataCollection(Context context, String libraryUniqueId, String metadataMD5) {
        ConditionGroup group = ConditionGroup.clause().and((SQLCondition)MetadataCollection_Table.libraryUniqueId.eq((Object)libraryUniqueId)).and((SQLCondition)MetadataCollection_Table.documentUniqueId.eq((Object)metadataMD5));
        return (MetadataCollection)ContentUtils.querySingle((Uri)OnyxMetadataCollectionProvider.CONTENT_URI, MetadataCollection.class, (ConditionGroup)group, null, (String[])new String[0]);
    }

    @Override
    public List<MetadataCollection> loadMetadataCollection(Context context, String libraryUniqueId) {
        ConditionGroup group = ConditionGroup.clause().and((SQLCondition)MetadataCollection_Table.libraryUniqueId.eq((Object)libraryUniqueId));
        return ContentUtils.queryList((Uri)OnyxMetadataCollectionProvider.CONTENT_URI, MetadataCollection.class, (ConditionGroup)group, null, (String[])new String[0]);
    }
}

