/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.db;

import android.content.Context;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.onyx.android.sdk.data.model.OnyxAccount;
import com.onyx.android.sdk.data.model.SecurePreferences;
import com.onyx.android.sdk.utils.StringUtils;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class AccountDatabase {
    private static final String CLOUD_TYPE = "onyxCloud";
    private static final String ACCOUNT_INFO_TAG = "accountInfo";
    private static final String JSON_TAG = "json";
    private LinkedHashMap<String, OnyxAccount> accountMap = new LinkedHashMap(16, 0.75f, true);
    private OnyxAccount currentAccount;

    public OnyxAccount getCurrentAccount() {
        if (this.currentAccount == null && this.accountMap.size() > 0) {
            Iterator<Map.Entry<String, OnyxAccount>> iterator = this.accountMap.entrySet().iterator();
            for (int i = 0; i < this.accountMap.size() - 1; ++i) {
                iterator.next();
            }
            this.currentAccount = iterator.next().getValue();
        }
        return this.currentAccount;
    }

    public void addAccount(OnyxAccount account) {
        this.accountMap.put(account.type, account);
        this.currentAccount = account;
    }

    public void clear() {
        this.accountMap.clear();
        this.currentAccount = null;
    }

    public void saveAccount(Context context) {
        SecurePreferences preferences = new SecurePreferences(context, CLOUD_TYPE, ACCOUNT_INFO_TAG, true);
        preferences.put(JSON_TAG, JSON.toJSONString(this.accountMap));
    }

    public OnyxAccount loadAccount(Context context) {
        SecurePreferences preferences = new SecurePreferences(context, CLOUD_TYPE, ACCOUNT_INFO_TAG, true);
        String string = preferences.getString(JSON_TAG);
        if (StringUtils.isNullOrEmpty((String)string)) {
            return null;
        }
        this.accountMap = (LinkedHashMap)JSON.parseObject((String)string, (TypeReference)new TypeReference<LinkedHashMap<String, OnyxAccount>>(){}, (Feature[])new Feature[0]);
        return this.getCurrentAccount();
    }

    public void clear(Context context) {
        SecurePreferences preferences = new SecurePreferences(context, CLOUD_TYPE, ACCOUNT_INFO_TAG, true);
        preferences.clear();
        this.accountMap.clear();
    }
}

