/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.compatability;

import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.BaseColumns;
import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.onyx.android.sdk.data.compatability.CursorUtil;
import com.onyx.android.sdk.data.compatability.OnyxBookProgress;
import com.onyx.android.sdk.data.compatability.SerializationUtil;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OnyxMetadata
implements Parcelable {
    private static final String TAG = "OnyxMetadata";
    public static final String DB_TABLE_NAME = "library_metadata";
    public static final Uri CONTENT_URI = Uri.parse((String)"content://com.onyx.android.sdk.OnyxCmsProvider/library_metadata");
    private static final int INVALID_ID = -1;
    private long mId = -1L;
    private String mMD5 = null;
    private String mName = null;
    private String mTitle = null;
    private ArrayList<String> mAuthors = null;
    private String mPublisher = null;
    private String mLanguage = null;
    private String mISBN = null;
    private String mDescription = null;
    private String mLocation = null;
    private String mNativeAbsolutePath = null;
    private long mSize = 0L;
    private String mEncoding = null;
    private Date mLastAccess = null;
    private Date mLastModified = null;
    private OnyxBookProgress mProgress = null;
    private int mFavorite = 0;
    private int mRating = 0;
    private ArrayList<String> mTags = null;
    private Set<String> series = null;
    private int libRefCount = 0;
    private JSONObject mExtraAttributes = new JSONObject();
    private String mType = null;
    private String cloudReference;
    public static final Parcelable.Creator<OnyxMetadata> CREATOR = new Parcelable.Creator<OnyxMetadata>(){

        public OnyxMetadata createFromParcel(Parcel source) {
            Log.i((String)OnyxMetadata.TAG, (String)"Create metadata from parcel!");
            return new OnyxMetadata(source);
        }

        public OnyxMetadata[] newArray(int size) {
            return new OnyxMetadata[size];
        }
    };

    public OnyxMetadata() {
    }

    public OnyxMetadata(Parcel source) {
        this.readFromParcel(source);
    }

    public static OnyxMetadata createFromFile(File file) {
        return OnyxMetadata.createFromFile(file, true);
    }

    public static OnyxMetadata createFromFile(String path) {
        return OnyxMetadata.createFromFile(new File(path));
    }

    public static OnyxMetadata createFromFile(File file, boolean computeMd5) {
        try {
            OnyxMetadata data = new OnyxMetadata();
            if (computeMd5) {
                String md5 = FileUtils.computeMD5((File)file);
                data.setMD5(md5);
            }
            OnyxMetadata.getBasicMetadataFromFile(data, file);
            return data;
        }
        catch (NoSuchAlgorithmException e) {
            Log.w((String)TAG, (Throwable)e);
        }
        catch (IOException e) {
            Log.w((String)TAG, (Throwable)e);
        }
        return null;
    }

    public static void getBasicMetadataFromFile(OnyxMetadata data, File file) {
        data.setName(file.getName());
        data.setLocation(file.getAbsolutePath());
        data.setNativeAbsolutePath(file.getAbsolutePath());
        data.setSize(file.length());
        data.setlastModified(new Date(FileUtils.getLastChangeTime((File)file)));
        data.setType(FileUtils.getFileExtension((String)file.getName()));
    }

    public Object clone() {
        OnyxMetadata data = new OnyxMetadata();
        data.setId(this.mId);
        data.setMD5(this.mMD5);
        data.setName(this.mName);
        data.setTitle(this.mTitle);
        data.setAuthors(this.mAuthors);
        data.setPublisher(this.mPublisher);
        data.setLanguage(this.mLanguage);
        data.setISBN(this.mISBN);
        data.setDescription(this.mDescription);
        data.setLocation(this.mLocation);
        data.setNativeAbsolutePath(this.mNativeAbsolutePath);
        data.setSize(this.mSize);
        data.setEncoding(this.mEncoding);
        data.setLastAccess(this.mLastAccess);
        data.setlastModified(this.mLastModified);
        data.setProgress(this.mProgress);
        data.setFavorite(this.mFavorite);
        data.setRating(this.mRating);
        data.setTags(this.mTags);
        data.putExtraAttributes((Map<String, Object>)this.mExtraAttributes);
        data.setType(this.mType);
        data.setCloudReference(this.cloudReference);
        data.setSeries(this.series);
        data.setLibRefCount(this.libRefCount);
        return data;
    }

    public boolean isDataFromDB() {
        return this.mId != -1L;
    }

    public long getId() {
        return this.mId;
    }

    public void setId(long id) {
        this.mId = id;
    }

    public String getMD5() {
        return this.mMD5;
    }

    public void setMD5(String md5) {
        this.mMD5 = md5;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public ArrayList<String> getAuthors() {
        return this.mAuthors;
    }

    public String getAuthorsString() {
        if (this.mAuthors != null) {
            return StringUtils.join(this.mAuthors, (String)",");
        }
        return "";
    }

    public String getAuthorsStringWithCustomSeparator(String separator) {
        if (this.mAuthors != null) {
            return StringUtils.join(this.mAuthors, (String)separator);
        }
        return "";
    }

    public void setAuthors(ArrayList<String> authors) {
        this.mAuthors = authors;
    }

    public String getPublisher() {
        return this.mPublisher;
    }

    public void setPublisher(String publisher) {
        this.mPublisher = publisher;
    }

    public String getLanguage() {
        return this.mLanguage;
    }

    public void setLanguage(String language) {
        this.mLanguage = language;
    }

    public String getISBN() {
        return this.mISBN;
    }

    public void setISBN(String isbn) {
        this.mISBN = isbn;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public String getLocation() {
        return this.mLocation;
    }

    public void setLocation(String location) {
        this.mLocation = location;
    }

    public String getNativeAbsolutePath() {
        return this.mNativeAbsolutePath;
    }

    public void setNativeAbsolutePath(String nativeAbsolutePath) {
        this.mNativeAbsolutePath = nativeAbsolutePath;
    }

    public long getSize() {
        return this.mSize;
    }

    public void setSize(long size) {
        this.mSize = size;
    }

    public String getEncoding() {
        return this.mEncoding;
    }

    public void setEncoding(String encoding) {
        this.mEncoding = encoding;
    }

    public Date getLastAccess() {
        return this.mLastAccess;
    }

    public void setLastAccess(Date lastAccess) {
        this.mLastAccess = lastAccess;
    }

    public void updateLastAccess() {
        this.mLastAccess = new Date();
    }

    public Date getLastModified() {
        return this.mLastModified;
    }

    public void setlastModified(Date lastModified) {
        this.mLastModified = lastModified;
    }

    public OnyxBookProgress getProgress() {
        return this.mProgress;
    }

    public void setProgress(OnyxBookProgress progress) {
        this.mProgress = progress;
    }

    public boolean isReaded() {
        return this.mProgress != null && this.mProgress.isFinished();
    }

    public boolean isReading() {
        return this.mProgress != null;
    }

    public boolean isNew() {
        return this.mProgress == null;
    }

    public int getFavorite() {
        return this.mFavorite;
    }

    public void setFavorite(int favorite) {
        this.mFavorite = favorite;
    }

    public int getRating() {
        return this.mRating;
    }

    public void setRating(int rating) {
        this.mRating = rating;
    }

    public ArrayList<String> getTags() {
        return this.mTags;
    }

    public void setTags(ArrayList<String> tags) {
        this.mTags = tags;
    }

    public String getTagsString() {
        if (this.mTags != null) {
            return StringUtils.join(this.mTags, (String)", ");
        }
        return "";
    }

    public JSONObject getExtraAttributes() {
        return this.mExtraAttributes;
    }

    public void putExtraAttribute(String key, Object value) {
        this.mExtraAttributes.put(key, value);
    }

    public void putExtraAttributes(Map<String, Object> value) {
        if (value != null) {
            this.mExtraAttributes.putAll(value);
        }
    }

    public String getType() {
        return this.mType;
    }

    public void setType(String type) {
        this.mType = type;
    }

    public String getCloudReference() {
        return this.cloudReference;
    }

    public void setCloudReference(String ref) {
        this.cloudReference = ref;
    }

    public final Set<String> getSeries() {
        return this.series;
    }

    public final String getSeriesString() {
        return SerializationUtil.setToString(this.series);
    }

    public void setSeries(Set<String> s) {
        this.series = s;
    }

    public int getLibRefCount() {
        return this.libRefCount;
    }

    public void setLibRefCount(int refCount) {
        this.libRefCount = refCount;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mId);
        dest.writeString(this.mMD5);
        dest.writeString(this.mName);
        dest.writeString(this.mTitle);
        dest.writeStringList(this.mAuthors);
        dest.writeString(this.mPublisher);
        dest.writeString(this.mLanguage);
        dest.writeString(this.mISBN);
        dest.writeString(this.mDescription);
        dest.writeString(this.mLocation);
        dest.writeString(this.mNativeAbsolutePath);
        dest.writeLong(this.mSize);
        dest.writeString(this.mEncoding);
        dest.writeString(SerializationUtil.dateToString(this.mLastAccess));
        dest.writeString(SerializationUtil.dateToString(this.mLastModified));
        dest.writeInt(this.mFavorite);
        dest.writeInt(this.mRating);
        dest.writeStringList(this.mTags);
        dest.writeString(JSON.toJSONString((Object)this.mExtraAttributes));
        dest.writeString(this.mType);
        dest.writeString(this.cloudReference);
        if (this.series != null && this.series.size() > 0) {
            dest.writeStringList(new ArrayList<String>(this.series));
        }
        dest.writeInt(this.libRefCount);
    }

    public void readFromParcel(Parcel source) {
        this.mId = source.readLong();
        this.mMD5 = source.readString();
        this.mName = source.readString();
        this.mTitle = source.readString();
        this.mAuthors = new ArrayList();
        source.readStringList(this.mAuthors);
        this.mPublisher = source.readString();
        this.mLanguage = source.readString();
        this.mISBN = source.readString();
        this.mDescription = source.readString();
        this.mLocation = source.readString();
        this.mNativeAbsolutePath = source.readString();
        this.mSize = source.readLong();
        this.mEncoding = source.readString();
        this.mLastAccess = SerializationUtil.dateFromString(source.readString());
        this.mLastModified = SerializationUtil.dateFromString(source.readString());
        this.mFavorite = source.readInt();
        this.mRating = source.readInt();
        this.mTags = new ArrayList();
        source.readStringList(this.mTags);
        this.mExtraAttributes = JSON.parseObject((String)source.readString());
        this.mType = source.readString();
        this.cloudReference = source.readString();
        ArrayList list = new ArrayList();
        source.readStringList(list);
        if (list.size() > 0) {
            this.series = new HashSet<String>(list);
        }
        this.libRefCount = source.readInt();
    }

    public static class Columns
    implements BaseColumns {
        public static String MD5 = "MD5";
        public static String NAME = "Name";
        public static String TITLE = "Title";
        public static String AUTHORS = "Authors";
        public static String PUBLISHER = "Publisher";
        public static String LANGUAGE = "Language";
        public static String ISBN = "ISBN";
        public static String DESCRIPTION = "Description";
        public static String LOCATION = "Location";
        public static String NATIVE_ABSOLUTE_PATH = "NativeAbsolutePath";
        public static String SIZE = "Size";
        public static String ENCODING = "Encoding";
        public static String LAST_ACCESS = "LastAccess";
        public static String LAST_MODIFIED = "LastModified";
        public static String PROGRESS = "Progress";
        public static String FAVORITE = "Favorite";
        public static String RATING = "Rating";
        public static String TAGS = "Tags";
        public static String EXTRA_ATTRIBUTES = "ExtraAttributes";
        public static String TYPE = "Type";
        public static String CLOUD_REFERENCE = "CloudReference";
        public static String SERIES = "Series";
        public static String LIB_REF_COUNT = "LibRefCount";
        private static boolean sColumnIndexesInitialized = false;
        private static int sColumnID = -1;
        private static int sColumnMD5 = -1;
        private static int sColumnName = -1;
        private static int sColumnTitle = -1;
        private static int sColumnAuthors = -1;
        private static int sColumnPublisher = -1;
        private static int sColumnLanguage = -1;
        private static int sColumnISBN = -1;
        private static int sColumnDescription = -1;
        private static int sColumnLocation = -1;
        private static int sColumnNativeAbsolutePath = -1;
        private static int sColumnSize = -1;
        private static int sColumnEncoding = -1;
        private static int sColumnLastAccess = -1;
        private static int sColumnLastModified = -1;
        private static int sColumnProgress = -1;
        private static int sColumnFavorite = -1;
        private static int sColumnRating = -1;
        private static int sColumnTags = -1;
        private static int sColumnExtraAttributes = -1;
        private static int sColumnType = -1;
        private static int sColumnCloudReference = -1;
        private static int sColumnSeries = -1;
        private static int sLibRefCount = -1;

        public static ContentValues createColumnData(OnyxMetadata data) {
            ContentValues values = new ContentValues();
            values.put(MD5, data.getMD5());
            values.put(NAME, data.getName());
            values.put(TITLE, data.getTitle());
            values.put(AUTHORS, SerializationUtil.authorsToString(data.getAuthors()));
            values.put(PUBLISHER, data.getPublisher());
            values.put(LANGUAGE, data.getLanguage());
            values.put(ISBN, data.getISBN());
            values.put(DESCRIPTION, data.getDescription());
            values.put(LOCATION, data.getLocation());
            values.put(NATIVE_ABSOLUTE_PATH, data.getNativeAbsolutePath());
            values.put(SIZE, Long.valueOf(data.getSize()));
            values.put(ENCODING, data.getEncoding());
            values.put(LAST_ACCESS, data.getLastAccess() == null ? null : Long.valueOf(data.getLastAccess().getTime()));
            values.put(LAST_MODIFIED, data.getLastModified() == null ? null : Long.valueOf(data.getLastModified().getTime()));
            values.put(PROGRESS, data.getProgress() == null ? null : data.getProgress().toString());
            values.put(FAVORITE, Integer.valueOf(data.getFavorite()));
            values.put(RATING, Integer.valueOf(data.getRating()));
            values.put(TAGS, SerializationUtil.tagsToString(data.getTags()));
            values.put(EXTRA_ATTRIBUTES, JSON.toJSONString((Object)data.getExtraAttributes()));
            values.put(TYPE, data.getType());
            values.put(CLOUD_REFERENCE, data.getCloudReference());
            values.put(SERIES, SerializationUtil.setToString(data.getSeries()));
            values.put(LIB_REF_COUNT, Integer.valueOf(data.getLibRefCount()));
            return values;
        }

        public static void readColumnData(Cursor c, OnyxMetadata data) {
            JSONObject extra_attrs;
            if (!sColumnIndexesInitialized) {
                sColumnID = c.getColumnIndex("_id");
                sColumnMD5 = c.getColumnIndex(MD5);
                sColumnName = c.getColumnIndex(NAME);
                sColumnTitle = c.getColumnIndex(TITLE);
                sColumnAuthors = c.getColumnIndex(AUTHORS);
                sColumnPublisher = c.getColumnIndex(PUBLISHER);
                sColumnLanguage = c.getColumnIndex(LANGUAGE);
                sColumnISBN = c.getColumnIndex(ISBN);
                sColumnDescription = c.getColumnIndex(DESCRIPTION);
                sColumnLocation = c.getColumnIndex(LOCATION);
                sColumnNativeAbsolutePath = c.getColumnIndex(NATIVE_ABSOLUTE_PATH);
                sColumnSize = c.getColumnIndex(SIZE);
                sColumnEncoding = c.getColumnIndex(ENCODING);
                sColumnLastAccess = c.getColumnIndex(LAST_ACCESS);
                sColumnLastModified = c.getColumnIndex(LAST_MODIFIED);
                sColumnProgress = c.getColumnIndex(PROGRESS);
                sColumnFavorite = c.getColumnIndex(FAVORITE);
                sColumnRating = c.getColumnIndex(RATING);
                sColumnTags = c.getColumnIndex(TAGS);
                sColumnExtraAttributes = c.getColumnIndex(EXTRA_ATTRIBUTES);
                sColumnType = c.getColumnIndex(TYPE);
                sColumnCloudReference = c.getColumnIndex(CLOUD_REFERENCE);
                sColumnSeries = c.getColumnIndex(SERIES);
                sLibRefCount = c.getColumnIndex(LIB_REF_COUNT);
                sColumnIndexesInitialized = true;
            }
            long id = CursorUtil.getLong(c, sColumnID);
            String md5 = CursorUtil.getString(c, sColumnMD5);
            String name = CursorUtil.getString(c, sColumnName);
            String title = CursorUtil.getString(c, sColumnTitle);
            String authors = CursorUtil.getString(c, sColumnAuthors);
            String publisher = CursorUtil.getString(c, sColumnPublisher);
            String language = CursorUtil.getString(c, sColumnLanguage);
            String isbn = CursorUtil.getString(c, sColumnISBN);
            String description = CursorUtil.getString(c, sColumnDescription);
            String location = CursorUtil.getString(c, sColumnLocation);
            String native_absolute_path = CursorUtil.getString(c, sColumnNativeAbsolutePath);
            Long size = CursorUtil.getLong(c, sColumnSize);
            String encoding = CursorUtil.getString(c, sColumnEncoding);
            Long last_access = CursorUtil.getLong(c, sColumnLastAccess);
            Long last_modified = CursorUtil.getLong(c, sColumnLastModified);
            OnyxBookProgress progress = OnyxBookProgress.fromString(CursorUtil.getString(c, sColumnProgress));
            int favorite = c.getInt(sColumnFavorite);
            int rating = c.getInt(sColumnRating);
            String tags = CursorUtil.getString(c, sColumnTags);
            String cloudReference = CursorUtil.getString(c, sColumnCloudReference);
            String series = CursorUtil.getString(c, sColumnSeries);
            int ref = c.getInt(sLibRefCount);
            try {
                extra_attrs = (JSONObject)JSON.parseObject((String)CursorUtil.getString(c, sColumnExtraAttributes), JSONObject.class);
            }
            catch (Throwable tr) {
                extra_attrs = new JSONObject();
            }
            String type = CursorUtil.getString(c, sColumnType);
            data.setId(id);
            data.setMD5(md5);
            data.setName(name);
            data.setTitle(title);
            data.setAuthors(SerializationUtil.authorsFromString(authors));
            data.setPublisher(publisher);
            data.setLanguage(language);
            data.setISBN(isbn);
            data.setDescription(description);
            data.setLocation(location);
            data.setNativeAbsolutePath(native_absolute_path);
            if (last_access != null && last_access > 0L) {
                data.setLastAccess(new Date(last_access));
            }
            data.setlastModified(new Date(last_modified == null ? 0L : last_modified));
            data.setSize(size == null ? 0L : size);
            data.setEncoding(encoding);
            data.setProgress(progress);
            data.setFavorite(favorite);
            data.setRating(rating);
            data.setTags(SerializationUtil.tagsFromString(tags));
            data.putExtraAttributes((Map<String, Object>)extra_attrs);
            data.setType(type);
            data.setCloudReference(cloudReference);
            data.setSeries(SerializationUtil.setFromString(series));
            data.setLibRefCount(ref);
        }

        public static OnyxMetadata readColumnData(Cursor c) {
            OnyxMetadata data = new OnyxMetadata();
            Columns.readColumnData(c, data);
            return data;
        }
    }
}

