/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import android.content.Context;
import android.util.Log;
import com.onyx.android.sdk.common.request.BaseCallback;
import com.onyx.android.sdk.common.request.BaseRequest;
import com.onyx.android.sdk.common.request.RequestManager;
import com.onyx.android.sdk.data.FileSystemManager;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.provider.DataProviderManager;
import com.onyx.android.sdk.data.request.data.BaseDataRequest;
import com.raizlabs.android.dbflow.config.DatabaseHolder;
import com.raizlabs.android.dbflow.config.FlowConfig;
import com.raizlabs.android.dbflow.config.FlowManager;
import java.util.List;

public class DataManager {
    private static final String TAG = DataManager.class.getSimpleName();
    private RequestManager requestManager;
    private DataProviderManager dataProviderManager = new DataProviderManager();
    private FileSystemManager fileSystemManager;

    public DataManager() {
        this.requestManager = new RequestManager();
        this.fileSystemManager = new FileSystemManager();
    }

    public static void init(Context context, List<Class<? extends DatabaseHolder>> list) {
        FlowConfig.Builder builder = new FlowConfig.Builder(context);
        if (list != null) {
            for (Class<? extends DatabaseHolder> tClass : list) {
                builder.addDatabaseHolder(tClass);
            }
        }
        FlowManager.init((FlowConfig)builder.build());
    }

    public static void cleanUp() {
    }

    private final Runnable generateRunnable(final BaseDataRequest request) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    request.execute(DataManager.this);
                }
                catch (Exception exception) {
                    Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)exception));
                    request.setException(exception);
                }
                finally {
                    request.afterExecute(DataManager.this);
                    DataManager.this.requestManager.dumpWakelocks();
                    DataManager.this.requestManager.removeRequest((BaseRequest)request, DataManager.this.getIdentifier(request));
                }
            }
        };
        return runnable;
    }

    public void submit(Context context, BaseDataRequest request, BaseCallback callback) {
        this.requestManager.submitRequest(context, this.getIdentifier(request), (BaseRequest)request, this.generateRunnable(request), callback);
    }

    public void submitToMulti(Context context, BaseDataRequest request, BaseCallback callback) {
        this.requestManager.submitRequestToMultiThreadPool(context, this.getIdentifier(request), (BaseRequest)request, this.generateRunnable(request), callback);
    }

    private final String getIdentifier(BaseDataRequest request) {
        return request.getIdentifier();
    }

    public final RequestManager getRequestManager() {
        return this.requestManager;
    }

    public final DataProviderManager getDataProviderManager() {
        return this.dataProviderManager;
    }

    public DataProviderBase getRemoteContentProvider() {
        this.getDataProviderManager();
        return DataProviderManager.getRemoteDataProvider();
    }

    public final FileSystemManager getFileSystemManager() {
        return this.fileSystemManager;
    }
}

