/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import com.onyx.android.sdk.common.request.BaseCallback;
import com.onyx.android.sdk.common.request.BaseRequest;
import com.onyx.android.sdk.common.request.RequestManager;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.utils.CloudConf;
import com.onyx.android.sdk.utils.LocaleUtils;
import com.raizlabs.android.dbflow.config.FlowConfig;
import com.raizlabs.android.dbflow.config.FlowManager;

public class CloudManager {
    private CloudConf cloudConf;
    private RequestManager requestManager = new RequestManager(5);
    private CloudConf chinaCloudConf;
    private CloudConf globalCloudConf;

    public CloudManager() {
        this.initCloudConf();
    }

    private void initCloudConf() {
        this.chinaCloudConf = new CloudConf("http://dev.onyx-international.cn", "http://dev.onyx-international.cn/api/1/", "oss");
        this.globalCloudConf = new CloudConf("http://dev.onyx-international.cn", "http://dev.onyx-international.cn/api/1/", "oss");
    }

    private CloudConf useCloudConf() {
        this.cloudConf = LocaleUtils.isChinese() ? this.chinaCloudConf : this.globalCloudConf;
        return this.cloudConf;
    }

    public void acquireWakeLock(Context context, String tag) {
        this.requestManager.acquireWakeLock(context, tag);
    }

    public void releaseWakeLock() {
        this.requestManager.releaseWakeLock();
    }

    private final Runnable generateRunnable(final BaseCloudRequest request) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    request.beforeExecute(CloudManager.this);
                    request.execute(CloudManager.this);
                }
                catch (Throwable tr) {
                    request.setException(tr);
                }
                finally {
                    request.afterExecute(CloudManager.this);
                    CloudManager.this.requestManager.dumpWakelocks();
                    CloudManager.this.requestManager.removeRequest((BaseRequest)request);
                }
            }
        };
        return runnable;
    }

    public boolean submitRequest(Context context, BaseCloudRequest request, BaseCallback callback) {
        Runnable runnable = this.generateRunnable(request);
        return this.requestManager.submitRequestToMultiThreadPool(context, (BaseRequest)request, runnable, callback);
    }

    public Handler getLooperHandler() {
        return this.requestManager.getLooperHandler();
    }

    public static boolean isWifiConnected(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm == null) {
            return false;
        }
        NetworkInfo wifi = cm.getNetworkInfo(1);
        if (wifi == null) {
            return false;
        }
        return wifi.isConnected();
    }

    public final CloudConf getCloudConf() {
        return this.useCloudConf();
    }

    public static void initDatabase(Context context) {
        try {
            FlowConfig.Builder builder = new FlowConfig.Builder(context);
            FlowManager.init((FlowConfig)builder.build());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void terminateCloudDatabase() {
        FlowManager.destroy();
    }
}

