/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import com.onyx.android.sdk.data.compatability.OnyxThumbnail;
import com.onyx.android.sdk.data.model.Thumbnail;
import com.onyx.android.sdk.dataprovider.R;
import com.onyx.android.sdk.device.EnvironmentUtil;
import com.onyx.android.sdk.utils.BitmapUtils;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.StringUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class ThumbnailUtils {
    public static final String thumbnail_folder = ".thumbnails";
    public static final String preferred_extension = ".png";
    private static Map<String, Integer> a = new HashMap<String, Integer>();

    public static Map<String, Integer> defaultThumbnailMapping() {
        if (a == null) {
            a = new HashMap<String, Integer>();
            a.put("acsm", R.drawable.acsm);
            a.put("bmp", R.drawable.bmp);
            a.put("chm", R.drawable.chm);
            a.put("djvu", R.drawable.djvu);
            a.put("doc", R.drawable.doc);
            a.put("docx", R.drawable.docx);
            a.put("eba3", R.drawable.eba3);
            a.put("ebaml", R.drawable.ebaml);
            a.put("epub", R.drawable.epub);
            a.put("fb2", R.drawable.fb2);
            a.put("gif", R.drawable.gif);
            a.put("htm", R.drawable.htm);
            a.put("html", R.drawable.html);
            a.put("jpg", R.drawable.jpg);
            a.put("mobi", R.drawable.mobi);
            a.put("mp3", R.drawable.mp3);
            a.put("pdb", R.drawable.pdb);
            a.put("pdf", R.drawable.pdf);
            a.put("png", R.drawable.png);
            a.put("ppt", R.drawable.ppt);
            a.put("prc", R.drawable.prc);
            a.put("rar", R.drawable.rar);
            a.put("rtf", R.drawable.rtf);
            a.put("tiff", R.drawable.tiff);
            a.put("txt", R.drawable.txt);
            a.put("wma", R.drawable.wma);
            a.put("xls", R.drawable.xls);
            a.put("zip", R.drawable.zip);
            a.put("cbz", R.drawable.cbz);
        }
        return a;
    }

    public static Integer thumbnailUnknown() {
        return R.drawable.unknown_document;
    }

    public static Integer thumbnailDefault() {
        return R.drawable.book_default_cover;
    }

    public static Integer libraryThumbnailDefault() {
        return R.drawable.library_default_cover;
    }

    public static Bitmap loadThumbnail(Context context, int resId) {
        BitmapDrawable bitmapDrawable = (BitmapDrawable)context.getResources().getDrawable(resId);
        return bitmapDrawable == null ? null : bitmapDrawable.getBitmap();
    }

    public static Bitmap loadDefaultThumbnailFromExtension(Context context, String ext) {
        if (StringUtils.isNullOrEmpty((String)ext)) {
            return ThumbnailUtils.loadThumbnail(context, ThumbnailUtils.thumbnailUnknown());
        }
        if (ThumbnailUtils.defaultThumbnailMapping().containsKey(ext)) {
            return ThumbnailUtils.loadThumbnail(context, ThumbnailUtils.defaultThumbnailMapping().get(ext));
        }
        return ThumbnailUtils.loadThumbnail(context, ThumbnailUtils.thumbnailDefault());
    }

    public static String getThumbnailFile(Context context, String sourceMD5, String thumbnailKind) {
        String string = EnvironmentUtil.getExternalStorageAppCacheDirectory((String)context.getPackageName()) + File.separator + thumbnail_folder + File.separator + sourceMD5 + "." + thumbnailKind + preferred_extension;
        return string;
    }

    public static Bitmap getThumbnailBitmap(Context context, String sourceMD5, String thumbnailKind) {
        return BitmapUtils.loadBitmapFromFile((String)ThumbnailUtils.getThumbnailFile(context, sourceMD5, thumbnailKind));
    }

    public static Bitmap getThumbnailBitmap(Context context, Thumbnail thumbnail) {
        Bitmap bitmap = ThumbnailUtils.getThumbnailBitmap(context, thumbnail.getSourceMD5(), thumbnail.getThumbnailKind().toString());
        if (bitmap == null) {
            bitmap = ThumbnailUtils.loadDefaultThumbnailFromExtension(context, FileUtils.getFileExtension((String)thumbnail.getPath()));
        }
        return bitmap;
    }

    public static boolean saveThumbnailBitmap(Context context, Thumbnail thumbnail, Bitmap saveBitmap) {
        String string = ThumbnailUtils.getThumbnailFile(context, thumbnail.getSourceMD5(), thumbnail.getThumbnailKind().toString());
        if (!FileUtils.ensureFileExists((String)string)) {
            return false;
        }
        boolean bl = BitmapUtils.saveBitmap((Bitmap)ThumbnailUtils.a(saveBitmap, thumbnail.getThumbnailKind()), (String)string);
        if (bl) {
            thumbnail.setPath(string);
            thumbnail.save();
        }
        return bl;
    }

    private static Bitmap a(Bitmap bitmap, OnyxThumbnail.ThumbnailKind thumbnailKind) {
        Bitmap bitmap2 = bitmap;
        switch (thumbnailKind) {
            case Original: {
                bitmap2 = bitmap;
                break;
            }
            case Large: {
                bitmap2 = OnyxThumbnail.createLargeThumbnail(bitmap);
                break;
            }
            case Middle: {
                bitmap2 = OnyxThumbnail.createMiddleThumbnail(bitmap);
                break;
            }
            case Small: {
                bitmap2 = OnyxThumbnail.createSmallThumbnail(bitmap);
            }
        }
        return bitmap2;
    }
}

