/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import android.content.Context;
import com.onyx.android.sdk.data.model.Book;
import com.onyx.android.sdk.data.model.OnyxStatisticsModel;
import com.onyx.android.sdk.data.model.OnyxStatisticsModel_Table;
import com.onyx.android.sdk.utils.MapUtils;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.Where;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class StatisticsUtils {
    public static void saveStatistics(Context context, OnyxStatisticsModel statisticsData) {
        if (statisticsData == null) {
            return;
        }
        statisticsData.save();
    }

    public static void saveStatisticsList(Context context, Collection<OnyxStatisticsModel> list) {
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase((String)"OnyxStatisticsModel").getWritableDatabase();
        databaseWrapper.beginTransaction();
        for (OnyxStatisticsModel onyxStatisticsModel : list) {
            onyxStatisticsModel.save();
        }
        databaseWrapper.setTransactionSuccessful();
        databaseWrapper.endTransaction();
    }

    public static void deleteStatisticsList(Context context, Collection<OnyxStatisticsModel> list) {
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase((String)"OnyxStatisticsModel").getWritableDatabase();
        databaseWrapper.beginTransaction();
        for (OnyxStatisticsModel onyxStatisticsModel : list) {
            onyxStatisticsModel.delete();
        }
        databaseWrapper.setTransactionSuccessful();
        databaseWrapper.endTransaction();
    }

    public static void deleteStatisticsListByStatus(Context context, int status) {
        List list = (List)StatisticsUtils.loadStatisticsListByStatus(context, status);
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase((String)"OnyxStatisticsModel").getWritableDatabase();
        databaseWrapper.beginTransaction();
        for (OnyxStatisticsModel onyxStatisticsModel : list) {
            onyxStatisticsModel.delete();
        }
        databaseWrapper.setTransactionSuccessful();
        databaseWrapper.endTransaction();
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsListByStatus(Context context, int count, int status) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLCondition[]{OnyxStatisticsModel_Table.status.eq((Object)status)}).limit(count);
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsListByStatus(Context context, int status) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLCondition[]{OnyxStatisticsModel_Table.status.eq((Object)status)});
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsList(Context context, String md5short, int type) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLCondition[]{OnyxStatisticsModel_Table.type.eq((Object)type)}).and((SQLCondition)OnyxStatisticsModel_Table.md5short.eq((Object)md5short));
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsList(Context context, String md5short, int type, Date fromTime) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLCondition[]{OnyxStatisticsModel_Table.type.eq((Object)type)}).and((SQLCondition)OnyxStatisticsModel_Table.md5short.eq((Object)md5short)).and((SQLCondition)OnyxStatisticsModel_Table.eventTime.greaterThan((Object)fromTime));
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsList(Context context, int type) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLCondition[]{OnyxStatisticsModel_Table.type.eq((Object)type)});
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsList(Context context, int type, int status) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLCondition[]{OnyxStatisticsModel_Table.type.eq((Object)type)}).and((SQLCondition)OnyxStatisticsModel_Table.status.eq((Object)status));
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsList(Context context, Date fromTime) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLCondition[]{OnyxStatisticsModel_Table.eventTime.greaterThan((Object)fromTime)});
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsList(Context context, Date fromTime, int type) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLCondition[]{OnyxStatisticsModel_Table.eventTime.greaterThan((Object)fromTime)}).and((SQLCondition)OnyxStatisticsModel_Table.type.eq((Object)type));
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsListByMd5short(Context context, String md5short) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLCondition[]{OnyxStatisticsModel_Table.md5short.eq((Object)md5short)});
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsListOrderByTime(Context context, int type, boolean ascending) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLCondition[]{OnyxStatisticsModel_Table.type.eq((Object)type)}).orderBy(OnyxStatisticsModel_Table.eventTime, ascending);
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsListOrderByTime(Context context, int type, int status, boolean ascending) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLCondition[]{OnyxStatisticsModel_Table.type.eq((Object)type)}).and((SQLCondition)OnyxStatisticsModel_Table.status.eq((Object)status)).orderBy(OnyxStatisticsModel_Table.eventTime, ascending);
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsListOrderByTime(Context context, String md5short, boolean ascending) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLCondition[]{OnyxStatisticsModel_Table.md5short.eq((Object)md5short)}).orderBy(OnyxStatisticsModel_Table.eventTime, ascending);
        List list = where.queryList();
        return list;
    }

    public static Collection<OnyxStatisticsModel> loadStatisticsListOrderByTime(Context context, String md5short, int type, boolean ascending) {
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLCondition[]{OnyxStatisticsModel_Table.type.eq((Object)type)}).and((SQLCondition)OnyxStatisticsModel_Table.md5short.eq((Object)md5short)).orderBy(OnyxStatisticsModel_Table.eventTime, ascending);
        List list = where.queryList();
        return list;
    }

    public static String getBookMd5(Context context, String md5short) {
        String string = "";
        Select select = new Select(new IProperty[0]);
        Where where = select.from(OnyxStatisticsModel.class).where(new SQLCondition[]{OnyxStatisticsModel_Table.md5short.eq((Object)md5short)}).limit(1);
        List list = where.queryList();
        if (list != null && list.size() > 0) {
            string = ((OnyxStatisticsModel)list.get(0)).getMd5();
        }
        return string;
    }

    public static List<Integer> getEventHourlyAgg(List<OnyxStatisticsModel> statisticsList, int count) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(count);
        for (int i = 0; i < count; ++i) {
            arrayList.add(0);
        }
        for (OnyxStatisticsModel onyxStatisticsModel : statisticsList) {
            int n = onyxStatisticsModel.getEventTime().getHours();
            if (n >= arrayList.size()) continue;
            int n2 = (Integer)arrayList.get(n);
            arrayList.set(n, ++n2);
        }
        return arrayList;
    }

    public static Book getLongestBook(List<OnyxStatisticsModel> statisticsModels) {
        Object object;
        HashMap<Object, Long> hashMap = new HashMap<Object, Long>();
        for (OnyxStatisticsModel object22 : statisticsModels) {
            object = object22.getMd5short();
            long l = object22.getDurationTime();
            if (hashMap.containsKey(object)) {
                l = (Long)hashMap.get(object);
                l += object22.getDurationTime().longValue();
            }
            hashMap.put(object, l);
        }
        if (hashMap.size() == 0) {
            return null;
        }
        LinkedHashMap linkedHashMap = (LinkedHashMap)MapUtils.sortByValue(hashMap);
        Book book = new Book();
        object = MapUtils.getLast((Map)linkedHashMap);
        book.setMd5short((String)object.getKey());
        book.setReadingTime((Long)object.getValue());
        return book;
    }

    public static Book getMostCarefullyBook(List<OnyxStatisticsModel> statisticsModels) {
        Object object;
        HashMap<Object, Long> hashMap = new HashMap<Object, Long>();
        for (OnyxStatisticsModel object22 : statisticsModels) {
            object = object22.getMd5short();
            long l = 1L;
            if (hashMap.containsKey(object)) {
                l = (Long)hashMap.get(object);
                ++l;
            }
            hashMap.put(object, l);
        }
        if (hashMap.size() == 0) {
            return null;
        }
        LinkedHashMap linkedHashMap = (LinkedHashMap)MapUtils.sortByValue(hashMap);
        Book book = new Book();
        object = MapUtils.getLast((Map)linkedHashMap);
        book.setMd5short((String)object.getKey());
        return book;
    }

    public static List<Book> getRecentBooks(List<OnyxStatisticsModel> statisticsModels, int count) {
        ArrayList<Book> arrayList = new ArrayList<Book>();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (OnyxStatisticsModel object : statisticsModels) {
            if (linkedHashSet.size() >= count) break;
            linkedHashSet.add(object.getMd5short());
        }
        for (String string : linkedHashSet) {
            Book book = new Book();
            book.setMd5short(string);
            arrayList.add(book);
        }
        return arrayList;
    }
}

