/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import com.onyx.android.sdk.data.BookFilter;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.SortBy;
import com.onyx.android.sdk.data.SortOrder;
import com.onyx.android.sdk.data.model.MetadataCollection;
import com.onyx.android.sdk.data.model.MetadataCollection_Table;
import com.onyx.android.sdk.data.model.Metadata_Table;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.sql.language.BaseModelQueriable;
import com.raizlabs.android.dbflow.sql.language.Condition;
import com.raizlabs.android.dbflow.sql.language.ConditionGroup;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.Where;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.language.property.Property;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class MetadataQueryArgsBuilder {
    public static QueryArgs libraryAllBookQuery(String libraryUniqueId, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = MetadataQueryArgsBuilder.allBooksQuery(sortBy, sortOrder);
        queryArgs.libraryUniqueId = libraryUniqueId;
        return MetadataQueryArgsBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryAllBookQuery(String libraryUniqueId, Set<String> fileTypes, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = MetadataQueryArgsBuilder.allBooksQuery(fileTypes, sortBy, sortOrder);
        queryArgs.libraryUniqueId = libraryUniqueId;
        return MetadataQueryArgsBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryAllBookQuery(String libraryUniqueId, Set<String> fileTypes, OrderBy orderBy) {
        QueryArgs queryArgs = QueryArgs.queryBy(MetadataQueryArgsBuilder.orTypeCondition(fileTypes), orderBy);
        queryArgs.libraryUniqueId = libraryUniqueId;
        return MetadataQueryArgsBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryNewBookListQuery(String libraryUniqueId, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = MetadataQueryArgsBuilder.newBookListQuery(sortBy, sortOrder);
        queryArgs.libraryUniqueId = libraryUniqueId;
        return MetadataQueryArgsBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryFinishReadQuery(String libraryUniqueId, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = MetadataQueryArgsBuilder.finishReadQuery(sortBy, sortOrder);
        queryArgs.libraryUniqueId = libraryUniqueId;
        return MetadataQueryArgsBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryRecentReadingQuery(String libraryUniqueId, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = MetadataQueryArgsBuilder.recentReadingQuery(sortBy, sortOrder);
        queryArgs.libraryUniqueId = libraryUniqueId;
        return MetadataQueryArgsBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryRecentAddQuery(String libraryUniqueId, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = new QueryArgs(sortBy, sortOrder);
        queryArgs.libraryUniqueId = libraryUniqueId;
        queryArgs.conditionGroup = MetadataQueryArgsBuilder.recentAddCondition();
        return MetadataQueryArgsBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryTagsFilterQuery(String libraryUniqueId, Set<String> tags, SortBy sortBy, SortOrder order) {
        QueryArgs queryArgs = MetadataQueryArgsBuilder.tagsFilterQuery(tags, sortBy, order);
        queryArgs.libraryUniqueId = libraryUniqueId;
        return MetadataQueryArgsBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs librarySearchQuery(String libraryUniqueId, String search, SortBy sortBy, SortOrder order) {
        QueryArgs queryArgs = MetadataQueryArgsBuilder.searchQuery(search, sortBy, order);
        queryArgs.libraryUniqueId = libraryUniqueId;
        return MetadataQueryArgsBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs allBooksQuery(SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.ALL);
        return MetadataQueryArgsBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs allBooksQuery(Set<String> fileTypes, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.ALL);
        queryArgs.fileType = fileTypes;
        queryArgs.libraryUniqueId = BookFilter.ALL.toString();
        return MetadataQueryArgsBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs allBooksQuery(Set<String> fileTypes, OrderBy orderBy) {
        return QueryArgs.queryBy(MetadataQueryArgsBuilder.orTypeCondition(fileTypes), orderBy);
    }

    public static QueryArgs newBookListQuery(SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.NEW_BOOKS);
        queryArgs.libraryUniqueId = BookFilter.NEW_BOOKS.toString();
        return MetadataQueryArgsBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs finishReadQuery(SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.READED);
        queryArgs.libraryUniqueId = BookFilter.READED.toString();
        return MetadataQueryArgsBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs recentReadingQuery(SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.READING);
        queryArgs.libraryUniqueId = BookFilter.READING.toString();
        return MetadataQueryArgsBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs tagsFilterQuery(Set<String> tags, SortBy sortBy, SortOrder order) {
        QueryArgs queryArgs = new QueryArgs(sortBy, order).appendFilter(BookFilter.TAG);
        queryArgs.tags = tags;
        queryArgs.libraryUniqueId = BookFilter.TAG.toString();
        return MetadataQueryArgsBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs searchQuery(String search, SortBy sortBy, SortOrder order) {
        QueryArgs queryArgs = new QueryArgs(sortBy, order).appendFilter(BookFilter.SEARCH);
        queryArgs.query = search;
        queryArgs.libraryUniqueId = BookFilter.SEARCH.toString();
        return MetadataQueryArgsBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs recentAddQuery() {
        QueryArgs queryArgs = QueryArgs.queryBy(MetadataQueryArgsBuilder.recentAddCondition(), MetadataQueryArgsBuilder.getOrderByUpdateAt().descending());
        queryArgs.libraryUniqueId = BookFilter.RECENT_ADD.toString();
        return queryArgs;
    }

    public static ConditionGroup newBookListCondition() {
        return ConditionGroup.clause().and((SQLCondition)Metadata_Table.lastAccess.isNull()).or((SQLCondition)Metadata_Table.lastAccess.lessThanOrEq((Object)new Date(0L)));
    }

    public static ConditionGroup finishReadCondition() {
        return ConditionGroup.clause().and((SQLCondition)Metadata_Table.lastAccess.isNotNull()).and((SQLCondition)Metadata_Table.progress.isNotNull());
    }

    public static ConditionGroup recentReadingCondition() {
        return ConditionGroup.clause().and((SQLCondition)Metadata_Table.progress.isNotNull()).and((SQLCondition)Metadata_Table.lastAccess.isNotNull()).and((SQLCondition)Metadata_Table.lastAccess.notEq((Object)new Date(0L)));
    }

    public static ConditionGroup recentAddCondition() {
        return ConditionGroup.clause().and((SQLCondition)Metadata_Table.progress.isNull()).and((SQLCondition)Metadata_Table.lastAccess.isNull());
    }

    public static ConditionGroup orTypeCondition(Set<String> fileTypes) {
        if (CollectionUtils.isNullOrEmpty(fileTypes)) {
            return ConditionGroup.clause();
        }
        ConditionGroup conditionGroup = ConditionGroup.clause();
        ArrayList<Condition> arrayList = new ArrayList<Condition>();
        for (String string : fileTypes) {
            arrayList.add(Metadata_Table.type.eq((Object)string));
        }
        return conditionGroup.orAll(arrayList);
    }

    public static ConditionGroup orTagsCondition(Set<String> tags) {
        if (CollectionUtils.isNullOrEmpty(tags)) {
            return ConditionGroup.clause();
        }
        ArrayList<Condition> arrayList = new ArrayList<Condition>();
        for (String string : tags) {
            arrayList.add(Metadata_Table.tags.like(string));
        }
        return ConditionGroup.clause().orAll(arrayList);
    }

    public static ConditionGroup orSearchCondition(String search) {
        if (StringUtils.isNullOrEmpty((String)search)) {
            return ConditionGroup.clause();
        }
        return ConditionGroup.clause().or((SQLCondition)MetadataQueryArgsBuilder.matchLike(Metadata_Table.title, search)).or((SQLCondition)MetadataQueryArgsBuilder.matchLike(Metadata_Table.name, search)).or((SQLCondition)MetadataQueryArgsBuilder.matchLike(Metadata_Table.authors, search));
    }

    public static List<OrderBy> getOrderByList() {
        ArrayList<OrderBy> arrayList = new ArrayList<OrderBy>();
        arrayList.add(OrderBy.fromProperty(Metadata_Table.name).ascending());
        return arrayList;
    }

    public static OrderBy getOrderByUpdateAt() {
        return MetadataQueryArgsBuilder.getOrderBy(Metadata_Table.updatedAt);
    }

    public static OrderBy getOrderByCreateAt() {
        return MetadataQueryArgsBuilder.getOrderBy(Metadata_Table.createdAt);
    }

    public static OrderBy getOrderByName() {
        return MetadataQueryArgsBuilder.getOrderBy(Metadata_Table.name).ascending();
    }

    public static OrderBy getOrderBy(IProperty property) {
        return OrderBy.fromProperty((IProperty)property);
    }

    public static void andWith(ConditionGroup parent, ConditionGroup child) {
        if (parent != null && child != null) {
            parent.and((SQLCondition)child);
        }
    }

    public static Condition matchLike(Property<String> property, String match) {
        if (StringUtils.isNullOrEmpty((String)match)) {
            return null;
        }
        return property.like("%" + match + "%");
    }

    public static ConditionGroup matchLikeSet(Property<String> property, Set<String> set) {
        if (set == null || set.size() <= 0) {
            return null;
        }
        ConditionGroup conditionGroup = ConditionGroup.clause();
        for (String string : set) {
            Condition condition = MetadataQueryArgsBuilder.matchLike(property, string);
            if (condition == null) continue;
            conditionGroup.or((SQLCondition)condition);
        }
        return conditionGroup;
    }

    public static ConditionGroup matchEqualSet(Property<String> property, Set<String> set) {
        if (set == null || set.size() <= 0) {
            return null;
        }
        ConditionGroup conditionGroup = ConditionGroup.clause();
        for (String string : set) {
            conditionGroup.or((SQLCondition)property.eq((Object)string));
        }
        return conditionGroup;
    }

    private static Condition a(Property<String> property, String string) {
        return string == null ? property.isNull() : property.eq((Object)string);
    }

    private static Condition b(Property<String> property, String string) {
        return string == null ? property.isNotNull() : property.eq((Object)string);
    }

    private static Condition.In a(Property property, Where where, boolean bl) {
        return bl ? property.in((BaseModelQueriable)where, new BaseModelQueriable[0]) : property.notIn((BaseModelQueriable)where, new BaseModelQueriable[0]);
    }

    public static QueryArgs generateQueryArgs(QueryArgs args) {
        switch (args.filter) {
            case ALL: {
                args.conditionGroup = MetadataQueryArgsBuilder.orTypeCondition(args.fileType);
                break;
            }
            case NEW_BOOKS: {
                args.conditionGroup = MetadataQueryArgsBuilder.newBookListCondition();
                break;
            }
            case READING: {
                args.conditionGroup = MetadataQueryArgsBuilder.recentReadingCondition();
                break;
            }
            case READED: {
                args.conditionGroup = MetadataQueryArgsBuilder.finishReadCondition();
                break;
            }
            case TAG: {
                args.conditionGroup = MetadataQueryArgsBuilder.orTagsCondition(args.tags);
                break;
            }
            case SEARCH: {
                args.conditionGroup = MetadataQueryArgsBuilder.orSearchCondition(args.query);
            }
        }
        MetadataQueryArgsBuilder.generateQueryArgsSortBy(args);
        MetadataQueryArgsBuilder.generateCriteriaCondition(args);
        return args;
    }

    private static OrderBy a(OrderBy orderBy, boolean bl) {
        if (bl) {
            orderBy.ascending();
        } else {
            orderBy.descending();
        }
        return orderBy;
    }

    public static OrderBy generateOrderBy(SortBy sortBy, SortOrder order) {
        boolean bl = order == SortOrder.Asc;
        OrderBy orderBy = MetadataQueryArgsBuilder.a(OrderBy.fromProperty(Metadata_Table.name), true);
        switch (sortBy) {
            case None: 
            case Name: {
                break;
            }
            case FileType: {
                orderBy = MetadataQueryArgsBuilder.a(OrderBy.fromProperty(Metadata_Table.type), bl);
                break;
            }
            case Size: {
                orderBy = MetadataQueryArgsBuilder.a(OrderBy.fromProperty((IProperty)Metadata_Table.size), bl);
                break;
            }
            case CreationTime: {
                orderBy = MetadataQueryArgsBuilder.a(OrderBy.fromProperty(Metadata_Table.lastModified), bl);
                break;
            }
            case BookTitle: {
                orderBy = MetadataQueryArgsBuilder.a(OrderBy.fromProperty(Metadata_Table.title), bl);
                break;
            }
            case Author: {
                orderBy = MetadataQueryArgsBuilder.a(OrderBy.fromProperty(Metadata_Table.authors), bl);
                break;
            }
            case Publisher: {
                orderBy = MetadataQueryArgsBuilder.a(OrderBy.fromProperty(Metadata_Table.publisher), bl);
                break;
            }
            case LastOpenTime: {
                orderBy = MetadataQueryArgsBuilder.a(OrderBy.fromProperty(Metadata_Table.lastAccess), bl);
                break;
            }
            case RecentlyRead: {
                orderBy = MetadataQueryArgsBuilder.a(OrderBy.fromProperty(Metadata_Table.lastAccess), bl);
                break;
            }
            case Total: {
                orderBy = MetadataQueryArgsBuilder.a(OrderBy.fromProperty(Metadata_Table.lastAccess), bl);
                break;
            }
            case StartTime: {
                orderBy = MetadataQueryArgsBuilder.a(OrderBy.fromProperty(Metadata_Table.lastAccess), bl);
                break;
            }
            case InstallTime: {
                orderBy = MetadataQueryArgsBuilder.a(OrderBy.fromProperty(Metadata_Table.lastAccess), bl);
            }
        }
        return orderBy;
    }

    public static void generateQueryArgsSortBy(QueryArgs args) {
        args.orderByList.clear();
        args.orderByList.add(MetadataQueryArgsBuilder.generateOrderBy(args.sortBy, args.order));
    }

    public static void generateCriteriaCondition(QueryArgs args) {
        MetadataQueryArgsBuilder.andWith(args.conditionGroup, MetadataQueryArgsBuilder.matchLikeSet(Metadata_Table.authors, args.author));
        MetadataQueryArgsBuilder.andWith(args.conditionGroup, MetadataQueryArgsBuilder.matchLikeSet(Metadata_Table.tags, args.tags));
        MetadataQueryArgsBuilder.andWith(args.conditionGroup, MetadataQueryArgsBuilder.matchLikeSet(Metadata_Table.series, args.series));
        MetadataQueryArgsBuilder.andWith(args.conditionGroup, MetadataQueryArgsBuilder.matchLikeSet(Metadata_Table.title, args.title));
        MetadataQueryArgsBuilder.andWith(args.conditionGroup, MetadataQueryArgsBuilder.matchLikeSet(Metadata_Table.type, args.fileType));
    }

    public static QueryArgs generateMetadataInQueryArgs(QueryArgs queryArgs) {
        Where where = new Select(new IProperty[]{MetadataCollection_Table.documentUniqueId.withTable()}).from(MetadataCollection.class).where(new SQLCondition[]{MetadataQueryArgsBuilder.b((Property<String>)((Property)MetadataCollection_Table.libraryUniqueId.withTable()), queryArgs.libraryUniqueId)});
        Condition.In in = MetadataQueryArgsBuilder.a((Property)Metadata_Table.idString.withTable(), where, StringUtils.isNotBlank((String)queryArgs.libraryUniqueId));
        ConditionGroup conditionGroup = ConditionGroup.clause().and((SQLCondition)in);
        queryArgs.conditionGroup = queryArgs.conditionGroup.size() > 0 ? conditionGroup.and((SQLCondition)queryArgs.conditionGroup) : conditionGroup;
        return queryArgs;
    }
}

