/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import android.app.DownloadManager;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import com.onyx.android.sdk.utils.FileUtils;

public class DownloadUtils {
    static final String a = "download";
    private static final String b = DownloadUtils.class.getSimpleName();

    public static DownloadManager getDownloadManager(Context context) {
        String string = a;
        DownloadManager downloadManager = (DownloadManager)context.getSystemService(a);
        return downloadManager;
    }

    public static long queryReferenceByUrl(Context context, String url) {
        DownloadManager downloadManager = (DownloadManager)context.getSystemService(a);
        DownloadManager.Query query = new DownloadManager.Query();
        Cursor cursor = downloadManager.query(query);
        cursor.moveToFirst();
        long l = -1L;
        while (!cursor.isAfterLast()) {
            String string = cursor.getString(cursor.getColumnIndex("uri"));
            if (string.equalsIgnoreCase(url)) {
                int n = cursor.getInt(cursor.getColumnIndex("status"));
                if (n == 16) break;
                l = cursor.getInt(cursor.getColumnIndex("_id"));
                break;
            }
            cursor.moveToNext();
        }
        cursor.close();
        return l;
    }

    public static long download(Context context, String url, String localPath) {
        FileUtils.deleteFile((String)localPath);
        Uri uri = Uri.parse((String)url);
        DownloadManager.Request request = new DownloadManager.Request(uri);
        String string = String.format("file://%s", localPath);
        Uri uri2 = Uri.parse((String)string);
        request.setDestinationUri(uri2);
        request.setAllowedNetworkTypes(2);
        request.setVisibleInDownloadsUi(false);
        return DownloadUtils.getDownloadManager(context).enqueue(request);
    }

    public static void reportState(Context context, long reference, DownloadCallback callback) {
        DownloadManager.Query query = new DownloadManager.Query();
        query.setFilterById(new long[]{reference});
        Cursor cursor = DownloadUtils.getDownloadManager(context).query(query);
        if (cursor.moveToFirst()) {
            int n = cursor.getInt(cursor.getColumnIndex("status"));
            int n2 = cursor.getInt(cursor.getColumnIndex("reason"));
            switch (n) {
                case 4: {
                    Log.v((String)b, (String)"STATUS_PAUSED");
                    break;
                }
                case 1: {
                    Log.v((String)b, (String)"STATUS_PENDING");
                    break;
                }
                case 2: {
                    Log.v((String)b, (String)"STATUS_RUNNING");
                    break;
                }
                case 8: {
                    Log.v((String)b, (String)"Download finished");
                    break;
                }
                case 16: {
                    Log.v((String)b, (String)("STATUS_FAILED reason: " + n2));
                }
            }
            long l = cursor.getInt(cursor.getColumnIndex("total_size"));
            long l2 = cursor.getInt(cursor.getColumnIndex("bytes_so_far"));
            cursor.close();
            if (callback != null) {
                if (l > 0L) {
                    callback.stateChanged(n, l2, l, l2 * 100L / l);
                } else {
                    callback.stateChanged(n, l2, l, 0L);
                }
            }
        }
    }

    public static class DownloadCallback {
        public void stateChanged(int state, long finished, long total, long precentage) {
        }
    }
}

