/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import android.content.Context;
import android.graphics.Bitmap;
import com.onyx.android.sdk.data.GAdapter;
import com.onyx.android.sdk.data.GAdapterUtil;
import com.onyx.android.sdk.data.GObject;
import com.onyx.android.sdk.data.model.BaseData;
import com.onyx.android.sdk.data.model.Category;
import com.onyx.android.sdk.data.model.Dictionary;
import com.onyx.android.sdk.data.model.Link;
import com.onyx.android.sdk.data.model.Product;
import com.onyx.android.sdk.data.model.ProductResult;
import com.onyx.android.sdk.data.utils.CloudConf;
import com.onyx.android.sdk.dataprovider.R;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.StringUtils;
import java.io.File;
import java.util.Map;
import retrofit2.Response;

public class CloudUtils {
    public static final String cloudBaseDir() {
        return "/mnt/sdcard/cloud";
    }

    public static File baseDataDir(Context context, String id) {
        File file = new File(CloudUtils.cloudBaseDir(), id);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static File imageCacheDirectory(Context context, String id) {
        return CloudUtils.baseDataDir(context, id);
    }

    public static File dataCacheDirectory(Context context, String id) {
        return CloudUtils.baseDataDir(context, id);
    }

    public static File imageCachePath(Context context, String idString) {
        if (StringUtils.isNullOrEmpty((String)idString)) {
            return null;
        }
        return new File(CloudUtils.imageCacheDirectory(context, idString), "cover.png");
    }

    public static File dataCachePath(Context context, String idString, String title, String ext) {
        if (StringUtils.isNullOrEmpty((String)idString)) {
            return null;
        }
        String string = !ext.startsWith(".") ? title + "." + ext : title + ext;
        File file = new File(CloudUtils.dataCacheDirectory(context, idString), string);
        return file;
    }

    public static Bitmap localCoverCache(Context context, String idString) {
        File file = CloudUtils.imageCachePath(context, idString);
        Bitmap bitmap = null;
        if (file.exists()) {
            // empty if block
        }
        return bitmap;
    }

    public static Bitmap localCoverBitmap(Context context, String idString) {
        File file = CloudUtils.imageCachePath(context, idString);
        Bitmap bitmap = null;
        if (file.exists()) {
            // empty if block
        }
        return bitmap;
    }

    public static boolean updateFilePath(Context context, Product product, GObject object) {
        Map<String, Map<String, Link>> map = product.storage;
        if (CollectionUtils.isNullOrEmpty(map)) {
            return false;
        }
        for (Map.Entry<String, Map<String, Link>> entry : map.entrySet()) {
            File file = CloudUtils.dataCachePath(context, product.getIdString(), product.title, entry.getKey());
            if (file == null || !file.exists()) continue;
            object.putString("path", file.getAbsolutePath());
            return true;
        }
        return false;
    }

    public static boolean updateThumbnail(Context context, Product product, GObject object) {
        File file = CloudUtils.imageCachePath(context, product.getIdString());
        if (file != null && file.exists()) {
            Object var4_4 = null;
            if (var4_4 != null) {
                object.putObject("thumbnail", var4_4);
            }
            return true;
        }
        return false;
    }

    public static final String getCoverUrl(Product product, CloudConf cloudConf) {
        Map<String, Link> map = product.covers.get("gray");
        if (CollectionUtils.isNullOrEmpty(map)) {
            if (product.coverUrl != null) {
                String string = product.coverUrl;
                if (!string.startsWith(cloudConf.getHostBase())) {
                    string = cloudConf.getHostBase() + string;
                }
                return string;
            }
            return "";
        }
        Link link = map.get(cloudConf.getCloudStorage());
        if (link == null) {
            if (product.coverUrl != null) {
                String string = product.coverUrl;
                if (!string.startsWith(cloudConf.getHostBase())) {
                    string = cloudConf.getHostBase() + string;
                }
                return string;
            }
            return "";
        }
        return link.url;
    }

    public static GObject objectFromProduct(Context context, Product product, boolean loadThumbnail, CloudConf cloudConf) {
        if (product == null) {
            return null;
        }
        GObject gObject = new GObject();
        gObject.putString("id", product.getIdString());
        gObject.putString("title_string", product.title);
        gObject.putObject("thumbnail", (Object)R.drawable.cloud_file);
        gObject.putString("cover_url", CloudUtils.getCoverUrl(product, cloudConf));
        gObject.putObject("origin_obj", (Object)product);
        if (loadThumbnail) {
            CloudUtils.updateThumbnail(context, product, gObject);
        }
        CloudUtils.updateFilePath(context, product, gObject);
        return gObject;
    }

    public static GObject objectFromDictionary(Context context, Dictionary dictionary, boolean loadThumbnail, CloudConf cloudConf) {
        if (dictionary == null) {
            return null;
        }
        GObject gObject = new GObject();
        gObject.putString("id", dictionary.getIdString());
        gObject.putString("title_string", dictionary.title);
        gObject.putObject("thumbnail", (Object)R.drawable.cloud_file);
        gObject.putString("cover_url", CloudUtils.getCoverUrl(dictionary, cloudConf));
        gObject.putObject("origin_obj", (Object)dictionary);
        if (loadThumbnail) {
            CloudUtils.updateThumbnail(context, dictionary, gObject);
        }
        CloudUtils.updateFilePath(context, dictionary, gObject);
        return gObject;
    }

    public static GObject objectFromContainer(Category container) {
        if (container == null) {
            return null;
        }
        GObject gObject = new GObject();
        gObject.putString("id", container.getIdString());
        gObject.putString("title_string", container.name);
        gObject.putObject("thumbnail", (Object)R.drawable.cloud_file);
        gObject.putObject("origin_obj", (Object)container);
        return gObject;
    }

    public static GAdapter adapterFromContainerResult(ProductResult<Category> result) {
        GAdapter gAdapter = new GAdapter();
        if (result == null || result.list == null) {
            return gAdapter;
        }
        for (Category category : result.list) {
            gAdapter.addObject(CloudUtils.objectFromContainer(category));
        }
        return gAdapter;
    }

    public static GAdapter adapterFromProductResult(Context context, ProductResult<Product> result, int limit, CloudConf cloudConf) {
        GAdapter gAdapter = new GAdapter();
        if (result == null || result.list == null) {
            return gAdapter;
        }
        int n = 0;
        for (Product product : result.list) {
            gAdapter.addObject(CloudUtils.objectFromProduct(context, product, n++ < limit, cloudConf));
        }
        return gAdapter;
    }

    public static GAdapter adapterFromDictionaryResult(Context context, ProductResult<Dictionary> result, int limit, CloudConf cloudConf) {
        GAdapter gAdapter = new GAdapter();
        if (result == null || result.list == null) {
            return gAdapter;
        }
        int n = 0;
        for (Dictionary dictionary : result.list) {
            gAdapter.addObject(CloudUtils.objectFromDictionary(context, dictionary, n++ < limit, cloudConf));
        }
        return gAdapter;
    }

    public static Product originProduct(GObject object) {
        Object object2 = GAdapterUtil.getOriginObject((GObject)object);
        Product product = null;
        if (object2 instanceof Product) {
            product = (Product)((Object)object2);
        }
        return product;
    }

    public static <T extends BaseData> boolean isEmpty(ProductResult<T> productResult) {
        return productResult == null || productResult.list == null || productResult.list.size() <= 0;
    }

    public static void dumpResponseMessage(String tag, Response<ProductResult<Product>> response, boolean debug) {
    }
}

