/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.manager.OssManager;
import com.onyx.android.sdk.data.model.Device;
import com.onyx.android.sdk.data.model.Firmware;
import com.onyx.android.sdk.data.model.LogCollection;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.onyx.android.sdk.utils.DeviceInfoUtil;
import com.onyx.android.sdk.utils.LogUtils;
import com.onyx.android.sdk.utils.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Locale;
import retrofit2.Response;

public class LogCollectionRequest
extends BaseCloudRequest {
    private String a;
    private String b;

    public LogCollectionRequest(String desc) {
        this.b = desc;
    }

    public String getUploadFileUrl() {
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CloudManager parent) throws Exception {
        File file = LogUtils.generateFeedBackFile((Context)this.getContext());
        if (file == null || !file.exists()) {
            throw new FileNotFoundException();
        }
        try {
            OssManager ossManager = OssManager.sharedInstance(this.getContext());
            String string = ossManager.syncUploadFile(this.getContext(), ossManager.getOssLogBucketName(), file.getAbsolutePath());
            if (StringUtils.isNullOrEmpty((String)string)) {
                return;
            }
            this.a(parent, string);
        }
        catch (Exception exception) {
            this.setException(exception);
        }
        finally {
            file.delete();
        }
    }

    private void a(CloudManager cloudManager, String string) throws Exception {
        String string2 = "http://onyx-log-collection.onyx-international.cn" + File.separator + string;
        Firmware firmware = this.a();
        LogCollection logCollection = new LogCollection();
        logCollection.firmware = firmware;
        logCollection.desc = this.b;
        logCollection.zipFile = string2;
        Response response = ServiceFactory.getLogService(cloudManager.getCloudConf().getApiBase()).reportLogCollection(logCollection).execute();
        if (response.isSuccessful()) {
            this.a = string2;
        }
    }

    private Firmware a() {
        Point point = DeviceInfoUtil.getScreenResolution((Context)this.getContext());
        Firmware firmware = Firmware.currentFirmware();
        firmware.buildDisplayId = Build.DISPLAY;
        firmware.lang = Locale.getDefault().toString();
        firmware.widthPixels = point.x;
        firmware.heightPixels = point.y;
        Device device = Device.updateCurrentDeviceInfo(this.getContext());
        if (device != null) {
            firmware.deviceMAC = device.macAddress;
        }
        return firmware;
    }
}

