/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import android.content.Context;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.model.Book;
import com.onyx.android.sdk.data.model.EventTypeAggBean;
import com.onyx.android.sdk.data.model.OnyxStatisticsModel;
import com.onyx.android.sdk.data.model.StatisticsResult;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.utils.StatisticsUtils;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.onyx.android.sdk.utils.DeviceUtils;
import com.onyx.android.sdk.utils.StringUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import retrofit2.Response;

public class GetStatisticsRequest
extends BaseCloudRequest {
    public static final int RECENT_BOOK_MAX_COUNT = 5;
    private Context a;
    private StatisticsResult b;
    private String c;

    public GetStatisticsRequest(Context context, String url) {
        this.a = context;
        this.c = url;
    }

    @Override
    public void execute(CloudManager parent) throws Exception {
        this.b = new StatisticsResult();
        if (DeviceUtils.isWifiConnected((Context)this.a)) {
            this.a(parent);
        } else {
            this.a();
        }
    }

    private void a(CloudManager cloudManager) throws Exception {
        if (StringUtils.isNullOrEmpty((String)this.c)) {
            return;
        }
        String string = DeviceUtils.getMacAddress((Context)this.a);
        if (StringUtils.isNullOrEmpty((String)string)) {
            return;
        }
        try {
            Response<StatisticsResult> response = this.executeCall(ServiceFactory.getStatisticsService(this.c).getStatistics(string));
            if (response != null && response.isSuccessful()) {
                this.b = (StatisticsResult)response.body();
                this.b.setMyEventHourlyAgg(this.h());
            } else {
                this.a();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.a();
        }
    }

    private void a() {
        EventTypeAggBean eventTypeAggBean = this.b.getEventTypeAgg();
        this.b.setTotalReadTime(this.b());
        eventTypeAggBean.setRead(this.c());
        eventTypeAggBean.setFinish(this.d());
        eventTypeAggBean.setAnnotation(this.f());
        eventTypeAggBean.setTextSelect(this.g());
        this.b.setMyEventHourlyAgg(this.h());
        this.b.setDailyAvgReadTime(this.i());
        this.b.setLongestReadTimeBook(this.j());
        this.b.setMostCarefulBook(this.k());
        this.b.setRecentReadingBooks(this.getRecentBooks());
    }

    private long b() {
        List list = (List)StatisticsUtils.loadStatisticsList(this.a, 1);
        long l = 0L;
        for (OnyxStatisticsModel onyxStatisticsModel : list) {
            l += onyxStatisticsModel.getDurationTime().longValue();
        }
        return l;
    }

    private int c() {
        HashSet<String> hashSet = new HashSet<String>();
        List list = (List)StatisticsUtils.loadStatisticsList(this.a, 0);
        for (OnyxStatisticsModel onyxStatisticsModel : list) {
            hashSet.add(onyxStatisticsModel.getMd5short());
        }
        return hashSet.size();
    }

    private int d() {
        HashSet<String> hashSet = new HashSet<String>();
        List list = (List)StatisticsUtils.loadStatisticsList(this.a, 6);
        for (OnyxStatisticsModel onyxStatisticsModel : list) {
            hashSet.add(onyxStatisticsModel.getMd5short());
        }
        return hashSet.size();
    }

    private int e() {
        List list = (List)StatisticsUtils.loadStatisticsList(this.a, 3);
        return list.size();
    }

    private int f() {
        List list = (List)StatisticsUtils.loadStatisticsList(this.a, 2);
        return list.size();
    }

    private int g() {
        List list = (List)StatisticsUtils.loadStatisticsList(this.a, 4);
        return list.size();
    }

    private List<Integer> h() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        Date date = calendar.getTime();
        List list = (List)StatisticsUtils.loadStatisticsList(this.a, date);
        return StatisticsUtils.getEventHourlyAgg(list, 24);
    }

    private long i() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        Date date = calendar.getTime();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        long l = 0L;
        List list = (List)StatisticsUtils.loadStatisticsList(this.a, date, 1);
        for (OnyxStatisticsModel onyxStatisticsModel : list) {
            hashSet.add(onyxStatisticsModel.getEventTime().getDay());
            l += onyxStatisticsModel.getDurationTime().longValue();
        }
        if (hashSet.size() == 0) {
            return 0L;
        }
        return l / (long)hashSet.size();
    }

    private Book j() {
        List list = (List)StatisticsUtils.loadStatisticsList(this.a, 1);
        Book book = StatisticsUtils.getLongestBook(list);
        if (book == null) {
            return null;
        }
        String string = book.getMd5short();
        list = (List)StatisticsUtils.loadStatisticsListOrderByTime(this.a, string, 0, true);
        if (list != null && list.size() > 0) {
            book.setBegin(((OnyxStatisticsModel)list.get(0)).getEventTime());
        }
        if ((list = (List)StatisticsUtils.loadStatisticsListOrderByTime(this.a, string, true)) != null && list.size() > 0) {
            book.setEnd(((OnyxStatisticsModel)list.get(list.size() - 1)).getEventTime());
        }
        if ((list = (List)StatisticsUtils.loadStatisticsListByMd5short(this.a, string)).size() > 0) {
            book.setName(((OnyxStatisticsModel)list.get(0)).getName());
        }
        return book;
    }

    private Book k() {
        List list = (List)StatisticsUtils.loadStatisticsList(this.a, 3);
        list.addAll(StatisticsUtils.loadStatisticsList(this.a, 2));
        list.addAll(StatisticsUtils.loadStatisticsList(this.a, 4));
        Book book = StatisticsUtils.getMostCarefullyBook(list);
        if (book == null) {
            return null;
        }
        String string = book.getMd5short();
        list = (List)StatisticsUtils.loadStatisticsList(this.a, string, 3);
        book.setLookupDic(list.size());
        list = (List)StatisticsUtils.loadStatisticsList(this.a, string, 2);
        book.setAnnotation(list.size());
        list = (List)StatisticsUtils.loadStatisticsList(this.a, string, 4);
        book.setTextSelect(list.size());
        list = (List)StatisticsUtils.loadStatisticsListByMd5short(this.a, string);
        if (list.size() > 0) {
            book.setName(((OnyxStatisticsModel)list.get(0)).getName());
        }
        return book;
    }

    public List<Book> getRecentBooks() {
        List list = (List)StatisticsUtils.loadStatisticsListOrderByTime(this.a, 0, false);
        List<Book> list2 = StatisticsUtils.getRecentBooks(list, 5);
        for (Book book : list2) {
            String string = book.getMd5short();
            list = (List)StatisticsUtils.loadStatisticsListByMd5short(this.a, string);
            if (list.size() > 0) {
                book.setName(((OnyxStatisticsModel)list.get(0)).getName());
            }
            Date date = null;
            Date date2 = null;
            list = (List)StatisticsUtils.loadStatisticsListOrderByTime(this.a, string, 0, false);
            if (list != null && list.size() > 0) {
                date = ((OnyxStatisticsModel)list.get(0)).getEventTime();
                book.setBegin(date);
            }
            if ((list = (List)StatisticsUtils.loadStatisticsListOrderByTime(this.a, string, false)) != null && list.size() > 0) {
                date2 = ((OnyxStatisticsModel)list.get(0)).getEventTime();
                book.setEnd(date2);
            }
            long l = 0L;
            if (date != null) {
                list = (List)StatisticsUtils.loadStatisticsList(this.a, string, 1, date);
                for (OnyxStatisticsModel onyxStatisticsModel : list) {
                    l += onyxStatisticsModel.getDurationTime().longValue();
                }
            }
            if (l <= 0L && date != null & date2 != null) {
                l = date2.getTime() - date.getTime();
            }
            book.setReadingTime(Math.max(l, 0L));
        }
        return list2;
    }

    public StatisticsResult getStatisticsResult() {
        return this.b;
    }
}

