/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.model;

import com.onyx.android.sdk.data.model.BaseData;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.StringUtils;
import java.io.File;
import java.util.Date;
import java.util.List;

public class Metadata
extends BaseData {
    public static final String PROGRESS_DIVIDER = "/";
    String name = null;
    String title = null;
    String authors = null;
    String publisher = null;
    String language = null;
    String ISBN = null;
    String description = null;
    String location = null;
    String nativeAbsolutePath = null;
    long size = 0L;
    String encoding = null;
    Date lastAccess = null;
    Date lastModified = null;
    String progress = null;
    int favorite = 0;
    int rating = 0;
    String tags = null;
    String series = null;
    String extraAttributes = null;
    String type = null;
    String cloudId;
    String parentId;

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String t) {
        this.title = t;
    }

    public String getAuthors() {
        return this.authors;
    }

    public void setAuthors(String a2) {
        this.authors = a2;
    }

    public List<String> getAuthorList() {
        return StringUtils.split((String)this.authors, (String)",");
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String p) {
        this.publisher = p;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String l) {
        this.language = l;
    }

    public String getISBN() {
        return this.ISBN;
    }

    public void setISBN(String value) {
        this.ISBN = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String d) {
        this.description = d;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String l) {
        this.location = l;
    }

    public String getNativeAbsolutePath() {
        return this.nativeAbsolutePath;
    }

    public void setNativeAbsolutePath(String path) {
        this.nativeAbsolutePath = path;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long s) {
        this.size = s;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String e) {
        this.encoding = e;
    }

    public Date getLastAccess() {
        return this.lastAccess;
    }

    public void setLastAccess(Date lastAccess) {
        this.lastAccess = lastAccess;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public String getProgress() {
        return this.progress;
    }

    public void setProgress(String p) {
        this.progress = p;
    }

    public int getFavorite() {
        return this.favorite;
    }

    public void setFavorite(int f) {
        this.favorite = f;
    }

    public int getRating() {
        return this.rating;
    }

    public void setRating(int r) {
        this.rating = r;
    }

    public String getTags() {
        return this.tags;
    }

    public List<String> getTagList() {
        return StringUtils.split((String)this.getTags(), (String)",");
    }

    public void setTags(String t) {
        this.tags = t;
    }

    public String getSeries() {
        return this.series;
    }

    public List<String> getSerieList() {
        return StringUtils.split((String)this.getSeries(), (String)",");
    }

    public void setSeries(String s) {
        this.series = s;
    }

    public String getExtraAttributes() {
        return this.extraAttributes;
    }

    public void setExtraAttributes(String e) {
        this.extraAttributes = e;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String t) {
        this.type = t;
    }

    public String getCloudId() {
        return this.cloudId;
    }

    public void setCloudId(String c) {
        this.cloudId = c;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String id) {
        this.parentId = id;
    }

    public static Metadata createFromFile(String path) {
        return Metadata.createFromFile(new File(path));
    }

    public static Metadata createFromFile(File file) {
        return Metadata.createFromFile(file, true);
    }

    public static Metadata createFromFile(File file, boolean computeMd5) {
        try {
            Metadata metadata = new Metadata();
            if (computeMd5) {
                String string = FileUtils.computeMD5((File)file);
                metadata.setIdString(string);
            }
            Metadata.getBasicMetadataFromFile(metadata, file);
            return metadata;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void getBasicMetadataFromFile(Metadata data, File file) {
        data.setName(file.getName());
        data.setLocation(file.getAbsolutePath());
        data.setNativeAbsolutePath(file.getAbsolutePath());
        data.setSize(file.length());
        data.setLastModified(new Date(FileUtils.getLastChangeTime((File)file)));
        data.setType(FileUtils.getFileExtension((String)file.getName()));
    }

    public boolean internalProgressEqual(String progress) {
        String[] stringArray = progress.split(PROGRESS_DIVIDER);
        if (stringArray.length != 2) {
            return false;
        }
        return stringArray[0].equals(stringArray[1]);
    }

    public boolean isReaded() {
        return this.lastAccess != null && this.progress != null && this.internalProgressEqual(this.progress);
    }

    public boolean isReading() {
        return this.lastAccess != null && this.lastAccess.getTime() > 0L && this.progress != null;
    }

    public boolean isNew() {
        return (this.lastAccess == null || this.lastAccess.getTime() <= 0L) && this.progress == null;
    }
}

