/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.onyx.android.sdk.data.BookFilter;
import com.onyx.android.sdk.data.SortBy;
import com.onyx.android.sdk.data.SortOrder;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.raizlabs.android.dbflow.sql.language.ConditionGroup;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class QueryArgs {
    public int limit = Integer.MAX_VALUE;
    public int offset = 0;
    @JSONField(serialize=false, deserialize=false)
    public ConditionGroup conditionGroup = ConditionGroup.clause();
    @JSONField(serialize=false, deserialize=false)
    public List<OrderBy> orderByList = new ArrayList<OrderBy>();
    public String libraryUniqueId = null;
    public BookFilter filter = BookFilter.ALL;
    public SortBy sortBy = SortBy.Name;
    public SortOrder order = SortOrder.Desc;
    public Set<String> fileType = new HashSet<String>();
    public Set<String> author = new HashSet<String>();
    public Set<String> title = new HashSet<String>();
    public Set<String> tags = new HashSet<String>();
    public Set<String> series = new HashSet<String>();
    public String query;
    public static final String DEVICE_LIBRARY = "deviceLibrary";
    public static final String RECENT_READ = "recentRead";
    public static final String RECENT_ADDED = "recentAdded";

    public QueryArgs() {
    }

    public QueryArgs(SortBy sortBy, SortOrder order) {
        if (sortBy != null) {
            this.sortBy = sortBy;
        }
        if (order != null) {
            this.order = order;
        }
    }

    public static QueryArgs queryBy(ConditionGroup conditionGroup, OrderBy orderBy) {
        QueryArgs queryArgs = new QueryArgs();
        queryArgs.conditionGroup = conditionGroup;
        queryArgs.orderByList.add(orderBy);
        return queryArgs;
    }

    public static QueryArgs queryBy(ConditionGroup conditionGroup, List<OrderBy> orderByList) {
        QueryArgs queryArgs = new QueryArgs();
        queryArgs.conditionGroup = conditionGroup;
        queryArgs.orderByList.addAll(orderByList);
        return queryArgs;
    }

    public static QueryArgs queryBy(ConditionGroup conditionGroup, OrderBy orderBy, int offset, int limit) {
        QueryArgs queryArgs = QueryArgs.queryBy(conditionGroup, orderBy);
        queryArgs.offset = offset;
        queryArgs.limit = limit;
        return queryArgs;
    }

    public static QueryArgs queryBy(ConditionGroup conditionGroup, List<OrderBy> orderByList, int offset, int limit) {
        QueryArgs queryArgs = QueryArgs.queryBy(conditionGroup, orderByList);
        queryArgs.offset = offset;
        queryArgs.limit = limit;
        return queryArgs;
    }

    public static QueryArgs queryBy(ConditionGroup conditionGroup) {
        QueryArgs queryArgs = new QueryArgs();
        queryArgs.conditionGroup = conditionGroup;
        return queryArgs;
    }

    public QueryArgs appendOrderBy(OrderBy orderBy) {
        this.orderByList.add(orderBy);
        return this;
    }

    public QueryArgs andWith(ConditionGroup otherGroup) {
        this.conditionGroup.and((SQLCondition)otherGroup);
        return this;
    }

    public QueryArgs orWith(ConditionGroup otherGroup) {
        this.conditionGroup.or((SQLCondition)otherGroup);
        return this;
    }

    public QueryArgs appendFilter(BookFilter filter) {
        this.filter = filter;
        return this;
    }

    public static final QueryArgs fromQueryString(String string) {
        QueryArgs queryArgs = null;
        try {
            queryArgs = (QueryArgs)JSON.parseObject((String)string, QueryArgs.class);
            return queryArgs;
        }
        catch (Exception exception) {}
        finally {
            return queryArgs;
        }
    }

    public static final String toQueryString(QueryArgs args) {
        return JSON.toJSONString((Object)args);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof QueryArgs)) {
            return false;
        }
        QueryArgs queryArgs = (QueryArgs)object;
        if (!CollectionUtils.equals(queryArgs.fileType, this.fileType)) {
            return false;
        }
        if (!CollectionUtils.equals(queryArgs.title, this.title)) {
            return false;
        }
        if (!CollectionUtils.equals(queryArgs.author, this.author)) {
            return false;
        }
        if (!CollectionUtils.equals(queryArgs.tags, this.tags)) {
            return false;
        }
        return CollectionUtils.equals(queryArgs.series, this.series);
    }

    public boolean isAllSetContentEmpty() {
        if (!CollectionUtils.isNullOrEmpty(this.fileType)) {
            return false;
        }
        if (!CollectionUtils.isNullOrEmpty(this.title)) {
            return false;
        }
        if (!CollectionUtils.isNullOrEmpty(this.author)) {
            return false;
        }
        if (!CollectionUtils.isNullOrEmpty(this.tags)) {
            return false;
        }
        return CollectionUtils.isNullOrEmpty(this.series);
    }
}

