/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.FileDownloadListener;
import com.liulishuo.filedownloader.FileDownloader;
import com.liulishuo.filedownloader.notification.FileDownloadNotificationHelper;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import com.onyx.android.sdk.common.request.BaseCallback;
import com.onyx.android.sdk.data.request.cloud.CloudFileDownloadRequest;
import com.onyx.android.sdk.data.utils.DownloadListener;
import com.onyx.android.sdk.data.utils.NotificationItem;
import java.util.LinkedHashMap;

public class OnyxDownloadManager {
    private static int a = 1200;
    private static OnyxDownloadManager b;
    private FileDownloadNotificationHelper<NotificationItem> c = new FileDownloadNotificationHelper();
    private Handler d = new Handler(Looper.getMainLooper());
    private LinkedHashMap<Object, BaseDownloadTask> e = new LinkedHashMap();

    private OnyxDownloadManager(Context context) {
        FileDownloader.init((Context)context);
        FileDownloader.getImpl().setMaxNetworkThreadCount(5);
    }

    public static synchronized OnyxDownloadManager getInstance(Context context) {
        if (b == null) {
            b = new OnyxDownloadManager(context);
        }
        return b;
    }

    public static synchronized OnyxDownloadManager getInstance() {
        return OnyxDownloadManager.getInstance(OnyxDownloadManager.getContext());
    }

    public static synchronized Context getContext() {
        return FileDownloadHelper.getAppContext();
    }

    public CloudFileDownloadRequest createDownloadRequest(String url, String path, Object tag) {
        CloudFileDownloadRequest cloudFileDownloadRequest = new CloudFileDownloadRequest(url, path, tag);
        cloudFileDownloadRequest.setTaskId(FileDownloadUtils.generateId((String)url, (String)path));
        return cloudFileDownloadRequest;
    }

    public DownloadListener createDownloadListener(CloudFileDownloadRequest request, BaseCallback baseCallback) {
        return new DownloadListener(request, baseCallback, this.c);
    }

    public DownloadListener createDownloadListener(NotificationItem.NotificationBean bean, CloudFileDownloadRequest request, BaseCallback baseCallback) {
        DownloadListener downloadListener = this.createDownloadListener(request, baseCallback);
        downloadListener.setNotificationBean(bean);
        return downloadListener;
    }

    public BaseDownloadTask download(String url, String path, Object tag, BaseCallback baseCallback) {
        CloudFileDownloadRequest cloudFileDownloadRequest = this.createDownloadRequest(url, path, tag);
        return this.download(cloudFileDownloadRequest, baseCallback);
    }

    public BaseDownloadTask download(CloudFileDownloadRequest request, BaseCallback baseCallback) {
        request.setTaskId(FileDownloadUtils.generateId((String)request.getUrl(), (String)request.getPath()));
        BaseDownloadTask baseDownloadTask = FileDownloader.getImpl().create(request.getUrl()).setPath(request.getPath()).setTag(request.getTag());
        baseDownloadTask.setListener((FileDownloadListener)this.createDownloadListener(request, baseCallback));
        return baseDownloadTask;
    }

    public BaseDownloadTask downloadWithNotify(String url, String path, Object tag, NotificationItem.NotificationBean bean, BaseCallback callback) {
        CloudFileDownloadRequest cloudFileDownloadRequest = this.createDownloadRequest(url, path, tag);
        DownloadListener downloadListener = this.createDownloadListener(bean, cloudFileDownloadRequest, callback);
        BaseDownloadTask baseDownloadTask = FileDownloader.getImpl().create(cloudFileDownloadRequest.getUrl()).setPath(cloudFileDownloadRequest.getPath()).setTag(cloudFileDownloadRequest.getTag());
        baseDownloadTask.setListener((FileDownloadListener)downloadListener);
        return baseDownloadTask;
    }

    public BaseDownloadTask downloadWithNotify(CloudFileDownloadRequest request, NotificationItem.NotificationBean bean, BaseCallback callback) {
        BaseDownloadTask baseDownloadTask = FileDownloader.getImpl().create(request.getUrl()).setPath(request.getPath()).setTag(request.getTag());
        request.setTaskId(FileDownloadUtils.generateId((String)request.getUrl(), (String)request.getPath()));
        DownloadListener downloadListener = this.createDownloadListener(bean, request, callback);
        baseDownloadTask.setListener((FileDownloadListener)downloadListener);
        return baseDownloadTask;
    }

    public int downloadDirectly(String url, String path, Object tag, BaseCallback baseCallback) {
        return this.startDownload(this.download(url, path, tag, baseCallback));
    }

    public int downloadDirectly(CloudFileDownloadRequest request, BaseCallback baseCallback) {
        return this.startDownload(this.download(request, baseCallback));
    }

    public int startDownload(BaseDownloadTask task) {
        task.setCallbackProgressMinInterval(a);
        return task.start();
    }

    public int startDownload(BaseDownloadTask task, int progressMinInterval) {
        task.setCallbackProgressMinInterval(progressMinInterval);
        return task.start();
    }

    public void removeTask(Object key) {
        this.e.remove(key);
    }

    public void addTask(Object key, BaseDownloadTask task) {
        this.e.put(key, task);
    }

    public BaseDownloadTask getTask(Object key) {
        return this.e.get(key);
    }

    public void clearTaskQueue() {
        this.e.clear();
    }

    public int getTaskProgress(int taskId) {
        return (int)((float)FileDownloader.getImpl().getSoFar(taskId) * 1.0f / (float)FileDownloader.getImpl().getTotal(taskId) * 100.0f);
    }

    public int getTaskStatus(int taskId, String path) {
        return FileDownloader.getImpl().getStatus(taskId, path);
    }
}

