/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import android.content.Context;
import android.graphics.Bitmap;
import com.onyx.android.sdk.data.compatability.OnyxThumbnail;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.MetadataCollection;
import com.onyx.android.sdk.data.model.Metadata_Table;
import com.onyx.android.sdk.data.model.Thumbnail;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.provider.DataProviderManager;
import com.onyx.android.sdk.data.utils.ThumbnailUtils;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DataManagerHelper {
    private static DataProviderBase a() {
        return DataProviderManager.getDataProvider();
    }

    public static void addCollections(Context context, Library library, List<Metadata> addList) {
        DataProviderBase dataProviderBase = DataManagerHelper.a();
        for (Metadata metadata : addList) {
            dataProviderBase.deleteMetadataCollection(context, library.getParentUniqueId(), metadata.getIdString());
            MetadataCollection metadataCollection = new MetadataCollection();
            metadataCollection.setLibraryUniqueId(library.getIdString());
            metadataCollection.setDocumentUniqueId(metadata.getIdString());
            dataProviderBase.addMetadataCollection(context, metadataCollection);
        }
    }

    public static void updateCollections(Context context, String newLibraryUniqueId, String oldLibraryUniqueId) {
        if (newLibraryUniqueId == null) {
            DataManagerHelper.a().deleteMetadataCollection(context, oldLibraryUniqueId, null);
        } else {
            List<MetadataCollection> list = DataManagerHelper.a().loadMetadataCollection(context, oldLibraryUniqueId);
            for (MetadataCollection metadataCollection : list) {
                metadataCollection.setLibraryUniqueId(newLibraryUniqueId);
                DataManagerHelper.a().updateMetadataCollection(metadataCollection);
            }
        }
    }

    public static void removeCollections(Context context, Library library, List<Metadata> removeList) {
        for (Metadata metadata : removeList) {
            DataManagerHelper.a().deleteMetadataCollection(context, library.getIdString(), metadata.getIdString());
            if (library.getParentUniqueId() == null) continue;
            MetadataCollection metadataCollection = new MetadataCollection();
            metadataCollection.setLibraryUniqueId(library.getParentUniqueId());
            metadataCollection.setDocumentUniqueId(metadata.getIdString());
            DataManagerHelper.a().addMetadataCollection(context, metadataCollection);
        }
    }

    public static List<Library> loadAllLibrary(List<Library> list, String parentId) {
        List<Library> list2 = DataManagerHelper.a().loadAllLibrary(parentId);
        if (list2.size() > 0) {
            list.addAll(list2);
        }
        return list2;
    }

    public static void deepLoadAllLibrary(List<Library> list, String targetId) {
        List<Library> list2 = DataManagerHelper.loadAllLibrary(list, targetId);
        for (Library library : list2) {
            DataManagerHelper.deepLoadAllLibrary(list, library.getIdString());
        }
    }

    public static Thumbnail loadThumbnail(Context context, String path, String md5, OnyxThumbnail.ThumbnailKind kind) {
        if (StringUtils.isNullOrEmpty((String)md5)) {
            try {
                md5 = FileUtils.computeMD5((File)new File(path));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return DataManagerHelper.a().loadThumbnail(context, md5, kind);
    }

    public static Bitmap loadThumbnailBitmap(Context context, Thumbnail thumbnail) {
        return DataManagerHelper.a().loadThumbnailBitmap(context, thumbnail);
    }

    public static List<Bitmap> loadThumbnailBitmapList(Context context, List<File> fileList, int limit, OnyxThumbnail.ThumbnailKind kind) {
        ArrayList<Bitmap> arrayList = new ArrayList<Bitmap>();
        Bitmap bitmap = null;
        int n = 0;
        for (File file : fileList) {
            if (file.isDirectory()) continue;
            Thumbnail thumbnail = DataManagerHelper.loadThumbnail(context, file.getAbsolutePath(), null, kind);
            if (n++ < Math.min(limit, fileList.size())) {
                bitmap = DataManagerHelper.loadThumbnailBitmap(context, thumbnail);
            }
            arrayList.add(bitmap == null ? ThumbnailUtils.loadDefaultThumbnailFromExtension(context, FileUtils.getFileExtension((File)file)) : bitmap);
        }
        return arrayList;
    }

    public static Metadata getMetadataByCloudReference(Context context, String cloudReference) {
        return (Metadata)new Select(new IProperty[0]).from(Metadata.class).where(new SQLCondition[]{Metadata_Table.cloudId.eq((Object)cloudReference)}).querySingle();
    }

    public static Metadata getMetadataByMD5(Context context, String md5) {
        return (Metadata)new Select(new IProperty[0]).from(Metadata.class).where(new SQLCondition[]{Metadata_Table.idString.eq((Object)md5)}).querySingle();
    }
}

