/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import android.content.Context;
import android.util.Log;
import com.onyx.android.sdk.common.request.BaseCallback;
import com.onyx.android.sdk.common.request.BaseRequest;
import com.onyx.android.sdk.common.request.RequestManager;
import com.onyx.android.sdk.data.BookFilter;
import com.onyx.android.sdk.data.DataCacheManager;
import com.onyx.android.sdk.data.DataManagerHelper;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.SortBy;
import com.onyx.android.sdk.data.SortOrder;
import com.onyx.android.sdk.data.cache.LibraryCache;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.provider.DataProviderManager;
import com.onyx.android.sdk.data.request.data.BaseDataRequest;
import com.onyx.android.sdk.data.utils.MetadataQueryArgsBuilder;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.raizlabs.android.dbflow.config.DatabaseHolder;
import com.raizlabs.android.dbflow.config.FlowConfig;
import com.raizlabs.android.dbflow.config.FlowManager;
import java.util.ArrayList;
import java.util.List;

public class DataManager {
    private static final String a = DataManager.class.getSimpleName();
    private RequestManager b;
    private DataProviderManager c = new DataProviderManager();
    private DataCacheManager d;

    public DataManager() {
        this.b = new RequestManager();
        this.d = new DataCacheManager(this.getDataProviderBase());
    }

    public static void init(Context context, List<Class<? extends DatabaseHolder>> list) {
        FlowConfig.Builder builder = new FlowConfig.Builder(context);
        if (list != null) {
            for (Class<? extends DatabaseHolder> clazz : list) {
                builder.addDatabaseHolder(clazz);
            }
        }
        FlowManager.init((FlowConfig)builder.build());
    }

    public static void cleanUp() {
    }

    private final Runnable a(final BaseDataRequest baseDataRequest) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    baseDataRequest.execute(DataManager.this);
                }
                catch (Exception exception) {
                    Log.e((String)a, (String)Log.getStackTraceString((Throwable)exception));
                    baseDataRequest.setException(exception);
                }
                finally {
                    baseDataRequest.afterExecute(DataManager.this);
                    DataManager.this.b.dumpWakelocks();
                    DataManager.this.b.removeRequest((BaseRequest)baseDataRequest);
                }
            }
        };
        return runnable;
    }

    public void submit(Context context, BaseDataRequest request, BaseCallback callback) {
        this.b.submitRequest(context, (BaseRequest)request, this.a(request), callback);
    }

    public final RequestManager getRequestManager() {
        return this.b;
    }

    public final DataProviderManager getDataProviderManager() {
        return this.c;
    }

    public DataProviderBase getDataProviderBase() {
        this.getDataProviderManager();
        return DataProviderManager.getDataProvider();
    }

    public final DataCacheManager getDataCacheManager() {
        return this.d;
    }

    public void cacheUpdateMetaList(String oldUniqueId, String newUniqueId, List<Metadata> metadataList) {
        this.d.removeAll(oldUniqueId, metadataList);
        this.d.addAll(newUniqueId, metadataList);
    }

    public List<Metadata> getLibraryMetadataListOfAll(Context context, QueryArgs args) {
        List<Metadata> list = new ArrayList<Metadata>();
        LibraryCache libraryCache = this.d.getLibraryCache(args.libraryUniqueId);
        if (CollectionUtils.isNullOrEmpty(libraryCache.getIdList())) {
            QueryArgs queryArgs = MetadataQueryArgsBuilder.libraryAllBookQuery(args.libraryUniqueId, args.sortBy, args.order);
            list = libraryCache.getList(context, queryArgs);
            this.d.addAll(args.libraryUniqueId, list);
            return list;
        }
        for (String string : libraryCache.getIdList()) {
            Metadata metadata = this.d.getById(string);
            if (metadata == null) continue;
            list.add(metadata);
        }
        return list;
    }

    public List<Metadata> getLibraryMetadataListWithParentId(Context context, String parentId) {
        ArrayList<Metadata> arrayList = new ArrayList<Metadata>();
        QueryArgs queryArgs = MetadataQueryArgsBuilder.libraryAllBookQuery(parentId, SortBy.Name, SortOrder.Asc);
        arrayList.addAll(this.getLibraryMetadataList(context, queryArgs));
        return arrayList;
    }

    public List<Metadata> getLibraryMetadataList(Context context, QueryArgs queryArgs) {
        List<Metadata> list = this.getLibraryMetadataListOfAll(context, queryArgs);
        return this.d.getMetadataList(list, queryArgs);
    }

    public List<Metadata> getMetadataList(Context context, QueryArgs queryArgs) {
        if (this.d.isLibraryCacheReady()) {
            List<Metadata> list = this.d.getAllMetadataList();
            return this.d.getMetadataList(list, queryArgs);
        }
        ArrayList<Metadata> arrayList = new ArrayList();
        LibraryCache libraryCache = this.d.getLibraryCache(queryArgs.libraryUniqueId);
        if (CollectionUtils.isNullOrEmpty(libraryCache.getIdList())) {
            arrayList = libraryCache.getList(context, queryArgs);
            this.d.addAll(queryArgs.libraryUniqueId, arrayList);
            return arrayList;
        }
        for (String string : libraryCache.getIdList()) {
            Metadata metadata = this.d.getById(string);
            if (metadata == null) continue;
            arrayList.add(metadata);
        }
        if (!CollectionUtils.isNullOrEmpty(arrayList) && queryArgs.filter == BookFilter.ALL && queryArgs.limit == Integer.MAX_VALUE && queryArgs.offset == 0) {
            this.d.setLibraryCacheReady(true);
        }
        return arrayList;
    }

    public void addToLibrary(Context context, Library library, List<Metadata> addList) {
        DataManagerHelper.addCollections(context, library, addList);
        LibraryCache libraryCache = this.d.getLibraryCache(library.getIdString());
        if (CollectionUtils.isNullOrEmpty(libraryCache.getIdList())) {
            this.d.removeAll(library.getParentUniqueId(), addList);
            return;
        }
        this.cacheUpdateMetaList(library.getParentUniqueId(), library.getIdString(), addList);
    }

    public List<Metadata> buildLibrary(Context context, Library library, QueryArgs args) {
        List<Metadata> list = new ArrayList<Metadata>();
        boolean bl = true;
        DataProviderBase dataProviderBase = this.getDataProviderBase();
        if (args != null && !args.isAllSetContentEmpty()) {
            library.setQueryString(QueryArgs.toQueryString(args));
            bl = false;
        }
        if (!bl) {
            args.libraryUniqueId = library.getParentUniqueId();
            list = this.getLibraryMetadataList(context, args);
            DataManagerHelper.addCollections(context, library, list);
        }
        dataProviderBase.addLibrary(library);
        return list;
    }

    public void clearLibrary(Context context, Library library) {
        List<Metadata> list = this.getLibraryMetadataListOfAll(context, MetadataQueryArgsBuilder.libraryAllBookQuery(library.getIdString(), SortBy.Name, SortOrder.Desc));
        if (list.size() <= 0) {
            return;
        }
        this.d.addAll(library.getParentUniqueId(), list);
        DataManagerHelper.updateCollections(context, library.getParentUniqueId(), library.getIdString());
    }

    public void deleteLibrary(Context context, Library library) {
        DataProviderBase dataProviderBase = this.getDataProviderBase();
        ArrayList<Library> arrayList = new ArrayList<Library>();
        DataManagerHelper.deepLoadAllLibrary(arrayList, library.getIdString());
        arrayList.add(0, library);
        for (Library library2 : arrayList) {
            dataProviderBase.deleteLibrary(library2);
            List<Metadata> list = this.d.getMetadataList(library2.getIdString());
            if (CollectionUtils.isNullOrEmpty(list)) {
                list = this.getLibraryMetadataListWithParentId(context, library.getIdString());
            } else {
                this.d.removeAll(library2.getIdString(), list);
            }
            if (list.size() <= 0) continue;
            this.d.addAll(library.getParentUniqueId(), list);
            DataManagerHelper.updateCollections(context, library.getParentUniqueId(), library2.getIdString());
        }
    }

    public void saveLibrary(Library library) {
        this.getDataProviderBase().addLibrary(library);
    }

    public void modifyLibrary(Context context, Library library, boolean modifyCriteria) {
        this.saveLibrary(library);
        if (modifyCriteria) {
            DataProviderBase dataProviderBase = this.getDataProviderBase();
            List<Metadata> list = this.d.getMetadataList(library.getIdString());
            if (CollectionUtils.isNullOrEmpty(list)) {
                list.addAll(this.getLibraryMetadataListWithParentId(context, library.getIdString()));
            }
            if (!CollectionUtils.isNullOrEmpty(list)) {
                this.d.removeAll(library.getIdString(), list);
                this.d.addAll(library.getParentUniqueId(), list);
                DataManagerHelper.removeCollections(context, library, list);
            }
            QueryArgs queryArgs = QueryArgs.fromQueryString(library.getQueryString());
            queryArgs.libraryUniqueId = library.getParentUniqueId();
            MetadataQueryArgsBuilder.generateQueryArgs(queryArgs);
            MetadataQueryArgsBuilder.generateMetadataInQueryArgs(queryArgs);
            list = dataProviderBase.findMetadata(context, queryArgs);
            if (!CollectionUtils.isNullOrEmpty(list)) {
                this.d.addAll(library.getIdString(), list);
                this.d.removeAll(library.getParentUniqueId(), list);
                DataManagerHelper.addCollections(context, library, list);
            }
        }
    }

    public void removeFromLibrary(Context context, Library library, List<Metadata> removeList) {
        DataManagerHelper.removeCollections(context, library, removeList);
        this.cacheUpdateMetaList(library.getIdString(), library.getParentUniqueId(), removeList);
    }
}

