/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import com.onyx.android.sdk.data.MetadataCache;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.cache.LibraryCache;
import com.onyx.android.sdk.data.cache.LibraryCacheManager;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.utils.MetaDataUtils;
import com.onyx.android.sdk.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;

public class DataCacheManager {
    private MetadataCache a = new MetadataCache();
    private LibraryCacheManager b;
    private boolean c = false;

    public DataCacheManager(DataProviderBase dataProvider) {
        this.b = new LibraryCacheManager(dataProvider);
    }

    public LibraryCache getLibraryCache(String libraryUniqueId) {
        return this.b.getLibraryCache(libraryUniqueId);
    }

    public void add(String parentLibraryId, Metadata metadata) {
        if (metadata == null) {
            return;
        }
        this.a.add(metadata.getIdString(), metadata);
        this.addToLibrary(parentLibraryId, metadata);
    }

    public void addToLibrary(String parentLibraryId, Metadata metadata) {
        LibraryCache libraryCache = this.getLibraryCache(parentLibraryId);
        if (libraryCache != null) {
            libraryCache.addId(metadata.getIdString());
        }
    }

    public void addAll(String parentId, List<Metadata> list) {
        if (CollectionUtils.isNullOrEmpty(list)) {
            return;
        }
        for (Metadata metadata : list) {
            this.add(parentId, metadata);
        }
    }

    private void a(Metadata metadata) {
        this.a.remove(metadata);
    }

    public boolean remove(String parentId, String md5) {
        Metadata metadata = this.a.getById(md5);
        if (metadata != null) {
            this.a(metadata);
            this.getLibraryCache(parentId).removeId(md5);
            return true;
        }
        return false;
    }

    public boolean removeAll(String parentId, List<Metadata> list) {
        for (Metadata metadata : list) {
            this.remove(parentId, metadata.getIdString());
        }
        return true;
    }

    public void clear() {
        this.a.clear();
        this.b.clear();
        this.setLibraryCacheReady(false);
    }

    public void setLibraryCacheReady(boolean ready) {
        this.c = ready;
    }

    public boolean isLibraryCacheReady() {
        return this.c && !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.a.isEmpty();
    }

    public Metadata getById(String md5) {
        return this.a.getById(md5);
    }

    public boolean containsId(String md5) {
        return this.a.containsId(md5);
    }

    public List<Metadata> getAllMetadataList() {
        return this.a.list();
    }

    public List<Metadata> getMetadataList(String parentId) {
        LibraryCache libraryCache = this.getLibraryCache(parentId);
        ArrayList<Metadata> arrayList = new ArrayList<Metadata>();
        for (String string : libraryCache.getIdList()) {
            arrayList.add(this.a.getById(string));
        }
        return arrayList;
    }

    public List<Metadata> getMetadataList(List<Metadata> originList, QueryArgs args) {
        List<Metadata> list;
        switch (args.filter) {
            case ALL: {
                list = this.getAll(originList, args);
                break;
            }
            case READED: {
                list = this.getRead(originList, args);
                break;
            }
            case READING: {
                list = this.getReading(originList, args);
                break;
            }
            case NEW_BOOKS: {
                list = this.getNewBookList(originList, args);
                break;
            }
            case TAG: {
                list = this.getByTag(originList, args);
                break;
            }
            case SEARCH: {
                list = this.getBySearch(originList, args);
                break;
            }
            default: {
                list = this.getAll(originList, args);
            }
        }
        if (args.isAllSetContentEmpty()) {
            return this.a(list, args);
        }
        ArrayList<Metadata> arrayList = new ArrayList<Metadata>();
        for (Metadata metadata : list) {
            if (!MetaDataUtils.criteriaContains(metadata, args)) continue;
            arrayList.add(metadata);
        }
        return this.a(arrayList, args);
    }

    public boolean containType(Metadata metadata, QueryArgs args) {
        return args.fileType == null || args.fileType.size() <= 0 || args.fileType.contains(metadata.getType());
    }

    private void a(List<Metadata> list, Metadata metadata, boolean bl) {
        if (!bl) {
            return;
        }
        list.add(metadata);
    }

    private List<Metadata> a(List<Metadata> list, QueryArgs queryArgs) {
        if (list.size() <= 0) {
            return list;
        }
        if (queryArgs.offset >= list.size() || queryArgs.limit == 0) {
            return new ArrayList<Metadata>();
        }
        MetaDataUtils.sort(list, queryArgs.sortBy, queryArgs.order);
        if (queryArgs.offset == 0 && queryArgs.limit >= list.size()) {
            return list;
        }
        ArrayList<Metadata> arrayList = new ArrayList<Metadata>();
        for (int i = 0; i < Math.min(queryArgs.limit, list.size() - queryArgs.offset); ++i) {
            arrayList.add(list.get(i + queryArgs.offset));
        }
        return arrayList;
    }

    public List<Metadata> getAll(List<Metadata> originList, QueryArgs args) {
        ArrayList<Metadata> arrayList = new ArrayList<Metadata>();
        for (Metadata metadata : originList) {
            this.a(arrayList, metadata, this.containType(metadata, args));
        }
        return arrayList;
    }

    public List<Metadata> getRead(List<Metadata> originList, QueryArgs args) {
        ArrayList<Metadata> arrayList = new ArrayList<Metadata>();
        for (Metadata metadata : originList) {
            if (!this.containType(metadata, args)) continue;
            this.a(arrayList, metadata, metadata.isReaded());
        }
        return arrayList;
    }

    public List<Metadata> getReading(List<Metadata> originList, QueryArgs args) {
        ArrayList<Metadata> arrayList = new ArrayList<Metadata>();
        for (Metadata metadata : originList) {
            if (!this.containType(metadata, args)) continue;
            this.a(arrayList, metadata, metadata.isReading());
        }
        return arrayList;
    }

    public List<Metadata> getNewBookList(List<Metadata> originList, QueryArgs args) {
        ArrayList<Metadata> arrayList = new ArrayList<Metadata>();
        for (Metadata metadata : originList) {
            if (!this.containType(metadata, args)) continue;
            this.a(arrayList, metadata, metadata.isNew());
        }
        return arrayList;
    }

    public List<Metadata> getByTag(List<Metadata> originList, QueryArgs args) {
        ArrayList<Metadata> arrayList = new ArrayList<Metadata>();
        for (Metadata metadata : originList) {
            if (!this.containType(metadata, args)) continue;
            this.a(arrayList, metadata, MetaDataUtils.safelyContains(args.tags, metadata.getTags()));
        }
        return arrayList;
    }

    public List<Metadata> getBySearch(List<Metadata> originList, QueryArgs args) {
        ArrayList<Metadata> arrayList = new ArrayList<Metadata>();
        for (Metadata metadata : originList) {
            if (!this.containType(metadata, args)) continue;
            this.a(arrayList, metadata, MetaDataUtils.safelyContains(metadata, args.query));
        }
        return arrayList;
    }
}

