/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk.model;

import android.location.Location;
import android.support.annotation.NonNull;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RadarUserInsightsLocation {
    private RadarUserInsightsLocationType mType;
    private Location mLocation;
    private RadarUserInsightsLocationConfidence mConfidence;
    private Date mUpdatedAt;

    public RadarUserInsightsLocation(RadarUserInsightsLocationType type, Location location, RadarUserInsightsLocationConfidence confidence, Date updatedAt) {
        this.mType = type;
        this.mLocation = location;
        this.mConfidence = confidence;
        this.mUpdatedAt = updatedAt;
    }

    public RadarUserInsightsLocation(JSONObject obj) throws JSONException, ParseException {
        JSONObject locationObj;
        if (obj == null) {
            return;
        }
        if (obj.has("type") && !obj.isNull("type")) {
            String typeStr = obj.getString("type");
            this.mType = typeStr.equals("home") ? RadarUserInsightsLocationType.HOME : (typeStr.equals("office") ? RadarUserInsightsLocationType.OFFICE : RadarUserInsightsLocationType.UNKNOWN);
        }
        if (obj.has("location") && !obj.isNull("location") && (locationObj = obj.getJSONObject("location")).has("coordinates")) {
            JSONArray coordinatesArr = locationObj.getJSONArray("coordinates");
            double longitude = coordinatesArr.getDouble(0);
            double latitude = coordinatesArr.getDouble(1);
            Location location = new Location("");
            location.setLongitude(longitude);
            location.setLatitude(latitude);
            this.mLocation = location;
        }
        if (obj.has("confidence") && !obj.isNull("confidence")) {
            int confidenceInt = obj.getInt("confidence");
            this.mConfidence = confidenceInt == 3 ? RadarUserInsightsLocationConfidence.HIGH : (confidenceInt == 2 ? RadarUserInsightsLocationConfidence.MEDIUM : (confidenceInt == 1 ? RadarUserInsightsLocationConfidence.LOW : RadarUserInsightsLocationConfidence.NONE));
        }
        if (obj.has("updatedAt") && !obj.isNull("updatedAt")) {
            String updatedAtStr = obj.getString("updatedAt");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.mUpdatedAt = dateFormat.parse(updatedAtStr);
        }
    }

    @NonNull
    public RadarUserInsightsLocationType getType() {
        return this.mType;
    }

    @NonNull
    public Location getLocation() {
        return this.mLocation;
    }

    @NonNull
    public RadarUserInsightsLocationConfidence getConfidence() {
        return this.mConfidence;
    }

    @NonNull
    public Date getUpdatedAt() {
        return this.mUpdatedAt;
    }

    public static enum RadarUserInsightsLocationConfidence {
        NONE,
        LOW,
        MEDIUM,
        HIGH;

    }

    public static enum RadarUserInsightsLocationType {
        UNKNOWN,
        HOME,
        OFFICE;

    }
}

