/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.onradar.sdk.model.RadarGeofence;
import com.onradar.sdk.model.RadarPlace;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RadarEvent {
    private String mId;
    private Date mCreatedAt;
    private boolean mLive;
    private RadarEventType mType;
    private RadarGeofence mGeofence;
    private RadarPlace mPlace;
    private RadarPlace[] mAlternatePlaces;
    private RadarPlace mVerifiedPlace;
    private RadarEventVerification mVerification;
    private RadarEventConfidence mConfidence;
    private float mDuration;

    public static RadarEvent[] eventsFromJSONArray(JSONArray array) throws JSONException, ParseException {
        int numEvents = array.length();
        RadarEvent[] events = new RadarEvent[numEvents];
        for (int i = 0; i < numEvents; ++i) {
            RadarEvent event;
            JSONObject eventObj = array.getJSONObject(i);
            events[i] = event = new RadarEvent(eventObj);
        }
        return events;
    }

    public RadarEvent(String _id, Date createdAt, boolean live, RadarEventType type, RadarGeofence geofence, RadarPlace place, RadarPlace[] alternatePlaces, RadarPlace verifiedPlace, RadarEventVerification verification, RadarEventConfidence confidence, float duration) {
        this.mId = _id;
        this.mCreatedAt = createdAt;
        this.mLive = live;
        this.mType = type;
        this.mGeofence = geofence;
        this.mPlace = place;
        this.mAlternatePlaces = alternatePlaces;
        this.mVerifiedPlace = verifiedPlace;
        this.mVerification = verification;
        this.mConfidence = confidence;
        this.mDuration = duration;
    }

    public RadarEvent(JSONObject obj) throws JSONException, ParseException {
        if (obj == null) {
            return;
        }
        if (obj.has("_id") && !obj.isNull("_id")) {
            this.mId = obj.getString("_id");
        }
        if (obj.has("createdAt") && !obj.isNull("createdAt")) {
            String createdAtStr = obj.getString("createdAt");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.mCreatedAt = dateFormat.parse(createdAtStr);
        }
        if (obj.has("live") && !obj.isNull("live")) {
            this.mLive = obj.getBoolean("live");
        }
        if (obj.has("type") && !obj.isNull("type")) {
            String typeStr = obj.getString("type");
            this.mType = typeStr.equals("user.entered_geofence") ? RadarEventType.USER_ENTERED_GEOFENCE : (typeStr.equals("user.exited_geofence") ? RadarEventType.USER_EXITED_GEOFENCE : (typeStr.equals("user.entered_home") ? RadarEventType.USER_ENTERED_HOME : (typeStr.equals("user.exited_home") ? RadarEventType.USER_EXITED_HOME : (typeStr.equals("user.entered_office") ? RadarEventType.USER_ENTERED_OFFICE : (typeStr.equals("user.exited_office") ? RadarEventType.USER_EXITED_OFFICE : (typeStr.equals("user.started_traveling") ? RadarEventType.USER_STARTED_TRAVELING : (typeStr.equals("user.stopped_traveling") ? RadarEventType.USER_STOPPED_TRAVELING : (typeStr.equals("user.entered_place") ? RadarEventType.USER_ENTERED_PLACE : (typeStr.equals("user.exited_place") ? RadarEventType.USER_EXITED_PLACE : RadarEventType.UNKNOWN)))))))));
        }
        if (obj.has("geofence") && !obj.isNull("geofence")) {
            JSONObject geofenceObj = obj.getJSONObject("geofence");
            this.mGeofence = new RadarGeofence(geofenceObj);
        }
        if (obj.has("place") && !obj.isNull("place")) {
            JSONObject placeObj = obj.getJSONObject("place");
            this.mPlace = new RadarPlace(placeObj);
        }
        if (obj.has("alternatePlaces") && !obj.isNull("alternatePlaces")) {
            JSONArray alternatePlacesArr = obj.getJSONArray("alternatePlaces");
            int numAlternatePlaces = alternatePlacesArr.length();
            this.mAlternatePlaces = new RadarPlace[numAlternatePlaces];
            for (int i = 0; i < numAlternatePlaces; ++i) {
                RadarPlace alternatePlace;
                JSONObject alternatePlaceObj = alternatePlacesArr.getJSONObject(i);
                this.mAlternatePlaces[i] = alternatePlace = new RadarPlace(alternatePlaceObj);
            }
        }
        if (obj.has("verifiedPlace") && !obj.isNull("verifiedPlace")) {
            JSONObject verifiedPlaceObj = obj.getJSONObject("verifiedPlace");
            this.mVerifiedPlace = new RadarPlace(verifiedPlaceObj);
        }
        if (obj.has("verification") && !obj.isNull("verification")) {
            int verificationInt = obj.getInt("verification");
            this.mVerification = verificationInt == 1 ? RadarEventVerification.ACCEPT : (verificationInt == -1 ? RadarEventVerification.REJECT : RadarEventVerification.UNVERIFY);
        }
        if (obj.has("confidence") && !obj.isNull("confidence")) {
            int confidenceInt = obj.getInt("confidence");
            this.mConfidence = confidenceInt == 3 ? RadarEventConfidence.HIGH : (confidenceInt == 2 ? RadarEventConfidence.MEDIUM : (confidenceInt == 1 ? RadarEventConfidence.LOW : RadarEventConfidence.NONE));
        }
        if (obj.has("duration") && !obj.isNull("duration")) {
            this.mDuration = (float)obj.getDouble("duration");
        }
    }

    @NonNull
    public String getId() {
        return this.mId;
    }

    @NonNull
    public Date getCreatedAt() {
        return this.mCreatedAt;
    }

    public boolean getLive() {
        return this.mLive;
    }

    @NonNull
    public RadarEventType getType() {
        return this.mType;
    }

    @Nullable
    public RadarGeofence getGeofence() {
        return this.mGeofence;
    }

    @Nullable
    public RadarPlace getPlace() {
        return this.mPlace;
    }

    @Nullable
    public RadarPlace[] getAlternatePlaces() {
        return this.mAlternatePlaces;
    }

    @Nullable
    public RadarPlace getVerifiedPlace() {
        return this.mVerifiedPlace;
    }

    @NonNull
    public RadarEventConfidence getConfidence() {
        return this.mConfidence;
    }

    public float getDuration() {
        return this.mDuration;
    }

    public static enum RadarEventVerification {
        ACCEPT,
        UNVERIFY,
        REJECT;

    }

    public static enum RadarEventConfidence {
        NONE,
        LOW,
        MEDIUM,
        HIGH;

    }

    public static enum RadarEventType {
        UNKNOWN,
        USER_ENTERED_GEOFENCE,
        USER_EXITED_GEOFENCE,
        USER_ENTERED_HOME,
        USER_EXITED_HOME,
        USER_ENTERED_OFFICE,
        USER_EXITED_OFFICE,
        USER_STARTED_TRAVELING,
        USER_STOPPED_TRAVELING,
        USER_ENTERED_PLACE,
        USER_EXITED_PLACE;

    }
}

