/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk;

import android.content.ContentResolver;
import android.content.Context;
import android.location.Location;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import com.onradar.sdk._RadarLogger;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

class _RadarUtils {
    _RadarUtils() {
    }

    static String getWifi(Context context) {
        try {
            JSONObject disabled = new JSONObject();
            disabled.put("enabled", false);
            if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_WIFI_STATE") != 0) {
                _RadarLogger.log(context, "ACCESS_WIFI_STATE permission not granted");
                return disabled.toString();
            }
            if (!context.getPackageManager().hasSystemFeature("android.hardware.wifi")) {
                return disabled.toString();
            }
            WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            if (wifiInfo == null || TextUtils.isEmpty((CharSequence)wifiInfo.getBSSID()) || wifiInfo.getSupplicantState() != SupplicantState.COMPLETED) {
                return disabled.toString();
            }
            JSONObject wifi = new JSONObject();
            wifi.put("bssid", (Object)wifiInfo.getBSSID());
            wifi.put("ssid", (Object)wifiInfo.getSSID());
            wifi.put("rssi", wifiInfo.getRssi());
            if (Build.VERSION.SDK_INT >= 21) {
                wifi.put("frequency", wifiInfo.getFrequency());
            }
            JSONObject enabled = new JSONObject();
            enabled.put("enabled", true);
            enabled.put("current_connection", (Object)wifi);
            return enabled.toString();
        }
        catch (JSONException e) {
            return null;
        }
    }

    static Location locationByMoving(double distanceMeters, double bearingDegrees, Location location) {
        double distanceRadians = distanceMeters / 6372797.6;
        double bearingRadians = bearingDegrees * Math.PI / 180.0;
        double lat1 = location.getLatitude() * Math.PI / 180.0;
        double lon1 = location.getLongitude() * Math.PI / 180.0;
        double lat2 = Math.asin(Math.sin(lat1) * Math.cos(distanceRadians) + Math.cos(lat1) * Math.sin(distanceRadians) * Math.cos(bearingRadians));
        double lon2 = lon1 + Math.atan2(Math.sin(bearingRadians) * Math.sin(distanceRadians) * Math.cos(lat1), Math.cos(distanceRadians) - Math.sin(lat1) * Math.sin(lat2));
        Location newLocation = new Location(location.getProvider());
        newLocation.setLatitude(lat2 * 180.0 / Math.PI);
        newLocation.setLongitude(lon2 * 180.0 / Math.PI);
        newLocation.setAccuracy(location.getAccuracy());
        newLocation.setTime(location.getTime());
        return newLocation;
    }

    static String getDeviceId(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    private static String getFacebookClientToken() {
        try {
            Object clientTokenObj;
            Class<?> FacebookSdkClass = Class.forName("com.facebook.FacebookSdk");
            Method getClientTokenMethod = FacebookSdkClass.getMethod("getClientToken", new Class[0]);
            if (getClientTokenMethod != null && (clientTokenObj = getClientTokenMethod.invoke(FacebookSdkClass, new Object[0])) != null && clientTokenObj instanceof String) {
                Object applicationIdObj;
                String clientToken = (String)clientTokenObj;
                Method getApplicationIdMethod = FacebookSdkClass.getMethod("getApplicationId", new Class[0]);
                if (getApplicationIdMethod != null && (applicationIdObj = getApplicationIdMethod.invoke(FacebookSdkClass, new Object[0])) != null && applicationIdObj instanceof String) {
                    String applicationId = (String)applicationIdObj;
                    return applicationId + "|" + clientToken;
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    static String getFacebookAccessToken() {
        try {
            Method getTokenMethod;
            Object accessTokenObj;
            Object currentAccessTokenObj;
            Class<?> AccessTokenClass = Class.forName("com.facebook.AccessToken");
            Method getCurrentAccessTokenMethod = AccessTokenClass.getMethod("getCurrentAccessToken", new Class[0]);
            if (getCurrentAccessTokenMethod != null && (currentAccessTokenObj = getCurrentAccessTokenMethod.invoke(AccessTokenClass, new Object[0])) != null && (accessTokenObj = (getTokenMethod = AccessTokenClass.getMethod("getToken", new Class[0])).invoke(currentAccessTokenObj, new Object[0])) != null && accessTokenObj instanceof String) {
                return (String)accessTokenObj;
            }
        }
        catch (Exception e) {
            return _RadarUtils.getFacebookClientToken();
        }
        return _RadarUtils.getFacebookClientToken();
    }

    static String getUrbanAirshipChannelId() {
        try {
            Method getPushManagerMethod;
            Object sharedObj;
            Class<?> UAirshipClass = Class.forName("com.urbanairship.UAirship");
            Method sharedMethod = UAirshipClass.getMethod("shared", new Class[0]);
            if (sharedMethod != null && (sharedObj = sharedMethod.invoke(UAirshipClass, new Object[0])) != null && UAirshipClass.isInstance(sharedObj) && (getPushManagerMethod = UAirshipClass.getMethod("getPushManager", new Class[0])) != null) {
                Object channelIdObj;
                Method getChannelIdMethod;
                Class<?> PushManagerClass = Class.forName("com.urbanairship.push.PushManager");
                Object pushManagerObj = getPushManagerMethod.invoke(sharedObj, new Object[0]);
                if (pushManagerObj != null && PushManagerClass.isInstance(pushManagerObj) && (getChannelIdMethod = PushManagerClass.getMethod("getChannelId", new Class[0])) != null && (channelIdObj = getChannelIdMethod.invoke(pushManagerObj, new Object[0])) != null && channelIdObj instanceof String) {
                    return (String)channelIdObj;
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    static String getUrbanAirshipNamedUserId() {
        try {
            Method getNamedUser;
            Object sharedObj;
            Class<?> UAirshipClass = Class.forName("com.urbanairship.UAirship");
            Method sharedMethod = UAirshipClass.getMethod("shared", new Class[0]);
            if (sharedMethod != null && (sharedObj = sharedMethod.invoke(UAirshipClass, new Object[0])) != null && UAirshipClass.isInstance(sharedObj) && (getNamedUser = UAirshipClass.getMethod("getNamedUser", new Class[0])) != null) {
                Object idObj;
                Method getIdMethod;
                Class<?> NamedUserClass = Class.forName("com.urbanairship.push.NamedUser");
                Object namedUserObj = getNamedUser.invoke(sharedObj, new Object[0]);
                if (namedUserObj != null && NamedUserClass.isInstance(namedUserObj) && (getIdMethod = NamedUserClass.getMethod("getId", new Class[0])) != null && (idObj = getIdMethod.invoke(namedUserObj, new Object[0])) != null && idObj instanceof String) {
                    return (String)idObj;
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    static String getUrbanAirshipSessionId() {
        try {
            Method getAnalytics;
            Object sharedObj;
            Class<?> UAirshipClass = Class.forName("com.urbanairship.UAirship");
            Method sharedMethod = UAirshipClass.getMethod("shared", new Class[0]);
            if (sharedMethod != null && (sharedObj = sharedMethod.invoke(UAirshipClass, new Object[0])) != null && UAirshipClass.isInstance(sharedObj) && (getAnalytics = UAirshipClass.getMethod("getAnalytics", new Class[0])) != null) {
                Object idObj;
                Method getSessionIdMethod;
                Class<?> AnalyticsClass = Class.forName("com.urbanairship.analytics.Analytics");
                Object analyticsObj = getAnalytics.invoke(sharedObj, new Object[0]);
                if (analyticsObj != null && AnalyticsClass.isInstance(analyticsObj) && (getSessionIdMethod = AnalyticsClass.getMethod("getSessionId", new Class[0])) != null && (idObj = getSessionIdMethod.invoke(analyticsObj, new Object[0])) != null && idObj instanceof String) {
                    return (String)idObj;
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    static String getDeviceMake() {
        return Build.MANUFACTURER;
    }

    static String getDeviceModel() {
        return Build.MODEL;
    }

    static String getDeviceOS() {
        return Build.VERSION.RELEASE;
    }

    static String getCountry() {
        return Locale.getDefault().getCountry();
    }

    static int getTimeZoneOffset() {
        TimeZone timezone = Calendar.getInstance().getTimeZone();
        int offset = timezone.getRawOffset();
        if (timezone.inDaylightTime(new Date())) {
            offset += timezone.getDSTSavings();
        }
        return offset / 1000;
    }

    static String getSDKVersion() {
        return "1.3.8";
    }
}

