package com.onradar.sdk.model;

import org.json.JSONException;
import org.json.JSONObject;

public class RadarUserInsightsState {

    private boolean mHome;
    private boolean mOffice;
    private boolean mTraveling;

    public RadarUserInsightsState(boolean home, boolean office, boolean traveling) {
        mHome = home;
        mOffice = office;
        mTraveling = traveling;
    }

    public RadarUserInsightsState(JSONObject obj) throws JSONException {
        if (obj == null) {
            return;
        }

        if (obj.has("home") && !obj.isNull("home")) {
            mHome = obj.getBoolean("home");
        }

        if (obj.has("office") && !obj.isNull("office")) {
            mOffice = obj.getBoolean("office");
        }

        if (obj.has("traveling") && !obj.isNull("traveling")) {
            mTraveling = obj.getBoolean("traveling");
        }
    }

    /**
     * @return A boolean indicating whether the user is at home, based on learned home location.
     */
    public boolean getHome() {
        return mHome;
    }

    /**
     * @return A boolean indicating whether the user is at the office, based on learned office location.
     */
    public boolean getOffice() {
        return mOffice;
    }

    /**
     * @return A boolean indicating whether the user is traveling, based on learned home location.
     */
    public boolean getTraveling() {
        return mTraveling;
    }

}
