package com.onradar.sdk.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import org.json.JSONException;
import org.json.JSONObject;

public class RadarGeofence {

    private String mId;
    private String mDescription;
    private String mTag;
    private String mExternalId;
    private JSONObject mMetadata;

    public RadarGeofence(String _id, String description, String tag, String externalId) {
        mId = _id;
        mDescription = description;
        mTag = tag;
        mExternalId = externalId;
    }

    public RadarGeofence(JSONObject obj) throws JSONException {
        if (obj == null) {
            return;
        }

        if (obj.has("_id") && !obj.isNull("_id")) {
            mId = obj.getString("_id");
        }

        if (obj.has("description") && !obj.isNull("description")) {
            mDescription = obj.getString("description");
        }

        if (obj.has("tag") && !obj.isNull("tag")) {
            mTag = obj.getString("tag");
        }

        if (obj.has("externalId") && !obj.isNull("externalId")) {
            mExternalId = obj.getString("externalId");
        }

        if (obj.has("metadata") && !obj.isNull("metadata")) {
            mMetadata = obj.getJSONObject("metadata");
        }
    }

    /**
     * @return The unique ID for the geofence, provided by Radar.
     */
    public @NonNull String getId() {
        return mId;
    }

    /**
     * @return A description for the geofence.
     */
    public @NonNull String getDescription() {
        return mDescription;
    }

    /**
     * @return An optional group for the geofence.
     */
    public @Nullable String getTag() {
        return mTag;
    }

    /**
     * @return An optional external ID for the geofence.
     */
    public @Nullable String getExternalId() {
        return mExternalId;
    }

    /**
     * @return An optional set of custom key-value pairs for the geofence.
     */
    public @Nullable JSONObject getMetadata() {
        return mMetadata;
    }

}