/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk;

import android.app.job.JobParameters;
import android.app.job.JobService;
import android.content.Context;
import android.location.Location;
import android.os.Handler;
import android.os.PersistableBundle;
import android.support.annotation.RequiresApi;
import com.onradar.sdk._Radar;

@RequiresApi(value=22)
public final class _RadarJobService
extends JobService {
    static final int JOB_ID_LOCATION = 2;
    private Handler mHandler;

    public boolean onStartJob(final JobParameters params) {
        Context context = this.getApplicationContext();
        _Radar.getSharedInstance().initialize(context, null);
        final _RadarJobService service = this;
        if (this.mHandler == null) {
            this.mHandler = new Handler();
        }
        if (params.getJobId() == 2) {
            PersistableBundle extras = params.getExtras();
            double latitude = extras.getDouble("latitude");
            double longitude = extras.getDouble("longitude");
            float accuracy = (float)extras.getDouble("accuracy");
            boolean foreground = extras.getBoolean("foreground");
            boolean stopped = extras.getBoolean("stopped");
            Location location = new Location("radar");
            location.setLatitude(latitude);
            location.setLongitude(longitude);
            location.setAccuracy(accuracy);
            _Radar.getSharedInstance().sendLocation(location, foreground, stopped, null);
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    Context context = service.getApplicationContext();
                    service.jobFinished(params, false);
                }
            }, 10000L);
        }
        return true;
    }

    public boolean onStopJob(JobParameters params) {
        Context context = this.getApplicationContext();
        return false;
    }
}

