/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk;

import android.app.Activity;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.onradar.sdk.Radar;
import com.onradar.sdk.RadarCallback;
import com.onradar.sdk._RadarCallback;
import com.onradar.sdk._RadarClient;
import com.onradar.sdk._RadarJobService;
import com.onradar.sdk._RadarLocationRequest;
import com.onradar.sdk._RadarLogger;
import com.onradar.sdk._RadarReceiver;
import com.onradar.sdk._RadarSettings;
import com.onradar.sdk.model.RadarEvent;
import com.onradar.sdk.model.RadarUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.json.JSONObject;

class _Radar
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    private static _Radar sInstance;
    private Context mContext;
    private GoogleApiClient mGoogleApiClient;
    private final List<_RadarLocationRequest> mLocationRequests = Collections.synchronizedList(new ArrayList());
    private boolean mRequestLocationPending;
    private boolean mGoPending;
    private LocationListener mRequestLocationListener;
    private Handler mPermissionsHandler;
    private static final int INTERVAL = 150000;

    _Radar() {
    }

    static synchronized _Radar getSharedInstance() {
        if (sInstance == null) {
            sInstance = new _Radar();
        }
        return sInstance;
    }

    void initialize(Context context, String publishableKey) {
        if (context == null) {
            return;
        }
        this.mContext = context.getApplicationContext();
        if (publishableKey == null) {
            _RadarSettings.readPublishableKey(context);
        } else {
            _RadarSettings.setPublishableKey(context, publishableKey);
        }
        if (this.mGoogleApiClient == null) {
            this.mGoogleApiClient = new GoogleApiClient.Builder(this.mContext).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
        }
        if (this.mPermissionsHandler == null && Build.VERSION.SDK_INT >= 23 && ContextCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
            this.mPermissionsHandler = new Handler();
            final Date started = new Date();
            Runnable permissionsRunnable = new Runnable(){
                private boolean mGranted = false;

                @Override
                public void run() {
                    boolean granted;
                    boolean bl = granted = ContextCompat.checkSelfPermission((Context)_Radar.this.mContext, (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
                    if (granted && !this.mGranted) {
                        _RadarLogger.log(_Radar.this.mContext, "location permission granted");
                        this.mGranted = true;
                        _Radar.getSharedInstance().requestLocation();
                        return;
                    }
                    Date now = new Date();
                    if (now.getTime() - started.getTime() < 300000L) {
                        _Radar.this.mPermissionsHandler.postDelayed((Runnable)this, 1000L);
                    } else {
                        _RadarLogger.log(_Radar.this.mContext, "stopping location permissions checks");
                    }
                }
            };
            _RadarLogger.log(this.mContext, "starting location permissions checks");
            this.mPermissionsHandler.postDelayed(permissionsRunnable, 1000L);
        }
        _RadarSettings.setAdId(this.mContext);
    }

    void setUserId(String userId) {
        _RadarSettings.setUserId(this.mContext, userId);
    }

    void setDescription(String description) {
        _RadarSettings.setDescription(this.mContext, description);
    }

    void setMetadata(JSONObject metadata) {
        _RadarSettings.setMetadata(this.mContext, metadata);
    }

    void setPlacesProvider(Radar.RadarPlacesProvider provider) {
        _RadarSettings.setPlacesProvider(this.mContext, provider);
    }

    boolean checkSelfPermissions() {
        return Build.VERSION.SDK_INT < 23 || this.mContext != null && ContextCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
    }

    void requestPermissions(Activity activity) {
        if (Build.VERSION.SDK_INT >= 23 && ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
            int requestCode = 0;
            ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.ACCESS_FINE_LOCATION"}, (int)requestCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void trackOnce(RadarCallback callback) {
        String publishableKey = _RadarSettings.getPublishableKey(this.mContext);
        if (publishableKey == null || publishableKey.length() == 0) {
            if (callback != null) {
                callback.onCallback(Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, null);
            }
            this.sendErrorIntent(Radar.RadarStatus.ERROR_PUBLISHABLE_KEY);
            return;
        }
        if (!this.checkSelfPermissions()) {
            if (callback != null) {
                callback.onCallback(Radar.RadarStatus.ERROR_PERMISSIONS, null, null, null);
            }
            this.sendErrorIntent(Radar.RadarStatus.ERROR_PERMISSIONS);
            return;
        }
        List<_RadarLocationRequest> list = this.mLocationRequests;
        synchronized (list) {
            _RadarLocationRequest locationRequest = new _RadarLocationRequest(10000L, callback);
            this.mLocationRequests.add(locationRequest);
        }
        this.requestLocation();
    }

    void setTrackingPriority(Radar.RadarPriority priority) {
        _RadarSettings.setTrackingPriority(this.mContext, priority);
    }

    void startTracking() {
        String publishableKey = _RadarSettings.getPublishableKey(this.mContext);
        if (publishableKey == null || publishableKey.length() == 0) {
            this.sendErrorIntent(Radar.RadarStatus.ERROR_PUBLISHABLE_KEY);
            return;
        }
        if (!this.checkSelfPermissions()) {
            this.sendErrorIntent(Radar.RadarStatus.ERROR_PERMISSIONS);
            return;
        }
        _RadarSettings.setTracking(this.mContext, true);
        this.go();
        this.requestLocation();
    }

    void stopTracking() {
        _RadarSettings.setTracking(this.mContext, false);
        this.go();
    }

    boolean isTracking() {
        return _RadarSettings.getTracking(this.mContext);
    }

    void updateLocation(Location location, RadarCallback callback) {
        String publishableKey = _RadarSettings.getPublishableKey(this.mContext);
        if (publishableKey == null || publishableKey.length() == 0) {
            this.sendErrorIntent(Radar.RadarStatus.ERROR_PUBLISHABLE_KEY);
            return;
        }
        this.sendLocation(location, true, false, callback);
    }

    void acceptEvent(String eventId, String verifiedPlaceId) {
        _RadarClient.getSharedInstance().verifyEvent(this.mContext, eventId, RadarEvent.RadarEventVerification.ACCEPT, verifiedPlaceId);
    }

    void rejectEvent(String eventId) {
        _RadarClient.getSharedInstance().verifyEvent(this.mContext, eventId, RadarEvent.RadarEventVerification.REJECT, null);
    }

    private void requestLocation() {
        if (!this.checkSelfPermissions()) {
            return;
        }
        if (this.mGoogleApiClient != null && !this.mGoogleApiClient.isConnected()) {
            this.mRequestLocationPending = true;
            this.mGoogleApiClient.connect();
            return;
        }
        _RadarLogger.log(this.mContext, "request location");
        if (this.mRequestLocationListener == null) {
            this.mRequestLocationListener = new LocationListener(){

                public void onLocationChanged(Location location) {
                    if (location == null) {
                        return;
                    }
                    boolean stopped = _RadarSettings.isStopped(_Radar.this.mContext, location);
                    _RadarSettings.updateLastMovingLocation(_Radar.this.mContext, location);
                    _Radar.getSharedInstance().updateGeofences(location, stopped);
                    _Radar.getSharedInstance().sendLocation(location, true, stopped, null);
                    LocationServices.FusedLocationApi.removeLocationUpdates(_Radar.this.mGoogleApiClient, _Radar.this.mRequestLocationListener);
                }
            };
        }
        LocationRequest locationRequest = new LocationRequest().setInterval(5000L).setFastestInterval(1000L).setPriority(100);
        try {
            LocationServices.FusedLocationApi.requestLocationUpdates(this.mGoogleApiClient, locationRequest, this.mRequestLocationListener, Looper.getMainLooper());
        }
        catch (SecurityException e) {
            this.sendErrorIntent(Radar.RadarStatus.ERROR_LOCATION);
        }
    }

    private void backgroundSendLocation(Location location, boolean foreground, boolean stopped) {
        if (location == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 22) {
            ComponentName component = new ComponentName(this.mContext, _RadarJobService.class);
            PersistableBundle extras = new PersistableBundle();
            extras.putDouble("latitude", location.getLatitude());
            extras.putDouble("longitude", location.getLongitude());
            extras.putDouble("accuracy", (double)location.getAccuracy());
            extras.putBoolean("foreground", foreground);
            extras.putBoolean("stopped", stopped);
            JobInfo.Builder builder = new JobInfo.Builder(2, component).setExtras(extras).setMinimumLatency(0L).setOverrideDeadline(0L);
            JobInfo jobInfo = builder.build();
            JobScheduler jobScheduler = (JobScheduler)this.mContext.getSystemService("jobscheduler");
            jobScheduler.schedule(jobInfo);
        } else {
            this.sendLocation(location, foreground, stopped, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void sendLocation(final Location location, boolean foreground, boolean stopped, final RadarCallback callback) {
        _Radar _Radar2 = this;
        synchronized (_Radar2) {
            List<_RadarLocationRequest> list = this.mLocationRequests;
            synchronized (list) {
                for (_RadarLocationRequest locationRequest : this.mLocationRequests) {
                    locationRequest.stopTimer();
                }
            }
            if (location == null || location.getLatitude() == 0.0 || location.getLatitude() > 90.0 || location.getLatitude() < -90.0 || location.getLongitude() == 0.0 || location.getLongitude() > 180.0 || location.getLongitude() < -180.0 || location.getAccuracy() <= 0.0f) {
                Radar.RadarStatus status = Radar.RadarStatus.ERROR_LOCATION;
                if (callback != null) {
                    callback.onCallback(status, location, null, null);
                } else {
                    List<_RadarLocationRequest> list2 = this.mLocationRequests;
                    synchronized (list2) {
                        Iterator<_RadarLocationRequest> i = this.mLocationRequests.iterator();
                        while (i.hasNext()) {
                            _RadarLocationRequest locationRequest = i.next();
                            RadarCallback locationRequestCallback = locationRequest.getCallback();
                            if (locationRequestCallback != null) {
                                locationRequestCallback.onCallback(status, location, null, null);
                            }
                            i.remove();
                        }
                    }
                }
                _Radar.getSharedInstance().sendErrorIntent(status);
                return;
            }
            boolean force = foreground || stopped;
            Date now = new Date();
            Date sentAt = _RadarSettings.getSentAt(this.mContext);
            if (!force && sentAt != null && sentAt.getTime() - now.getTime() > -60000L) {
                _RadarLogger.log(this.mContext, "background rate limit");
                _RadarLogger.notify(this.mContext, "background rate limit");
                return;
            }
            _RadarSettings.updateSentAt(this.mContext);
            _RadarLogger.log(this.mContext, "sending location");
            _RadarLogger.notify(this.mContext, "sending location");
            _RadarClient.getSharedInstance().updateLocation(this.mContext, location, foreground, stopped, new _RadarCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onCallback(Radar.RadarStatus status, JSONObject response, RadarEvent[] events, RadarUser user) {
                    if (status == Radar.RadarStatus.SUCCESS) {
                        _RadarLogger.log(_Radar.this.mContext, "sent location");
                        _RadarLogger.notify(_Radar.this.mContext, "sent location");
                        if (callback != null) {
                            callback.onCallback(status, location, events, user);
                        } else {
                            List list = _Radar.this.mLocationRequests;
                            synchronized (list) {
                                Iterator i = _Radar.this.mLocationRequests.iterator();
                                while (i.hasNext()) {
                                    _RadarLocationRequest locationRequest = (_RadarLocationRequest)i.next();
                                    RadarCallback callback2 = locationRequest.getCallback();
                                    if (callback2 != null) {
                                        callback2.onCallback(status, location, events, user);
                                    }
                                    i.remove();
                                }
                            }
                        }
                        _Radar.getSharedInstance().sendSuccessIntent(response, location);
                        if (user != null) {
                            _RadarSettings.setRadarId(_Radar.this.mContext, user.getId());
                        }
                    } else {
                        _RadarLogger.log(_Radar.this.mContext, "error sending location: " + (Object)((Object)status));
                        _RadarLogger.notify(_Radar.this.mContext, "error sending location: " + (Object)((Object)status));
                        _RadarSettings.clearStoppedAt(_Radar.this.mContext);
                        if (callback != null) {
                            callback.onCallback(status, location, null, null);
                        } else {
                            List list = _Radar.this.mLocationRequests;
                            synchronized (list) {
                                Iterator i = _Radar.this.mLocationRequests.iterator();
                                while (i.hasNext()) {
                                    _RadarLocationRequest locationRequest = (_RadarLocationRequest)i.next();
                                    RadarCallback callback3 = locationRequest.getCallback();
                                    if (callback3 != null) {
                                        callback3.onCallback(status, null, null, null);
                                    }
                                    i.remove();
                                }
                                _Radar.this.mLocationRequests.clear();
                            }
                        }
                        _Radar.getSharedInstance().sendErrorIntent(status);
                    }
                }
            });
        }
    }

    private void updateGeofences(Location location, boolean stopped) {
        if (!this.checkSelfPermissions()) {
            return;
        }
        if (this.mGoogleApiClient == null) {
            return;
        }
        if (!this.mGoogleApiClient.isConnected()) {
            this.mGoogleApiClient.connect();
            return;
        }
        if (!_RadarSettings.getTracking(this.mContext)) {
            return;
        }
        if (_RadarSettings.getTrackingPriority(this.mContext) == Radar.RadarPriority.EFFICIENCY) {
            return;
        }
        if (location == null || location.getLatitude() == 0.0 || location.getLatitude() > 90.0 || location.getLatitude() < -90.0 || location.getLongitude() == 0.0 || location.getLongitude() > 180.0 || location.getLongitude() < -180.0) {
            return;
        }
        Geofence.Builder exitDwell0GeofenceBuilder = new Geofence.Builder().setRequestId("radar_exit_dwell_0").setCircularRegion(location.getLatitude(), location.getLongitude(), 100.0f).setExpirationDuration(-1L);
        Geofence.Builder exitDwell1GeofenceBuilder = new Geofence.Builder().setRequestId("radar_exit_dwell_1").setCircularRegion(location.getLatitude(), location.getLongitude(), 100.0f).setExpirationDuration(-1L);
        Geofence.Builder exitDwell2GeofenceBuilder = new Geofence.Builder().setRequestId("radar_exit_dwell_2").setCircularRegion(location.getLatitude(), location.getLongitude(), 100.0f).setExpirationDuration(-1L);
        if (stopped) {
            exitDwell0GeofenceBuilder = exitDwell0GeofenceBuilder.setTransitionTypes(2);
            exitDwell1GeofenceBuilder = exitDwell1GeofenceBuilder.setTransitionTypes(2);
            exitDwell2GeofenceBuilder = exitDwell2GeofenceBuilder.setTransitionTypes(2);
        } else {
            exitDwell0GeofenceBuilder = exitDwell0GeofenceBuilder.setTransitionTypes(6).setLoiteringDelay(150000);
            exitDwell1GeofenceBuilder = exitDwell1GeofenceBuilder.setTransitionTypes(6).setLoiteringDelay(300000);
            exitDwell2GeofenceBuilder = exitDwell2GeofenceBuilder.setTransitionTypes(6).setLoiteringDelay(450000);
        }
        Geofence exitDwell0Geofence = exitDwell0GeofenceBuilder.build();
        Geofence exitDwell1Geofence = exitDwell1GeofenceBuilder.build();
        Geofence exitDwell2Geofence = exitDwell2GeofenceBuilder.build();
        GeofencingRequest.Builder exitDwellGeofencingRequestBuilder = new GeofencingRequest.Builder().addGeofence(exitDwell0Geofence).addGeofence(exitDwell1Geofence).addGeofence(exitDwell2Geofence);
        if (stopped) {
            exitDwellGeofencingRequestBuilder.setInitialTrigger(2);
        } else {
            exitDwellGeofencingRequestBuilder.setInitialTrigger(6);
        }
        GeofencingRequest exitDwellGeofencingRequest = exitDwellGeofencingRequestBuilder.build();
        Intent exitDwellIntent = new Intent(this.mContext, _RadarReceiver.class);
        exitDwellIntent.setAction("com.onradar.sdk._RadarReceiver.GEOFENCE_TRANSITIONED");
        PendingIntent exitDwellPendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)exitDwellIntent, (int)0x8000000);
        try {
            PendingResult result = LocationServices.GeofencingApi.addGeofences(this.mGoogleApiClient, exitDwellGeofencingRequest, exitDwellPendingIntent);
            result.setResultCallback((ResultCallback)new ResultCallback<Status>(){

                public void onResult(@NonNull Status status) {
                    if (status.isSuccess()) {
                        _RadarLogger.log(_Radar.this.mContext, "updated exit geofences");
                    } else {
                        _RadarLogger.log(_Radar.this.mContext, "error adding exit geofences: " + status);
                    }
                }
            });
        }
        catch (SecurityException e) {
            _RadarLogger.log(this.mContext, "exception adding exit geofences: " + e.getMessage());
        }
    }

    private void removeGeofences() {
        if (!this.checkSelfPermissions()) {
            return;
        }
        if (this.mGoogleApiClient == null) {
            return;
        }
        if (!this.mGoogleApiClient.isConnected()) {
            this.mGoogleApiClient.connect();
            return;
        }
        try {
            final ArrayList<String> requestIds = new ArrayList<String>();
            requestIds.add("radar_enter_0");
            requestIds.add("radar_enter_1");
            requestIds.add("radar_enter_2");
            requestIds.add("radar_enter_3");
            requestIds.add("radar_enter_4");
            requestIds.add("radar_enter_5");
            requestIds.add("radar_enter_6");
            requestIds.add("radar_enter_7");
            requestIds.add("radar_exit_dwell_0");
            requestIds.add("radar_exit_dwell_1");
            requestIds.add("radar_exit_dwell_2");
            PendingResult result = LocationServices.GeofencingApi.removeGeofences(this.mGoogleApiClient, requestIds);
            result.setResultCallback((ResultCallback)new ResultCallback<Status>(){

                public void onResult(@NonNull Status status) {
                    if (status.isSuccess()) {
                        _RadarLogger.log(_Radar.this.mContext, "removed geofence: " + requestIds);
                    } else {
                        _RadarLogger.log(_Radar.this.mContext, "error removing geofences: " + status);
                    }
                }
            });
        }
        catch (SecurityException e) {
            _RadarLogger.log(this.mContext, "exception removing geofence: " + e.getMessage());
        }
    }

    private void go() {
        if (this.mGoogleApiClient == null) {
            return;
        }
        if (!this.mGoogleApiClient.isConnected()) {
            this.mGoPending = true;
            this.mGoogleApiClient.connect();
            return;
        }
        if (_RadarSettings.getTracking(this.mContext) && this.checkSelfPermissions()) {
            _RadarLogger.log(this.mContext, "go tracking");
            this.removeLocationUpdates();
            Date stoppedAt = _RadarSettings.getStoppedAt(this.mContext);
            if (stoppedAt != null) {
                this.requestLocationUpdatesStopped();
            } else {
                this.requestLocationUpdatesMoving();
            }
        } else {
            _RadarLogger.log(this.mContext, "go not tracking");
            this.removeLocationUpdates();
            this.removeGeofences();
        }
    }

    private void requestLocationUpdatesMoving() {
        if (!this.checkSelfPermissions()) {
            return;
        }
        if (this.mGoogleApiClient == null) {
            return;
        }
        if (!this.mGoogleApiClient.isConnected()) {
            this.mGoogleApiClient.connect();
            return;
        }
        boolean efficiency = _RadarSettings.getTrackingPriority(this.mContext) == Radar.RadarPriority.EFFICIENCY;
        _RadarLogger.log(this.mContext, "using " + (efficiency ? "efficiency" : "responsiveness") + " mode");
        _RadarLogger.notify(this.mContext, "using " + (efficiency ? "efficiency" : "responsiveness") + " mode");
        LocationRequest locationRequest = new LocationRequest().setPriority(102).setFastestInterval(150000L).setInterval(efficiency ? 360000L : 150000L).setMaxWaitTime(900000L);
        Intent intent = new Intent(this.mContext, _RadarReceiver.class);
        intent.setAction("com.onradar.sdk._RadarReceiver.LOCATIONS_RECEIVED");
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0x8000000);
        try {
            LocationServices.FusedLocationApi.requestLocationUpdates(this.mGoogleApiClient, locationRequest, pendingIntent);
        }
        catch (SecurityException se) {
            _RadarLogger.log(this.mContext, "error requesting location updates moving");
        }
    }

    private void requestLocationUpdatesStopped() {
        if (!this.checkSelfPermissions()) {
            return;
        }
        if (this.mGoogleApiClient == null) {
            return;
        }
        if (!this.mGoogleApiClient.isConnected()) {
            this.mGoogleApiClient.connect();
            return;
        }
        LocationRequest locationRequest = new LocationRequest().setPriority(102).setFastestInterval(900000L).setInterval(3600000L).setMaxWaitTime(3600000L);
        Intent intent = new Intent(this.mContext, _RadarReceiver.class);
        intent.setAction("com.onradar.sdk._RadarReceiver.LOCATIONS_RECEIVED");
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0x8000000);
        try {
            LocationServices.FusedLocationApi.requestLocationUpdates(this.mGoogleApiClient, locationRequest, pendingIntent);
        }
        catch (SecurityException se) {
            _RadarLogger.log(this.mContext, "error requesting location updates stopped");
        }
    }

    private void removeLocationUpdates() {
        if (this.mGoogleApiClient == null) {
            return;
        }
        if (!this.mGoogleApiClient.isConnected()) {
            this.mGoogleApiClient.connect();
            return;
        }
        Intent intent = new Intent(this.mContext, _RadarReceiver.class);
        intent.setAction("com.onradar.sdk._RadarReceiver.LOCATIONS_RECEIVED");
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0x8000000);
        try {
            LocationServices.FusedLocationApi.removeLocationUpdates(this.mGoogleApiClient, pendingIntent);
        }
        catch (SecurityException se) {
            _RadarLogger.log(this.mContext, "error removing location updates");
        }
    }

    private void sendSuccessIntent(JSONObject response, Location location) {
        if (this.mContext == null || response == null) {
            return;
        }
        String json = response.toString();
        Intent intent = new Intent("com.onradar.sdk.RECEIVED");
        intent.putExtra("response", json);
        intent.putExtra("location", (Parcelable)location);
        this.sendImplicitBroadcast(intent);
    }

    private void sendErrorIntent(Radar.RadarStatus status) {
        if (this.mContext == null) {
            return;
        }
        Intent intent = new Intent("com.onradar.sdk.RECEIVED");
        intent.putExtra("status", status.ordinal());
        this.sendImplicitBroadcast(intent);
    }

    private void sendImplicitBroadcast(Intent intent) {
        if (this.mContext == null || intent == null) {
            return;
        }
        try {
            PackageManager packageManager = this.mContext.getPackageManager();
            List matches = packageManager.queryBroadcastReceivers(intent, 0);
            for (ResolveInfo resolveInfo : matches) {
                Intent explicitIntent = new Intent(intent);
                if (this.mContext.getPackageName().equals(resolveInfo.activityInfo.applicationInfo.packageName)) {
                    ComponentName componentName = new ComponentName(resolveInfo.activityInfo.applicationInfo.packageName, resolveInfo.activityInfo.name);
                    explicitIntent.setComponent(componentName);
                    _RadarLogger.log(this.mContext, "sending broadcast: " + resolveInfo.activityInfo.name);
                }
                this.mContext.sendBroadcast(explicitIntent);
            }
        }
        catch (Exception e) {
            _RadarLogger.log(this.mContext, "error sending broadcast: " + e.getMessage());
        }
    }

    private void handleLocationResult(LocationResult locationResult) {
        if (locationResult == null) {
            return;
        }
        Location location = null;
        try {
            location = locationResult.getLastLocation();
        }
        catch (Exception e) {
            _RadarLogger.log(this.mContext, "error handling location result: " + e.getMessage());
        }
        if (location == null) {
            return;
        }
        _RadarLogger.log(this.mContext, "updated location with accuracy: " + location.getAccuracy());
        _RadarLogger.notify(this.mContext, "updated location with accuracy: " + location.getAccuracy());
        Date stoppedAt = _RadarSettings.getStoppedAt(this.mContext);
        boolean stopped = _RadarSettings.isStopped(this.mContext, location);
        _RadarSettings.updateLastMovingLocation(this.mContext, location);
        if (stoppedAt == null) {
            if (stopped) {
                this.removeLocationUpdates();
                this.requestLocationUpdatesStopped();
                _RadarLogger.log(this.mContext, "stopped, requested location updates stopped");
                _RadarLogger.notify(this.mContext, "stopped, requested location updates stopped");
            }
            this.updateGeofences(location, stopped);
            this.backgroundSendLocation(location, false, stopped);
        } else if (!stopped) {
            this.removeLocationUpdates();
            this.requestLocationUpdatesMoving();
            _RadarLogger.log(this.mContext, "was stopped, restarted location updates moving");
            _RadarLogger.notify(this.mContext, "was stopped, restarted location updates moving");
        } else {
            _RadarLogger.log(this.mContext, "already stopped");
            _RadarLogger.notify(this.mContext, "already stopped");
        }
    }

    private void handleGeofencingEvent(GeofencingEvent geofencingEvent) {
        Date stoppedAt;
        if (geofencingEvent == null) {
            return;
        }
        Location location = null;
        try {
            location = geofencingEvent.getTriggeringLocation();
        }
        catch (Exception e) {
            _RadarLogger.log(this.mContext, "error handling geofencing event: " + e.getMessage());
        }
        if (location == null) {
            return;
        }
        List geofences = null;
        try {
            geofences = geofencingEvent.getTriggeringGeofences();
        }
        catch (Exception e) {
            _RadarLogger.log(this.mContext, "error handling geofencing event: " + e.getMessage());
        }
        if (geofences == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < geofences.size(); ++i) {
            Geofence triggeringGeofence = (Geofence)geofences.get(i);
            sb.append(triggeringGeofence.getRequestId());
            if (i >= geofences.size() - 1) continue;
            sb.append(", ");
        }
        String geofenceIds = sb.toString();
        if (geofencingEvent.getGeofenceTransition() == 2) {
            _RadarLogger.log(this.mContext, "exited geofences " + geofenceIds + " with accuracy: " + location.getAccuracy());
            _RadarLogger.notify(this.mContext, "exited geofences " + geofenceIds + " with accuracy: " + location.getAccuracy());
            stoppedAt = _RadarSettings.getStoppedAt(this.mContext);
            boolean stopped = _RadarSettings.isStopped(this.mContext, location);
            _RadarSettings.updateLastMovingLocation(this.mContext, location);
            if (stoppedAt == null) {
                if (stopped) {
                    this.removeLocationUpdates();
                    this.requestLocationUpdatesStopped();
                    _RadarLogger.log(this.mContext, "stopped, requested location updates stopped");
                    _RadarLogger.notify(this.mContext, "stopped, requested location updates stopped");
                }
                this.updateGeofences(location, stopped);
                this.backgroundSendLocation(location, false, stopped);
            } else if (!stopped) {
                this.removeLocationUpdates();
                this.requestLocationUpdatesMoving();
                _RadarLogger.log(this.mContext, "was stopped, restarted location updates moving");
                _RadarLogger.notify(this.mContext, "was stopped, restarted location updates moving");
            } else {
                _RadarLogger.log(this.mContext, "already stopped");
                _RadarLogger.notify(this.mContext, "already stopped");
            }
        } else if (geofencingEvent.getGeofenceTransition() == 1) {
            _RadarLogger.log(this.mContext, "entered geofences " + geofenceIds + " with accuracy: " + location.getAccuracy());
            _RadarLogger.notify(this.mContext, "entered geofences " + geofenceIds + " with accuracy: " + location.getAccuracy());
            stoppedAt = _RadarSettings.getStoppedAt(this.mContext);
            boolean stopped = _RadarSettings.isStopped(this.mContext, location);
            _RadarSettings.updateLastMovingLocation(this.mContext, location);
            if (stoppedAt == null) {
                if (stopped) {
                    this.removeLocationUpdates();
                    this.requestLocationUpdatesStopped();
                    _RadarLogger.log(this.mContext, "stopped, requested location updates stopped");
                    _RadarLogger.notify(this.mContext, "stopped, requested location updates stopped");
                }
                this.updateGeofences(location, stopped);
                this.backgroundSendLocation(location, false, stopped);
            } else if (!stopped) {
                this.removeLocationUpdates();
                this.requestLocationUpdatesMoving();
                _RadarLogger.log(this.mContext, "was stopped, restarted location updates moving");
                _RadarLogger.notify(this.mContext, "was stopped, restarted location updates moving");
            } else {
                _RadarLogger.log(this.mContext, "already stopped");
                _RadarLogger.notify(this.mContext, "already stopped");
            }
        } else if (geofencingEvent.getGeofenceTransition() == 4) {
            _RadarLogger.log(this.mContext, "dwelled in geofences " + geofenceIds + " with accuracy: " + location.getAccuracy());
            _RadarLogger.notify(this.mContext, "dwelled in geofences " + geofenceIds + " with accuracy: " + location.getAccuracy());
            stoppedAt = _RadarSettings.getStoppedAt(this.mContext);
            boolean stopped = _RadarSettings.isStopped(this.mContext, location);
            _RadarSettings.updateLastMovingLocation(this.mContext, location);
            if (stoppedAt == null) {
                if (stopped) {
                    this.removeLocationUpdates();
                    this.requestLocationUpdatesStopped();
                    _RadarLogger.log(this.mContext, "stopped, requested location updates stopped");
                    _RadarLogger.notify(this.mContext, "stopped, requested location updates stopped");
                }
                this.updateGeofences(location, stopped);
                this.backgroundSendLocation(location, false, stopped);
            } else if (!stopped) {
                this.removeLocationUpdates();
                this.requestLocationUpdatesMoving();
                _RadarLogger.log(this.mContext, "was stopped, restarted location updates moving");
                _RadarLogger.notify(this.mContext, "was stopped, restarted location updates moving");
            } else {
                _RadarLogger.log(this.mContext, "already stopped");
                _RadarLogger.notify(this.mContext, "already stopped");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void didTimeout(_RadarLocationRequest locationRequest) {
        _RadarLogger.log(this.mContext, "timeout");
        if (this.mRequestLocationListener != null && this.mGoogleApiClient.isConnected()) {
            LocationServices.FusedLocationApi.removeLocationUpdates(this.mGoogleApiClient, this.mRequestLocationListener);
        }
        locationRequest.stopTimer();
        RadarCallback callback = locationRequest.getCallback();
        if (callback != null) {
            callback.onCallback(Radar.RadarStatus.ERROR_LOCATION, null, null, null);
        }
        List<_RadarLocationRequest> list = this.mLocationRequests;
        synchronized (list) {
            this.mLocationRequests.remove(locationRequest);
        }
        this.sendErrorIntent(Radar.RadarStatus.ERROR_LOCATION);
    }

    public void onConnected(Bundle connectionHint) {
        _RadarLogger.log(this.mContext, "Play Services connected");
        if (this.mRequestLocationPending) {
            this.mRequestLocationPending = false;
            this.requestLocation();
        }
        if (this.mGoPending) {
            this.mGoPending = false;
            this.go();
        }
    }

    public void onConnectionFailed(@NonNull ConnectionResult result) {
        _RadarLogger.log(this.mContext, "Play Services connection failed");
        this.sendErrorIntent(Radar.RadarStatus.ERROR_LOCATION);
    }

    public void onConnectionSuspended(int cause) {
        _RadarLogger.log(this.mContext, "Play Services connection suspended");
        this.sendErrorIntent(Radar.RadarStatus.ERROR_LOCATION);
    }

    void onHandleIntent(Intent intent) {
        if (intent == null || !_RadarSettings.getTracking(this.mContext)) {
            return;
        }
        if ("android.intent.action.BOOT_COMPLETED".equals(intent.getAction())) {
            _RadarSettings.clearStoppedAt(this.mContext);
            this.go();
        } else if ("com.onradar.sdk._RadarReceiver.LOCATIONS_RECEIVED".equals(intent.getAction())) {
            try {
                LocationResult locationResult = LocationResult.extractResult((Intent)intent);
                this.handleLocationResult(locationResult);
            }
            catch (Exception e) {
                _RadarLogger.log(this.mContext, "error extracting location result: " + e.getMessage());
            }
        } else if ("com.onradar.sdk._RadarReceiver.GEOFENCE_TRANSITIONED".equals(intent.getAction())) {
            GeofencingEvent geofencingEvent = GeofencingEvent.fromIntent((Intent)intent);
            this.handleGeofencingEvent(geofencingEvent);
        }
    }
}

