package com.onradar.sdk;

import android.location.Location;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.onradar.sdk.Radar.RadarStatus;
import com.onradar.sdk.model.RadarEvent;
import com.onradar.sdk.model.RadarUser;

public abstract class RadarCallback {

    /**
     * Called when a request succeeds, times out, or fails.
     *
     * @param status The request status.
     * @param location The current location.
     * @param events The events generated, if any.
     * @param user The current user.
     */
    public abstract void onCallback(@NonNull RadarStatus status, @Nullable Location location, @Nullable RadarEvent[] events, @Nullable RadarUser user);

}
