package com.onradar.sdk.model;

import org.json.JSONException;
import org.json.JSONObject;

public class RadarChain {

    private String mSlug;
    private String mName;

    public RadarChain(String slug, String name) {
        mSlug = slug;
        mName = name;
    }

    public RadarChain(JSONObject obj) throws JSONException {
        if (obj == null) {
            return;
        }

        if (obj.has("slug") && !obj.isNull("slug")) {
            mSlug = obj.getString("slug");
        }

        if (obj.has("name") && !obj.isNull("name")) {
            mName = obj.getString("name");
        }
    }

    /**
     * @return A human-readable unique ID for the chain, provided by Radar.
     */
    public String getSlug() {
        return mSlug;
    }

    /**
     * @return The name of the chain.
     */
    public String getName() {
        return mName;
    }

}