/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import com.onradar.sdk.R;
import com.onradar.sdk._RadarSettings;

class _RadarLogger {
    private static final String TAG = "_RadarLogger";
    private static int sNextNotificationId;

    _RadarLogger() {
    }

    private static int getNextNotificationId() {
        return ++sNextNotificationId;
    }

    static void log(Context context, String message) {
        if (!_RadarSettings.isDebug(context)) {
            return;
        }
        Log.d((String)TAG, (String)message);
    }

    static void notify(Context context, String message) {
        if (!_RadarSettings.isDebug(context)) {
            return;
        }
        String channelId = "radar-debug";
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            int importance = 2;
            NotificationChannel channel = new NotificationChannel("radar-debug", (CharSequence)"radar-debug", importance);
            channel.enableVibration(true);
            notificationManager.createNotificationChannel(channel);
        }
        Notification notification = new NotificationCompat.Builder(context, "radar-debug").setContentText((CharSequence)message).setSmallIcon(R.drawable.notification).build();
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        int nextNotificationId = _RadarLogger.getNextNotificationId();
        notificationManager.cancel(TAG, nextNotificationId - 50);
        notificationManager.notify(TAG, nextNotificationId, notification);
    }
}

