/*
 * Decompiled with CFR 0.152.
 */
package com.onradar.sdk.model;

import com.onradar.sdk.model.RadarChain;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RadarPlace {
    private String mId;
    private String mFacebookId;
    private String mName;
    private String[] mCategories;
    private RadarChain mChain;

    public RadarPlace(String _id, String facebookId, String name, String[] categories, RadarChain chain) {
        this.mId = _id;
        this.mFacebookId = facebookId;
        this.mName = name;
        this.mCategories = categories;
        this.mChain = chain;
    }

    public RadarPlace(JSONObject obj) throws JSONException {
        if (obj == null) {
            return;
        }
        if (obj.has("_id") && !obj.isNull("_id")) {
            this.mId = obj.getString("_id");
        }
        if (obj.has("facebookId") && !obj.isNull("facebookId")) {
            this.mFacebookId = obj.getString("facebookId");
        }
        if (obj.has("name") && !obj.isNull("name")) {
            this.mName = obj.getString("name");
        }
        if (obj.has("categories") && !obj.isNull("categories")) {
            JSONArray categoriesArray = obj.getJSONArray("categories");
            int numCategories = categoriesArray.length();
            this.mCategories = new String[numCategories];
            for (int i = 0; i < numCategories; ++i) {
                this.mCategories[i] = categoriesArray.getString(i);
            }
        }
        if (obj.has("chain") && !obj.isNull("chain")) {
            JSONObject chainObj = obj.getJSONObject("chain");
            this.mChain = new RadarChain(chainObj);
        }
    }

    public String getId() {
        return this.mId;
    }

    public String getFacebookId() {
        return this.mFacebookId;
    }

    public String getName() {
        return this.mName;
    }

    public String[] getCategories() {
        return this.mCategories;
    }

    public RadarChain getChain() {
        return this.mChain;
    }

    public boolean isChain(String slug) {
        if (this.mChain == null || this.mChain.getSlug() == null) {
            return false;
        }
        return this.mChain.getSlug().equals(slug);
    }

    public boolean hasCategory(String category) {
        if (this.mCategories == null) {
            return false;
        }
        for (int i = 0; i < this.mCategories.length; ++i) {
            if (!this.mCategories[i].equals(category)) continue;
            return true;
        }
        return false;
    }
}

